/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jp.sourceforge.jirc.AbstractClient;
import jp.sourceforge.jirc.Channel;
import jp.sourceforge.jirc.ChildWindow;
import jp.sourceforge.jirc.ConnectionDialog;
import jp.sourceforge.jirc.IRC;
import jp.sourceforge.jirc.IRCMenuBar;
import jp.sourceforge.jirc.IRCMessageFormat;

class Window
extends AbstractClient {
    private String applName = "jIRC";
    private Channel nowChannel = null;
    private final String CRLF = "\r\n";
    private JFrame frame = new JFrame();
    private JTextArea listenTA;
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    private JTree tree = new JTree(this.treeModel);
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);
    private ConnectionDialog connectionDialog = null;
    private Hashtable serverTable = new Hashtable();
    private Hashtable nodeTable = new Hashtable();

    public Window() {
        this.frame.addWindowListener(new WindowListenerImpl());
        this.tree.addTreeSelectionListener(new TreeSelectionListenerImpl());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        ((Component)this.frame).setSize(500, 350);
        this.init(this.frame.getContentPane());
    }

    public Window(JApplet applet) {
        applet.setSize(640, 480);
        this.init(applet.getContentPane());
    }

    public void Connection() {
        if (this.connectionDialog == null) {
            new ConnectionDialog(this);
        } else {
            this.connectionDialog.show();
        }
    }

    public void Connection(String server, int port, String nick, String user, String passwd) {
        try {
            super.Connection(server, port, nick, user, passwd);
            this.frame.pack();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage());
        }
    }

    public void setConnection(IRC irc, boolean flag) {
        if (this.irc.equals(irc)) {
            IRCMenuBar bar = (IRCMenuBar)this.frame.getJMenuBar();
            bar.setConnected(flag);
        }
    }

    private void init(Container container) {
        this.listenTA = this.getListenJTA();
        JScrollPane listenPane = new JScrollPane(this.listenTA, 22, 31);
        JScrollPane treePane = new JScrollPane(this.tree, 22, 31);
        JSplitPane splitPane = new JSplitPane(0, this.cardPanel, listenPane);
        container.add((Component)splitPane, "Center");
        container.add((Component)treePane, "West");
        container.setVisible(true);
        splitPane.setDividerLocation(0.6);
    }

    public synchronized void addParentWindow(ChildWindow cw) {
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(cw.getName());
        this.rootNode.insert(treeNode, this.rootNode.getChildCount());
        this.nodeTable.put(cw.getIRC().getServer(), treeNode);
        this.serverTable.put(cw.getName(), cw);
        this.setChannel(cw);
        this.treeModel.reload(this.rootNode);
    }

    public synchronized void addChannel(ChildWindow cw) {
        MutableTreeNode serverNode = (MutableTreeNode)this.nodeTable.get(cw.getIRC().getServer());
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(cw.getName());
        serverNode.insert(treeNode, serverNode.getChildCount());
        this.nodeTable.put(cw.getIRC().getServer() + cw.getName(), treeNode);
        this.setChannel(cw);
        this.treeModel.reload(serverNode);
        this.tree.expandRow(0);
    }

    private void setChannel(ChildWindow cw) {
        this.cardPanel.add((Component)cw, cw.getName());
        cw.requestTextFieldFocus();
        this.cardLayout.show(this.cardPanel, cw.getName());
        this.treeModel.reload();
        this.setNowChannel(cw);
    }

    public synchronized void removeParentWindow(Channel channel) {
        MutableTreeNode treeNode = (MutableTreeNode)this.nodeTable.get(channel.getName());
        this.nodeTable.remove(channel.getName());
        this.rootNode.remove(treeNode);
        this.removeWindow(channel);
        this.treeModel.reload();
    }

    public void removeChannel(Channel channel) {
        MutableTreeNode treeNode = (MutableTreeNode)this.nodeTable.get(channel.getIRC().getServer() + channel.getName());
        if (treeNode != null) {
            this.nodeTable.remove(channel.getIRC().getServer() + channel.getName());
            MutableTreeNode serverNode = (MutableTreeNode)this.nodeTable.get(channel.getIRC().getServer());
            serverNode.remove(treeNode);
            this.removeWindow(channel);
            this.treeModel.reload(this.rootNode);
        }
    }

    private void removeWindow(Channel channel) {
        ChildWindow cw = (ChildWindow)this.serverTable.get(channel.getName());
        if (cw == null) {
            cw = (ChildWindow)channel;
        }
        this.cardLayout.removeLayoutComponent(cw);
    }

    private JTextArea getListenJTA() {
        JTextArea ta = new JTextArea();
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        return ta;
    }

    public void setNowChannel(String serverName, String channelName) {
        Channel server = (Channel)this.serverTable.get(serverName);
        Channel channel = server.getIRC().getChannel(channelName);
        if (channel != null) {
            this.setNowChannel(channel);
        }
    }

    public void setNowChannel(Channel channel) {
        this.cardLayout.show(this.cardPanel, channel.getName());
        this.nowChannel = channel;
        this.setTopic();
    }

    public Channel getNowChannel() {
        return this.nowChannel;
    }

    public Channel getNowServer() {
        Channel channel = (Channel)this.serverTable.get(this.nowChannel);
        if (channel == null) {
            channel = (Channel)this.serverTable.get(this.nowChannel.getIRC().getServer());
        }
        return channel;
    }

    public void setTopic() {
        String title = "";
        if (this.nowChannel != null) {
            title = title + this.nowChannel.getName() + ' ' + this.nowChannel.getMode().toString() + ' ' + this.nowChannel.getTopic() + " - ";
        }
        this.setTopic(title);
    }

    private void setTopic(String string) {
        this.frame.setTitle(string + this.applName);
    }

    public void addUser(Channel channel, String nick) {
        MutableTreeNode treeNode = this.getChannelTreeNode(channel);
        if (!this.hasUser(treeNode, nick)) {
            treeNode.insert(new DefaultMutableTreeNode(nick), treeNode.getChildCount());
            this.treeModel.reload(treeNode);
        }
    }

    private boolean hasUser(MutableTreeNode treeNode, String nick) {
        Enumeration<? extends TreeNode> e = treeNode.children();
        if (e != null) {
            while (e.hasMoreElements()) {
                MutableTreeNode childNode = (MutableTreeNode)e.nextElement();
                if (!childNode.toString().equals(nick)) continue;
                return true;
            }
        }
        return false;
    }

    public Channel makeChannel(String name) {
        ChildWindow cw = new ChildWindow(name, this.irc, this);
        this.addChannel(cw);
        return cw;
    }

    public Channel makeServerChannel(String name) {
        ChildWindow cw = new ChildWindow(name, this.irc, this);
        this.addParentWindow(cw);
        return cw;
    }

    public boolean removeUser(Channel channel, String nick) {
        MutableTreeNode treeNode = this.getChannelTreeNode(channel);
        if (treeNode == null) {
            return false;
        }
        MutableTreeNode userNode = this.getUserNode(treeNode, nick);
        if (userNode != null) {
            treeNode.remove(userNode);
            this.treeModel.reload(treeNode);
            return true;
        }
        return false;
    }

    public void removeUser(IRC irc, String nick, String message) {
        Enumeration channels = irc.getChannels();
        while (channels.hasMoreElements()) {
            Channel channel = (Channel)channels.nextElement();
            if (!this.removeUser(channel, nick)) continue;
            String[] args = new String[]{nick, message};
            channel.append(IRCMessageFormat.getQuitMessage(args));
        }
    }

    public void setChanop(Channel channel, String nick, boolean flag) {
        this.setUserMode(channel, nick, "@", flag);
    }

    public void setVoice(Channel channel, String nick, boolean flag) {
        MutableTreeNode childNode = this.getUserNode(this.getChannelTreeNode(channel), nick);
        char head = childNode.toString().charAt(0);
        if (head != '@') {
            this.setUserMode(channel, nick, "+", flag);
        }
    }

    private void changeUserNode(MutableTreeNode channel, MutableTreeNode oldNick, String newNick) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(newNick);
        channel.remove(oldNick);
        channel.insert(node, channel.getChildCount());
        this.treeModel.reload(channel);
    }

    private void setUserMode(Channel channel, String nick, String mode, boolean flag) {
        MutableTreeNode childNode;
        MutableTreeNode treeNode = this.getChannelTreeNode(channel);
        if (treeNode != null && (childNode = this.getUserNode(treeNode, nick)) != null) {
            if (flag) {
                nick = mode + nick;
            }
            this.changeUserNode(treeNode, childNode, nick);
        }
    }

    public void changeUser(IRC irc, String oldNick, String newNick) {
        Enumeration channels = irc.getChannels();
        while (channels.hasMoreElements()) {
            MutableTreeNode childNode;
            Channel channel = (Channel)channels.nextElement();
            MutableTreeNode treeNode = this.getChannelTreeNode(channel);
            if (treeNode == null || (childNode = this.getUserNode(treeNode, oldNick)) == null) continue;
            char head = childNode.toString().charAt(0);
            String fullNewNick = newNick;
            if (head == '@' || head == '+') {
                fullNewNick = head + newNick;
            }
            this.changeUserNode(treeNode, childNode, fullNewNick);
            String[] args = new String[]{oldNick, newNick};
            channel.append(IRCMessageFormat.getNickMessage(args));
        }
    }

    private MutableTreeNode getUserNode(MutableTreeNode treeNode, String nick) {
        Enumeration<? extends TreeNode> e = treeNode.children();
        while (e.hasMoreElements()) {
            MutableTreeNode childNode = (MutableTreeNode)e.nextElement();
            String user = childNode.toString();
            if (!user.equals(nick) && !user.equals("@" + nick) && !user.equals("+" + nick)) continue;
            return childNode;
        }
        return null;
    }

    private MutableTreeNode getChannelTreeNode(Channel channel) {
        return (MutableTreeNode)this.nodeTable.get(channel.getIRC().getServer() + channel.getName());
    }

    public void append(Channel channel, String string) {
        if (!channel.getName().equals(this.nowChannel.getName())) {
            this.listenTA.append(string + "\r\n");
        }
    }

    public void show() {
        this.frame.show();
    }

    public Toolkit getToolkit() {
        return this.frame.getToolkit();
    }

    public Dimension getSize() {
        return this.frame.getSize();
    }

    public void setLocation(int x, int y) {
        ((Component)this.frame).setLocation(x, y);
    }

    public void setJMenuBar(JMenuBar bar) {
        this.frame.setJMenuBar(bar);
    }

    public void setDefaultCloseOperation(int i) {
        this.frame.setDefaultCloseOperation(i);
    }

    public void exit() {
        int i;
        if (this.isConnected()) {
            this.Disconnection();
        }
        if ((i = this.frame.getDefaultCloseOperation()) == 1) {
            this.frame.hide();
        } else if (i == 2) {
            this.frame.dispose();
        } else if (i == 3) {
            System.exit(0);
        }
        this.irc = null;
    }

    private class TreeSelectionListenerImpl
    implements TreeSelectionListener {
        private TreeSelectionListenerImpl() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (path == null) {
                path = e.getOldLeadSelectionPath();
            }
            Object channel = "";
            Object server = "";
            if (path.getPathCount() > 1) {
                channel = path.getPath()[path.getPathCount() - 1];
                server = path.getPath()[1];
            } else {
                server = channel = path.getPath()[1];
            }
            Window.this.setNowChannel(server.toString(), channel.toString());
        }
    }

    private class WindowListenerImpl
    extends WindowAdapter {
        private WindowListenerImpl() {
        }

        public void windowClosed(WindowEvent we) {
            Window.this.exit();
        }
    }
}

