/* -----------------------------------------------------------------------
 ControlSet.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/25
 *
 * ե̾ ControlSet.java
 */
package jp.co.jlight;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.dnd.*;
/**
 * ץꥱǻѤ륪֥Ȥ
 *       ޤȤ᤿Ρ
 */
public class ControlSet implements DisposeListener {

	private JavaLineStyler lineStyler = new JavaLineStyler();

	private String fileName = "";		// ե̾
	private String path = "";			// եѥ()
	private String fullFileName = "";	// ե

	private boolean flgNew;				// ե饰(true:false:¸)
	private boolean isEdited = false;	// Խɤ
//	private boolean isReadOnly;			// ꡼ɥ꡼ե뤫ɤ

	private ModifyListener modifyListener;
	private KeyListener keyListener;
	private MouseListener mouseListener;

	private Color lineColor;
	private Color offColor;
	private int nowLine = 0;

	private int key;
	private int id;
	private StyledText text;	// StyledText
	private TabItem item;		// TabItem
	
	private static TabFolder tabfolder = null;	// 饹ѿ
	
	// 󥹥ȥ饯ǳƼ拾ȥ
	// ɬ
	public ControlSet(String fileName, boolean isNew, TabFolder tabFolder, int key, int id) {
		if (tabfolder == null) tabfolder = tabFolder;
		this.fileName = fileName;
		this.flgNew = isNew;
		this.item = createTabItem(fileName, tabfolder);
		this.text = createStyledText(tabfolder);
		this.id = id;
		this.key = key;
		item.setControl(text);
		setTextListener();
	}
	
	// StyledTextǼTabItem֥Ȥ
	private TabItem createTabItem(String fn, TabFolder tabFolder) {
		TabItem tabItem = new TabItem(tabfolder, SWT.NULL);
		tabItem.setText(fn);

		tabItem.addDisposeListener(this);

		return tabItem;
	}

	// StyledText֥Ȥ
	private StyledText createStyledText(Composite composite) {
		StyledText txt = new StyledText(composite, SWT.FULL_SELECTION |
			SWT.BORDER | SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);

		return txt;
	}

	private void setTextListener() {
//		lineColor = new Color(text.getDisplay(), new RGB(225, 240, 185));
		lineColor = new Color(text.getDisplay(), new RGB(205, 215, 230));
		offColor = text.getBackground();

		// ꥹʡ饹μɲ
		modifyListener = new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				setEdited(true);
			}
		};
		text.addModifyListener(modifyListener);

		mouseListener = new MouseAdapter() {
			public void mouseDown(MouseEvent e) {
				setLineBackground();
			}
		};
		text.addMouseListener(mouseListener);

		keyListener = new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				setLineBackground();
			}
		};
		text.addKeyListener(keyListener);


		text.addLineStyleListener(lineStyler);
	}

	public void widgetDisposed(DisposeEvent e) {
		if (text != null) {
			text.removeModifyListener(modifyListener);
			text.removeKeyListener(keyListener);
			text.removeMouseListener(mouseListener);
			text.removeLineStyleListener(lineStyler);
		}
	}


	private void setLineBackground() {
		int caret = text.getCaretOffset();
		int line = text.getLineAtOffset(caret);
		int count = text.getLineCount();

		// ߤΥ饤ɥ
//		int start = text.getOffsetAtLine(nowLine);
// ----------------------------------------------------------
		int start = 0;
		if (nowLine >= count) {
			nowLine = count - 1;
		}
		start = text.getOffsetAtLine(nowLine);
// ----------------------------------------------------------

		int end = 0;
		int length = 0;
		if ((nowLine + 1) < count) {
			end = text.getOffsetAtLine((nowLine + 1));
			if (end >= start) {
				length = end - start;
			}
		}
		text.redrawRange(start, length, true);

		// ߤΥ饤󥫥顼򥪥դˤơ饤
		text.setLineBackground(nowLine, 1, offColor);
		text.setLineBackground(line, 1, lineColor);
		nowLine = line;

		// 饤ɥ
		start = text.getOffsetAtLine(nowLine);
		end = 0;
		length = 0;
		if ((nowLine + 1) < count) {
			end = text.getOffsetAtLine((nowLine + 1));
			if (end >= start) {
				length = end - start;
			}
		}
		text.redrawRange(start, length, true);




//		lineStyler.parseBlockComments(text.getText());

	}



	public void setDropText(DndReceiver receiver) {
//		int operations = DND.DROP_MOVE | DND.DROP_COPY | DND.DROP_LINK;
		int operations = DND.DROP_DEFAULT | DND.DROP_LINK;
		Transfer[] types = new Transfer[] {FileTransfer.getInstance()};
		DropTarget target = new DropTarget(text, operations);
		target.setTransfer(types);

		target.addDropListener(new DndSet(receiver));
	}


	/**
	 * @return String
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * @return boolean
	 */
	public boolean getFlgNew() {
		return flgNew;
	}

	/**
	 * Sets the fileName.
	 * @param fileName The fileName to set
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * Sets the flgNew.
	 * @param flgNew The flgNew to set
	 */
	public void setFlgNew(boolean isNew) {
		this.flgNew = isNew;
	}

	/**
	 * @return TabItem
	 */
	public TabItem getTabItem() {
		return item;
	}

	/**
	 * @return StyledText
	 */
	public StyledText getStyledText() {
		return text;
	}

	public void setTabItemText(String name) {
		item.setText(name);
	}

	public String getPath() {
		return path;
	}

	public String getFullName() {
		return fullFileName;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public void setFullName(String fullName) {
		this.fullFileName = fullName;
	}

	public void decrementID() {
		id--;
	}

	public void setID(int id) {
		this.id = id;
	}
	
	public int getID() {
		return id;
	}
	
	public int getKey() {
		return key;
	}

	public boolean getEdited() {
		return isEdited;
	}


	public void setEdited(boolean b) {
		this.isEdited = b;
	}

}

