/* -----------------------------------------------------------------------
 FileManager.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/26
 *
 * ե̾ FileManager.java
 */
package jp.co.jlight;

import java.io.*;
import java.util.*;
import java.text.MessageFormat;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
/**
 * ե륯饹
 */
public class FileManager {

	private Shell shell;
	private String fileName = "";
	private String fullFileName = "";
	private String path = "";

	private String saveFileName = "";
	private String saveFullFileName = "";
	private String savePath = "";

	private String encoding = "";
	private String defEncoding = System.getProperty("file.encoding");

	private MessageManager mm;

	private static ResourceBundle resources = ResourceBundle.getBundle("resources.jlighteditor");
	public static final String LINE_SEPARATOR = System.getProperty("line.separator");
	public static final String USER_HOME = System.getProperty("user.home");

	public FileManager(Shell sh) {
		shell = sh;
		encoding = defEncoding;
		mm = new MessageManager(sh);
	}

	/**
	 * @return String
	 * եɽեString֤
	 * 󥻥ե뤬¸ߤʤnull
	 */
	public String getOpenFileString() {
		final String textString;

		File file = getOpenFile();
		if (file == null || !file.isFile()) return null;

		FileInputStream fis = null;
		InputStreamReader isr = null;
		BufferedReader bfr = null;
		try {
			fis = new FileInputStream(file.getPath());
			isr = new InputStreamReader(fis, encoding);
			bfr = new BufferedReader(isr);

			StringBuffer buffer = new StringBuffer();
			String line = "";
//			System.out.println("encode = " + isr.getEncoding());

			while((line = bfr.readLine()) != null){
				if (!line.equals("")){
					//
					buffer.append(line);
				}
				buffer.append(LINE_SEPARATOR);
			}

			textString = buffer.toString();

			bfr.close();
			isr.close();

		} catch (FileNotFoundException e) {
			String message = MessageFormat.format(
				   resources.getString("Err_File_Not_Found"),
				   new String[] {file.getName()});
			mm.displayError(message);
			return null;

		} catch (IOException e) {
			String message = MessageFormat.format(
				   resources.getString("Err_File_IO"),
				   new String[] {file.getName()});
			mm.displayError(message);
			return null;

		} finally {
			if (fis != null) {
				try {
					fis.close();
				} catch (IOException e) {
					String message = MessageFormat.format(
						   resources.getString("Err_File_IO"),
						   new String[] {file.getName()});
					mm.displayError(message);
					return null;
				}
			}
		}
		setFileStrings(file);

		return textString;
	}

	/**
	 * @return String
	 * getOpenFileStringΥСɥ᥽å
	 * ե͡ǥեꤷStringǥեƤ֤
	 * ե뤬¸ߤʤnull顼ϡSystem.errؽ
	 */
	public String getOpenFileString(String fullName) {

		final String textString;

		File file = new File(fullName);
		if (file == null || !file.isFile()) return null;

		FileInputStream fis = null;
		InputStreamReader isr = null;
		BufferedReader bfr = null;
		try {
			fis = new FileInputStream(file.getPath());
			isr = new InputStreamReader(fis, encoding);
			bfr = new BufferedReader(isr);

			StringBuffer buffer = new StringBuffer();
			String line = "";

			while((line = bfr.readLine()) != null){
				if (!line.equals("")){
					//
					buffer.append(line);
				}
				buffer.append(LINE_SEPARATOR);
			}

			textString = buffer.toString();

			bfr.close();
			isr.close();

		} catch (FileNotFoundException e) {
			String message = MessageFormat.format(
				   resources.getString("Err_File_Not_Found"),
				   new String[] {file.getName()});
			System.err.println(message);
			return null;

		} catch (IOException e) {
			String message = MessageFormat.format(
				   resources.getString("Err_File_IO"),
				   new String[] {file.getName()});
			System.err.println(message);
			return null;

		} finally {
			if (fis != null) {
				try {
					fis.close();
				} catch (IOException e) {
					String message = MessageFormat.format(
						   resources.getString("Err_File_IO"),
						   new String[] {file.getName()});
					System.err.println(message);
					return null;
				}
			}
		}
		setFileStrings(file);

		return textString;
	}


	private void setFileStrings(File file) {
		this.fileName = file.getName();
		this.fullFileName = file.getPath();
		this.path = file.getParent();
	}

	private File getOpenFile() {

		FileDialog fileDialog = new FileDialog(shell, SWT.OPEN);
		fileDialog.setText(resources.getString("FileOpenDialogTitle"));

		File file = new File(path);
		if (file.exists()) {
			fileDialog.setFilterPath(path);
		} else {
			fileDialog.setFilterPath(USER_HOME);
		}
 		file = null;

		fileDialog.setFilterExtensions(new String[] {"*.java", "*.*"});
		fileDialog.open();

		String name = fileDialog.getFileName();

		// Canceled
		if ((name == null) || (name.length() == 0)) return null;

		file = new File(fileDialog.getFilterPath(), name);
		
		if (!file.exists()) {
			String message = MessageFormat.format(
				   resources.getString("Err_File_No_Exist"),
				   new String[] {file.getName()});
			mm.displayError(message);
			return null;
		}
		return file;
	}



	/**
	 * @return String
	 * ƥȤ¸¸եե͡String֤
	 * 餫Υȥ֥¸ʤänull
	 */
	public String saveText(String text) {
		String result = null;
		File file = new File(saveFullFileName);
		if (file.exists() && !file.canWrite()) {
			String message = MessageFormat.format(
					resources.getString("Err_File_Cannot_Write"),
					new String[] {file.getName()});
			mm.displayError(message);
			return null;
		}
		FileOutputStream fos = null;
		OutputStreamWriter osw = null;
		BufferedWriter bfw = null;
		try {
			fos = new FileOutputStream(file);
			osw = new OutputStreamWriter(fos, encoding);
			bfw = new BufferedWriter(osw);
			bfw.write(text);

			result = saveFullFileName;

			bfw.close();
			osw.close();

		} catch (FileNotFoundException e) {
			System.err.println("saveText FileNotFoundException !!!");
			String message = MessageFormat.format(
				   resources.getString("Err_File_Permission"),
				   new String[] {file.getName()});
			mm.displayError(message);
			return null;

		} catch (IOException e) {
			String message = MessageFormat.format(
				   resources.getString("Err_File_IO"),
				   new String[] {file.getName()});
			mm.displayError(message);
			return null;

		} finally {
			if (fos != null) {
				try {
					fos.close();
				} catch (IOException e) {
					String message = MessageFormat.format(
						   resources.getString("Err_File_IO"),
						   new String[] {file.getName()});
					mm.displayError(message);
					return null;
				}
			}
		}

		System.out.println(result);

		return result;
	}

	public String saveAsText(String text) {
		String result = null;

		FileDialog fileDialog = new FileDialog(shell, SWT.SAVE);
		fileDialog.setText(resources.getString("FileSaveDialogTitle"));

		File file = new File(savePath);
		if (file.exists()) {
			fileDialog.setFilterPath(savePath);
		} else {
			fileDialog.setFilterPath(USER_HOME);
		}
		file = null;

		fileDialog.setFileName(saveFileName);

		String name = fileDialog.open();

		// Canceled
		if ((name == null) || (name.length() == 0)) return null;


		file = new File(name);

		if (file.exists()) {
			String message = resources.getString("Qusetion.File.ReWrite");
			if (mm.displayYesNoQuestion(message) == SWT.NO) return null;
		} else {

			System.out.println("ե¸ߤʤ " + file.getPath());

		}

		// 򤵤줿˥ե̾Ϣ
		// ѿˤ줾ͤ
		saveFileName = fileDialog.getFileName();
		saveFullFileName = name;
		savePath = fileDialog.getFilterPath();

		result = saveText(text);


		return result;
	}



	public String getFileName() {
		return fileName;
	}
	public String getFullName() {
		return fullFileName;
	}
	public String getPath() {
		return path;
	}


	public void setSaveFileName(String saveFileName) {
		if (saveFileName != null) this.saveFileName = saveFileName;
	}

	public void setSaveFullName(String saveFullName) {
		if (saveFullName != null) this.saveFullFileName = saveFullName;
	}

	public void setSavePath(String savePath) {
		if (savePath != null) this.savePath = savePath;
	}

	public String getSavedFileName() {
		return saveFileName;
	}
	public String getSavedFullName() {
		return saveFullFileName;
	}
	public String getSavedPath() {
		return savePath;
	}


	public void setEncoding(String encode) {
		if (encode == null || encode == "") encode = defEncoding;
		encoding = encode;
	}

	public boolean isFileExists(String fullName) {
		if (fullName == null || fullName == "") return false;
		File file = new File(fullName);
		if (file.exists()) {
			return true;
		} else {
			return false;
		}
	}

	public boolean isFile(String fullName) {
		if (fullName == null || fullName == "") return false;
		File file = new File(fullName);
		if (file.isFile()) {
			return true;
		} else {
			return false;
		}
	}

	public boolean fileCanWrite(String fullName) {
		if (fullName == null || fullName == "") return false;
		File file = new File(fullName);
		if (file.canWrite()) {
			return true;
		} else {
			return false;
		}
	}

}
