/* -----------------------------------------------------------------------
 FontManager.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/03/12
 *
 * ե̾ FontManager.java
 */
package jp.co.jlight;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
/**
 * եȤ륯饹
 */
public class FontManager {

	private Shell shell;
	private FontData fontData = null;
	private Font nowFont = null;

	private static Resources resources = new Resources();

	public FontManager(Shell shell) {
		this.shell = shell;
	}

	public Font getFont() {
		FontData fd = null;

		FontDialog fontDialog = new FontDialog(shell);
		fontDialog.setText(resources.getFontDialogTitle());
		if (fontData != null) fontDialog.setFontData(fontData);

		fd = fontDialog.open();
		if (fd != null) {
			fontData = fd;
			nowFont = new Font(shell.getDisplay(), fd);
			return nowFont;
		} else {
			return null;
		}
	}

	public FontData getFontData() {
		return fontData;
	}

	public void setFontData(FontData fontData) {
		this.fontData = fontData;
	}

	public Font getNowFont() {
		return nowFont;
	}

	public void dispose() {
		if (nowFont != null) nowFont.dispose();
	}

}
