/* -----------------------------------------------------------------------
 JLightEditor.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/18
 *
 * ե̾ JLightEditor.java
 *
 */
package jp.co.jlight;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.dnd.*;
import java.util.*;

import jp.co.jlight.actions.*;
/**
 * ǥΥ饹
 */
public class JLightEditor extends BaseFrame 
						implements ActionHandler, Receiver, DndReceiver {

	private ControlManager cm;
	private ControlSet nowControlSet = null;
	private MenuManager mm;
	private FileManager fm;
	private FontManager fontManager;


	private TabFolder tabFolder;
	private int count = 1;			// ControlSetɲääKeyˤʤ

	private Hashtable actionSet;	// 󥯥饹

	private MessageManager message;

	private SelectionListener selectionListener;
	private DisposeListener disposeListener;

	public JLightEditor() {
		cm = new ControlManager();
		actionSet = new Hashtable();
		createMenu();
		createFileManager();
		createFontManager();
		createTabFolder();
		createMessageManager();

		createActionSet();
		createDisposeSet();
	}
	
	public void init() {
		handleFileNew();
	}
	
	private void createMenu() {
		mm = new MenuManager(getShell());
		mm.createMenuBar();
		mm.addMenuSelectedListener();
		mm.setReceiver(this);
	}
	
	private void createFileManager() {
		fm = new FileManager(getShell());
	}
	
	private void createMessageManager() {
		message = new MessageManager(getShell());
	}

	private void createFontManager() {
		fontManager = new FontManager(getShell());
	}

	private void createTabFolder() {
		tabFolder = new TabFolder(getShell(), SWT.NULL);
		
		GridData gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.grabExcessHorizontalSpace = true;
		gd.verticalAlignment = GridData.FILL;
		gd.grabExcessVerticalSpace = true;

		tabFolder.setLayoutData(gd);

		selectionListener = new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				// 򤵤줿TabItem°륯饹(ControlSet)
				// 
//				System.out.print("widgetSelected٥ȯ ");
//				System.out.println("Selection Index = " + tabFolder.getSelectionIndex());
				setNowControlSet(tabFolder.getSelectionIndex());
			}
		};
		tabFolder.addSelectionListener(selectionListener);

		// ɥåɥåפư
		int operations = DND.DROP_DEFAULT | DND.DROP_LINK;
		Transfer[] types = new Transfer[] {FileTransfer.getInstance()};
		DropTarget target = new DropTarget(tabFolder, operations);
		target.setTransfer(types);

		target.addDropListener(new DndSet(this));
	}


	private void setNowControlSet(int id) {
		if (id < 0) return;
		Enumeration enum = cm.getControlSets().elements();
		ControlSet cset;
		while (enum.hasMoreElements()) {
			cset = (ControlSet)enum.nextElement();
			if (id == cset.getID()) {
				nowControlSet = cset;
//				System.out.print("Key = " + cset.getKey() + "  ");
//				System.out.println("ID = " + cset.getID() +
//				"  ե̾ = " + cset.getFileName() + "  ");
			}
		}
	}

	private void createDisposeSet() {
		disposeListener = new DisposeListener() {
			public void widgetDisposed(DisposeEvent e) {
				cm.dispose();
				fontManager.dispose();
			}
		};
		getShell().addDisposeListener(disposeListener);
	}

	private void createActionSet() {
		actionSet.put(ActionNames.NEW, new FileNew());
		actionSet.put(ActionNames.OPEN, new FileOpen());
		actionSet.put(ActionNames.CLOSE, new FileClose());
		actionSet.put(ActionNames.SAVE, new FileSave());
		actionSet.put(ActionNames.SAVEAS, new FileSaveAs());
		actionSet.put(ActionNames.EXIT, new FileExit());

		actionSet.put(ActionNames.CUT, new EditCut());
		actionSet.put(ActionNames.COPY, new EditCopy());
		actionSet.put(ActionNames.PASTE, new EditPaste());

		actionSet.put(ActionNames.FONT, new SettingFont());
		actionSet.put(ActionNames.ENCODE, new SettingEncode());

		actionSet.put(ActionNames.ABOUT, new HelpAbout());

	}
	
	// ȥ뤫Ƥ٥Ȥ
	// 줾Υ󥯥饹
	public void actionHandler(String actionName) {
		ActionDispatcher handle = (ActionDispatcher)actionSet.get(actionName);
		if (handle != null) handle.doAction(this);
	}


	public void handleFileNew() {
		int id = tabFolder.getItemCount();
		ControlSet cset = new ControlSet(cm.getNewFileName(), true, tabFolder, count, id);
		cm.addControlSet(new Integer(count), cset);
		count++;

		tabFolder.setSelection(tabFolder.getItemCount() - 1);

		if (fontManager.getNowFont() != null) {
			cset.getStyledText().setFont(fontManager.getNowFont());
		}
		cset.setDropText(this);
		nowControlSet = cset;

		if (tabFolder.getItemCount() > 0) {
			mm.getItemFileClose().setEnabled(true);
			mm.getItemFileSave().setEnabled(true);
			mm.getItemFileSaveAs().setEnabled(true);
		}
	}
	
	public void handleFileOpen() {
		final String text = fm.getOpenFileString();
		if (text == null) {
			System.out.println("(Text is null)");
			return;
		}

		if (nowControlSet == null) {
			handleFileNew();
		}
		if ((nowControlSet.getEdited()) || (!nowControlSet.getFlgNew())) {
			handleFileNew();
		}
		String fname = fm.getFileName();
		nowControlSet.setFlgNew(false);
		nowControlSet.setFileName(fname);
		nowControlSet.setFullName(fm.getFullName());
		nowControlSet.setPath(fm.getPath());
		nowControlSet.setTabItemText(fname);

		Display display = nowControlSet.getStyledText().getDisplay();
		display.asyncExec(new Runnable() {
			public void run() {
				nowControlSet.getStyledText().setText(text);
				nowControlSet.setEdited(false);
			}
		});

	}

	public void handleFileOpen(String[] fileNames) {
		if (fileNames == null || fileNames.length == 0) return;
		String text = "";
		for (int i = 0; i < fileNames.length; i++) {
			System.out.println(fileNames[i]);

			if (fm.isFile(fileNames[i])) {

				text = fm.getOpenFileString(fileNames[i]);

				if (text == null) {
					System.out.println("(Text is null)");
					return;
				}
				if (nowControlSet == null) {
					handleFileNew();
				}
				if ((nowControlSet.getEdited()) || (!nowControlSet.getFlgNew())) {
					handleFileNew();
				}
				String fname = fm.getFileName();
				nowControlSet.setFlgNew(false);
				nowControlSet.setFileName(fname);
				nowControlSet.setFullName(fm.getFullName());
				nowControlSet.setPath(fm.getPath());
				nowControlSet.setTabItemText(fname);

				setSyncText(text);

			}
		}
	}

	public void setSyncText(final String text) {
		Display display = nowControlSet.getStyledText().getDisplay();
		display.syncExec(new Runnable() {
			public void run() {
				nowControlSet.getStyledText().setText(text);
				nowControlSet.setEdited(false);
			}
		});
	}

	public void handleFileClose() {
		if (nowControlSet.getEdited()) {
			int result = message.displayYesNoCancel("File has Changed. Save this file?");
			if (result == SWT.CANCEL) {
				return;
			} else if (result == SWT.YES) {
				// ¸ν򤹤롢ԤϤɤ?
				if (fm.fileCanWrite(nowControlSet.getFullName())) {
					handleFileSave();
				} else {
					handleFileSaveAs();
				}
				// Ԥ꥿
				if (nowControlSet.getEdited()) return;
			} else if (result == SWT.NO) {
				// ⤷ʤĤ˰ܤ
			}
		}

		int rmID = nowControlSet.getID();
		Integer rmKey = new Integer(nowControlSet.getKey());

		// IDοľ
		Enumeration enum = cm.getControlSets().elements();
		ControlSet cset;
		while (enum.hasMoreElements()) {
			cset = (ControlSet)enum.nextElement();
			if (rmID < cset.getID()) cset.decrementID();
		}
		// ֥ȤControlManagerΥ쥯󤫤
		// TabItemĤ
		cm.removeControlSet(rmKey);
		nowControlSet.getTabItem().dispose();

		if (tabFolder.getItemCount() < 1) {
			mm.getItemFileClose().setEnabled(false);
			mm.getItemFileSave().setEnabled(false);
			mm.getItemFileSaveAs().setEnabled(false);
			nowControlSet = null;
		}
	}
	
	public void handleFileSave() {
		String result = null;
		// ΥեǤ¸ɽ
		// ޤץ󤷤եǤ¸ߤʤХɽ
		if (nowControlSet.getFlgNew() ||
			fm.isFileExists(nowControlSet.getFullName()) == false) {

			handleFileSaveAs();
			return;
		}
		setSaveFileNames();
		result = fm.saveText(nowControlSet.getStyledText().getText());
		if (result != null) {
			nowControlSet.setEdited(false);
		}
	}
	
	public void handleFileSaveAs() {
		String result = null;
		setSaveFileNames();
		result = fm.saveAsText(nowControlSet.getStyledText().getText());
		if (result != null) {
			String fname = fm.getSavedFileName();
			nowControlSet.setFlgNew(false);
			nowControlSet.setFileName(fname);
			nowControlSet.setFullName(result);
			nowControlSet.setPath(fm.getSavedPath());
			nowControlSet.setTabItemText(fname);

			nowControlSet.setEdited(false);

			System.out.println("File Saved !!!");
		}
	}
	
	public void handleFileExit() {
		getShell().close();
	}
	
	public void handleEditCut() {
		if (nowControlSet != null) {
			nowControlSet.getStyledText().cut();
		}
	}
	
	public void handleEditCopy() {
		if (nowControlSet != null) {
			nowControlSet.getStyledText().copy();
		}
	}
	
	public void handleEditPaste() {
		if (nowControlSet != null) {
			nowControlSet.getStyledText().paste();
		}
	}

	public void handleSettingFont() {
		if (fontManager.getFontData() == null) setNowFontData();
		if (fontManager.getFont() != null) {
			Enumeration enum = cm.getControlSets().elements();
			ControlSet cset;
			while (enum.hasMoreElements()) {
				cset = (ControlSet)enum.nextElement();
				cset.getStyledText().setFont(fontManager.getNowFont());
			}
		}
	}

	public void handleSettingEncode() {
//		System.out.println(mm.getNowEncoding());
		fm.setEncoding(mm.getNowEncoding());
	}

	public void handleHelpAbout() {
		String msg = "    JLightEditor Ver.0.1    ";
		message.displayInformation(msg);
	}



	private void setNowFontData() {
		if (tabFolder.getItemCount() < 1) return;
		FontData[] fd = nowControlSet.getStyledText().getFont().getFontData();
		FontData fontData = new FontData(fd[0].getName(),
						fd[0].getHeight(), fd[0].getStyle());

		fontManager.setFontData(fontData);
	}

	private void setSaveFileNames() {
		if (nowControlSet != null) {
			fm.setSaveFileName(nowControlSet.getFileName());
			fm.setSaveFullName(nowControlSet.getFullName());
			fm.setSavePath(nowControlSet.getPath());
		}
	}

}

