/* -----------------------------------------------------------------------
 MenuManager.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/25
 *
 * ե̾ MenuManager.java
 */
package jp.co.jlight;

import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;
import java.util.*;
/**
 * ˥塼С륯饹
 */
public class MenuManager implements SelectionListener, Sender {

	private Shell shell = null;

	private Receiver receiver;

	private Menu bar;
	private MenuItem itemFileNew;
	private MenuItem itemFileOpen;
	private MenuItem itemFileClose;
	private MenuItem itemFileSave;
	private MenuItem itemFileSaveAs;
	private MenuItem itemFileExit;

	private MenuItem itemEditCut;
	private MenuItem itemEditCopy;
	private MenuItem itemEditPaste;

	private MenuItem itemSettingFont;
	private Menu menuEncode;

	private MenuItem itemHelpAbout;

	private Hashtable actions;
	private EncodeSet es = new EncodeSet();

	private static ResourceBundle resources = ResourceBundle.getBundle("resources.jlighteditor");


	public MenuManager(Shell sh) {
		this.shell = sh;
		actions = new Hashtable();
	}


	public void createMenuBar() {
		bar = new Menu(shell, SWT.BAR);
		shell.setMenuBar(bar);

		MenuItem itemFile = new MenuItem(bar, SWT.CASCADE);
		MenuItem itemEdit = new MenuItem(bar, SWT.CASCADE);
		MenuItem itemSetting = new MenuItem(bar, SWT.CASCADE);
		MenuItem itemHelp = new MenuItem(bar, SWT.CASCADE);
		
		itemFile.setText(resources.getString("MenuItem.File"));
		itemEdit.setText(resources.getString("MenuItem.Edit"));
		itemSetting.setText(resources.getString("MenuItem.Setting"));
		itemHelp.setText(resources.getString("MenuItem.Help"));
		
		itemFile.setMenu(createFileMenu());
		itemEdit.setMenu(createEditMenu());
		itemSetting.setMenu(createSettingMenu());
		itemHelp.setMenu(createHelpMenu());
		
		// ̾쥯κ
		createActionNamesSet();
	}	

	private Menu createFileMenu() {
		String mi = "MenuItem.File.";
		
//		Menu menu = new Menu(shell.getMenuBar());
		Menu menu = new Menu(shell, SWT.DROP_DOWN);
		
		itemFileNew = new MenuItem(menu, SWT.PUSH);
		itemFileNew.setText(resources.getString(mi + "New"));

		new MenuItem(menu, SWT.SEPARATOR);

		itemFileOpen = new MenuItem(menu, SWT.PUSH);
		itemFileOpen.setText(resources.getString(mi + "Open"));

		itemFileClose = new MenuItem(menu, SWT.PUSH);
		itemFileClose.setText(resources.getString(mi + "Close"));
		
		itemFileSave = new MenuItem(menu, SWT.PUSH);
		itemFileSave.setText(resources.getString(mi + "Save"));

		itemFileSaveAs = new MenuItem(menu, SWT.PUSH);
		itemFileSaveAs.setText(resources.getString(mi + "SaveAs"));

		new MenuItem(menu, SWT.SEPARATOR);

		itemFileExit = new MenuItem(menu, SWT.PUSH);
		itemFileExit.setText(resources.getString(mi + "Exit"));
		
		return menu;
	}
	
	private Menu createEditMenu() {
		String mi = "MenuItem.Edit.";
		
//		Menu menu = new Menu(shell.getMenuBar());
		Menu menu = new Menu(shell, SWT.DROP_DOWN);

		itemEditCut = new MenuItem (menu, SWT.PUSH);
		itemEditCut.setText(resources.getString(mi + "Cut"));

		itemEditCopy = new MenuItem (menu, SWT.PUSH);
		itemEditCopy.setText(resources.getString(mi + "Copy"));

		itemEditPaste = new MenuItem (menu, SWT.PUSH);
		itemEditPaste.setText(resources.getString(mi + "Paste"));

		return menu;
	}

	private Menu createSettingMenu() {
		String mi = "MenuItem.Setting.";

//		Menu menu = new Menu(shell.getMenuBar());
		Menu menu = new Menu(shell, SWT.DROP_DOWN);

		itemSettingFont = new MenuItem(menu, SWT.PUSH);
		itemSettingFont.setText(resources.getString(mi + "Font"));

/////////////////////////////////////////////////////
  		MenuItem itemEncode = new MenuItem(menu, SWT.CASCADE);
  		itemEncode.setText(resources.getString(mi + "Encoding"));

		MenuItem subitem;
		menuEncode = new Menu(shell, SWT.DROP_DOWN);
		for (int i = 0; i < es.getCount(); i++) {
			subitem = new MenuItem(menuEncode, SWT.RADIO);
			subitem.setText(es.getDispEncodeName(i));
		}
		itemEncode.setMenu(menuEncode);
////////////////////////////////////////////////////

		return menu;
	}

	private Menu createHelpMenu() {
		String mi = "MenuItem.Help.";

//		Menu menu = new Menu(shell.getMenuBar());
		Menu menu = new Menu(shell, SWT.DROP_DOWN);

		itemHelpAbout = new MenuItem(menu, SWT.NULL);
		itemHelpAbout.setText(resources.getString(mi + "About"));

		return menu;
	}

	private void createActionNamesSet() {
		actions.put(itemFileNew, ActionNames.NEW);
		actions.put(itemFileOpen, ActionNames.OPEN);
		actions.put(itemFileClose, ActionNames.CLOSE);
		actions.put(itemFileSave, ActionNames.SAVE);
		actions.put(itemFileSaveAs, ActionNames.SAVEAS);
		actions.put(itemFileExit, ActionNames.EXIT);

		actions.put(itemEditCut, ActionNames.CUT);
		actions.put(itemEditCopy, ActionNames.COPY);
		actions.put(itemEditPaste, ActionNames.PASTE);

		actions.put(itemSettingFont, ActionNames.FONT);


		MenuItem[] items = menuEncode.getItems();
		for (int i = 0; i < items.length; i++) {
			actions.put(items[i], ActionNames.ENCODE);
		}
		items[0].setSelection(true);


		actions.put(itemHelpAbout, ActionNames.ABOUT);
	}

	public void addMenuSelectedListener() {
		itemFileNew.addSelectionListener(this);
		itemFileOpen.addSelectionListener(this);
		itemFileClose.addSelectionListener(this);
		itemFileSave.addSelectionListener(this);
		itemFileSaveAs.addSelectionListener(this);
		itemFileExit.addSelectionListener(this);

		itemEditCut.addSelectionListener(this);
		itemEditCopy.addSelectionListener(this);
		itemEditPaste.addSelectionListener(this);

		itemSettingFont.addSelectionListener(this);


		MenuItem[] items = menuEncode.getItems();
		for (int i = 0; i < items.length; i++) {
			items[i].addSelectionListener(this);
	  	}


		itemHelpAbout.addSelectionListener(this);
	}

	public void setReceiver(Receiver receiver) {
		this.receiver = receiver;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	}

	public void widgetSelected(SelectionEvent e) {
		MenuItem mi= (MenuItem)e.getSource();
		receiver.actionHandler((String)actions.get(mi));
	}


	/**
	 * @return Menu Menu
	 */
	public Menu getMenu() {
		if (shell != null) return shell.getMenu();
		return null;
	}
	
	/**
	 * @return Menu MenuBar
	 */
	public Menu getMenuBar() {
		if (shell != null) return shell.getMenuBar();
		return null;
	}
	
	/**
	 * @return MenuItem ե뿷
	 */
	public MenuItem getItemFileNew() {
		return itemFileNew;
	}

	/**
	 * @return MenuItem ե볫
	 */
	public MenuItem getItemFileOpen() {
		return itemFileOpen;
	}

	/**
	 * @return MenuItem ե¸
	 */
	public MenuItem getItemFileSave() {
		return itemFileSave;
	}

	/**
	 * @return MenuItem ե̾դ¸
	 */
	public MenuItem getItemFileSaveAs() {
		return itemFileSaveAs;
	}

	/**
	 * @return MenuItem եĤ
	 */
	public MenuItem getItemFileClose() {
		return itemFileClose;
	}

	/**
	 * @return MenuItem ե뽪λ
	 */
	public MenuItem getItemFileExit() {
		return itemFileExit;
	}

	/**
	 * @return MenuItem Խԡ
	 */
	public MenuItem getItemEditCopy() {
		return itemEditCopy;
	}

	/**
	 * @return MenuItem Խڤ
	 */
	public MenuItem getItemEditCut() {
		return itemEditCut;
	}

	/**
	 * @return MenuItem ԽŽդ
	 */
	public MenuItem getItemEditPaste() {
		return itemEditPaste;
	}

	/**
	 * @return MenuItem ե
	 */
	public MenuItem getItemSettingFont() {
		return itemSettingFont;
	}

	/**
	 * @return MenuItem إץХ
	 */
	public MenuItem getItemHelpAbout() {
		return itemHelpAbout;
	}


	public String getNowEncoding() {
		String result = null;
		MenuItem[] items = menuEncode.getItems();
		for (int i = 0; i < items.length; i++) {
			if (items[i].getSelection()) {
				result = es.getRealEncodeName(i);
				break;
			}
		}
		return result;
	}

}
