/* -----------------------------------------------------------------------
 MessageManager.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/21
 *
 * ե̾ MessageManager.java
 */
package jp.co.jlight;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
/**
 * @author develop
 */
public class MessageManager {

	private Shell shell;

	public MessageManager(Shell parent) {
		this.shell = parent;
	}

	public void displayInformation(String msg) {
		displayMessage(msg, SWT.ICON_INFORMATION);
	}

	public void displayError(String msg) {
		displayMessage(msg, SWT.ICON_ERROR);
	}

	public int displayYesNoQuestion(String msg) {
		return displayMessage(msg, SWT.YES | SWT.NO | SWT.ICON_QUESTION);
	}

	public int displayYesNoCancel(String msg) {
		return displayMessage(msg, SWT.YES | SWT.NO | SWT.CANCEL | SWT.ICON_QUESTION);
	}

	private int displayMessage(String msg, int styles) {
		MessageBox mbox = new MessageBox(shell, styles);
		mbox.setMessage(msg);
		return mbox.open();
	}

}

////::::