/* -----------------------------------------------------------------------
 JLightEditor.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/18
 *
 * File Name: JLightEditor.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 * 
 */
package jp.co.jlight;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.dnd.*;
import java.util.*;

import jp.co.jlight.actions.*;
/**
 * ǥΥ饹
 */
public class JLightEditor extends BaseFrame 
						implements ActionHandler, Receiver, DndReceiver {

	private ControlManager cm;
	private ControlSet nowControlSet = null;
	private MenuManager mm;
	private FileManager fm;
	private FontManager fontManager;


	private TabFolder tabFolder;
	private int count = 1;			// ControlSetɲääKeyˤʤ

	private Hashtable actionSet;	// 󥯥饹

	private MessageManager message;

	private SelectionListener selectionListener;
	private DisposeListener disposeListener;

	private Label status = null;		// Τ
	private Label lineColumn = null;	// 饤ֹȥɽ٥


	/**
	 * JLightEditor饹󥹥ȥ饯
	 */
	public JLightEditor() {
		cm = new ControlManager();
		actionSet = new Hashtable();
		createMenu();
		createFileManager();
		createFontManager();
		createTabFolder();
		createMessageManager();

		createActionSet();
		createDisposeSet();
		
		createLabel();
		
		setWindowLayout();
		setShellListener();
	}

	/**
	 * (֤ˤ뤿˿)
	 */
	public void init() {
		handleFileNew();
	}

	/**
	 * ˥塼κ
	 */
	private void createMenu() {
		mm = new MenuManager(getShell());
		mm.createMenuBar();
		mm.addMenuSelectedListener();
		mm.setReceiver(this);
	}

	/**
	 * եޥ͡κ
	 */
	private void createFileManager() {
		fm = new FileManager(getShell());
	}

	/**
	 * åޥ͡κ
	 */
	private void createMessageManager() {
		message = new MessageManager(getShell());
	}

	/**
	 * եȥޥ͡κ
	 */
	private void createFontManager() {
		fontManager = new FontManager(getShell());
	}

	/**
	 * ֥եκ
	 */
	private void createTabFolder() {
		tabFolder = new TabFolder(getShell(), SWT.NULL);
		
		GridData gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.grabExcessHorizontalSpace = true;
		gd.verticalAlignment = GridData.FILL;
		gd.grabExcessVerticalSpace = true;

		tabFolder.setLayoutData(gd);

		selectionListener = new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				// 򤵤줿TabItem°륯饹(ControlSet)
//				System.out.print("widgetSelected٥ȯ ");
//				System.out.println("Selection Index = " + tabFolder.getSelectionIndex());
				setNowControlSet(tabFolder.getSelectionIndex());
				
				// Line,Column٥
				initLineColumn();
			}
		};
		tabFolder.addSelectionListener(selectionListener);

		// ɥåɥåפư
		int operations = DND.DROP_DEFAULT | DND.DROP_LINK;
		Transfer[] types = new Transfer[] {FileTransfer.getInstance()};
		DropTarget target = new DropTarget(tabFolder, operations);
		target.setTransfer(types);

		target.addDropListener(new DndSet(this));
	}

	/**
	 * ٥
	 */
	private void createLabel() {
		status = new Label(getShell(), SWT.HORIZONTAL);
		lineColumn = new Label(getShell(), SWT.HORIZONTAL);

		lineColumn.setAlignment(SWT.RIGHT);
	}

	/**
	 * ֹ桢ֹɽ٥
	 */
	private void initLineColumn() {
		lineColumn.setText("");
	}

	/**
	 * ɥΥ쥤ȤꤷåȤ
	 */
	private void setWindowLayout() {
		FormData data1 = new FormData();
		data1.top = new FormAttachment(0, 0);
		data1.bottom = new FormAttachment(100, -22);
		data1.left = new FormAttachment(0, 1);
		data1.right = new FormAttachment(100, -2);
		
		tabFolder.setLayoutData(data1);
		
		FormData data2 = new FormData();
		data2.left = new FormAttachment(0, 1);
		data2.top = new FormAttachment(tabFolder, 5);
//		data2.right = new FormAttachment(100, -250);
		
		status.setLayoutData(data2);

		FormData data3 = new FormData();
		data3.left = new FormAttachment(status, 5);
		data3.top = new FormAttachment(tabFolder, 5);
		data3.right = new FormAttachment(100, -15);

		lineColumn.setLayoutData(data3);
		
	}

	/**
	 * ǻꤵ줿IDControlSetnowControlSet
	 * @param id
	 */
	private void setNowControlSet(int id) {
		if (id < 0) return;
		Enumeration enum = cm.getControlSets().elements();
		ControlSet cset;
		while (enum.hasMoreElements()) {
			cset = (ControlSet)enum.nextElement();
			if (id == cset.getID()) {
				nowControlSet = cset;
//				System.out.print("Key = " + cset.getKey() + "  ");
//				System.out.println("ID = " + cset.getID() +
//				"  ե̾ = " + cset.getFileName() + "  ");
			}
		}
	}

	/**
	 * ShellDisposeꥹʡꤹ
	 */
	private void createDisposeSet() {
		disposeListener = new DisposeListener() {
			public void widgetDisposed(DisposeEvent e) {
				cm.dispose();
				fontManager.dispose();
			}
		};
		getShell().addDisposeListener(disposeListener);
	}

	/**
	 * 󥻥åȤκ
	 * ̾б륢󥪥֥Ȥ򥳥쥯ɲ
	 */
	private void createActionSet() {
		actionSet.put(ActionNames.NEW, new FileNew());
		actionSet.put(ActionNames.OPEN, new FileOpen());
		actionSet.put(ActionNames.CLOSE, new FileClose());
		actionSet.put(ActionNames.SAVE, new FileSave());
		actionSet.put(ActionNames.SAVEAS, new FileSaveAs());
		actionSet.put(ActionNames.EXIT, new FileExit());

		actionSet.put(ActionNames.UNDO, new EditUndo());
		actionSet.put(ActionNames.REDO, new EditRedo());
		actionSet.put(ActionNames.CUT, new EditCut());
		actionSet.put(ActionNames.COPY, new EditCopy());
		actionSet.put(ActionNames.PASTE, new EditPaste());

		actionSet.put(ActionNames.FONT, new SettingFont());
		actionSet.put(ActionNames.ENCODE, new SettingEncode());

		actionSet.put(ActionNames.ABOUT, new HelpAbout());

	}

	/**
	 * Ͽ줿¹Ԥ(ȥ뤫Ƥ٥Ȥ)
	 * 줾Υ󥯥饹
	 * @param actionName
	 */
	public void actionHandler(String actionName) {
		ActionDispatcher handle = (ActionDispatcher)actionSet.get(actionName);
		if (handle != null) handle.doAction(this);
	}

	/**
	 * ե뿷ν
	 */	
	public void handleFileNew() {
		int id = tabFolder.getItemCount();
//		ControlSet cset = new ControlSet(cm.getNewFileName(), true, tabFolder, count, id);
		ControlSet cset = new ControlSet(cm.getNewFileName(),
		                             true, tabFolder, count, id,
		                             status, lineColumn);
		cm.addControlSet(new Integer(count), cset);
		count++;

		tabFolder.setSelection(tabFolder.getItemCount() - 1);

		if (fontManager.getNowFont() != null) {
			cset.getStyledText().setFont(fontManager.getNowFont());
		}
		cset.setDropText(this);
		nowControlSet = cset;

		if (tabFolder.getItemCount() > 0) {
			mm.getItemFileClose().setEnabled(true);
			mm.getItemFileSave().setEnabled(true);
			mm.getItemFileSaveAs().setEnabled(true);
		}
	}

	/**
	 * ե볫ν
	 */
	public void handleFileOpen() {
		final String text = fm.getOpenFileString();
		if (text == null) {
			System.out.println("(Text is null)");
			return;
		}

		if (nowControlSet == null) {
			handleFileNew();
		}
		if ((nowControlSet.getEdited()) || (!nowControlSet.getFlgNew())) {
			handleFileNew();
		}
		String fname = fm.getFileName();
		nowControlSet.setFlgNew(false);
		nowControlSet.setFileName(fname);
		nowControlSet.setFullName(fm.getFullName());
		nowControlSet.setPath(fm.getPath());
		nowControlSet.setTabItemText(fname);

		Display display = nowControlSet.getStyledText().getDisplay();
		display.asyncExec(new Runnable() {
			public void run() {
				nowControlSet.getStyledText().setText(text);
				nowControlSet.setEdited(false);
			}
		});

	}

	/**
	 * ե򳫤(DnDʣ)
	 */
	public void handleFileOpen(String[] fileNames) {
		if (fileNames == null || fileNames.length == 0) return;
		String text = "";
		for (int i = 0; i < fileNames.length; i++) {
			System.out.println(fileNames[i]);

			if (fm.isFile(fileNames[i])) {

				text = fm.getOpenFileString(fileNames[i]);

				if (text == null) {
					System.out.println("(Text is null)");
					return;
				}
				if (nowControlSet == null) {
					handleFileNew();
				}
				if ((nowControlSet.getEdited()) || (!nowControlSet.getFlgNew())) {
					handleFileNew();
				}
				String fname = fm.getFileName();
				nowControlSet.setFlgNew(false);
				nowControlSet.setFileName(fname);
				nowControlSet.setFullName(fm.getFullName());
				nowControlSet.setPath(fm.getPath());
				nowControlSet.setTabItemText(fname);

				setSyncText(text);

			}
		}
	}

	/**
	 * nowControlSet˥ץ󤷤ƥȤꤹ
	 * @param text
	 */
	public void setSyncText(final String text) {
		Display display = nowControlSet.getStyledText().getDisplay();
		display.syncExec(new Runnable() {
			public void run() {
				nowControlSet.getStyledText().setText(text);
				nowControlSet.setEdited(false);
			}
		});
	}

	/**
	 * եĤν
	 */
	public void handleFileClose() {
		if (nowControlSet.getEdited()) {
			int result = fm.messageFileChanged(nowControlSet.getFileName());
			if (result == SWT.CANCEL) {
				return;
			} else if (result == SWT.YES) {
				// ¸ν򤹤롢ԤϤɤ?
				if (fm.fileCanWrite(nowControlSet.getFullName())) {
					handleFileSave();
				} else {
					handleFileSaveAs();
				}
				// Ԥ꥿
				if (nowControlSet.getEdited()) return;
			} else if (result == SWT.NO) {
				// ⤷ʤĤ˰ܤ
			} else {
				// ʳϥ󥻥Ʊ
				return;
			}
		}

		int rmID = nowControlSet.getID();
		Integer rmKey = new Integer(nowControlSet.getKey());

		// IDοľ
		Enumeration enum = cm.getControlSets().elements();
		ControlSet cset;
		while (enum.hasMoreElements()) {
			cset = (ControlSet)enum.nextElement();
			if (rmID < cset.getID()) cset.decrementID();
		}
		// ֥ȤControlManagerΥ쥯󤫤
		// TabItemĤ
		cm.removeControlSet(rmKey);
		nowControlSet.getTabItem().dispose();

		if (tabFolder.getItemCount() < 1) {
			mm.getItemFileClose().setEnabled(false);
			mm.getItemFileSave().setEnabled(false);
			mm.getItemFileSaveAs().setEnabled(false);
			nowControlSet = null;
		}
		
		// Line,Column٥
		initLineColumn();
	}

	/**
	 * ե¸ν
	 */
	public void handleFileSave() {
		String result = null;
		// ΥեǤ¸ɽ
		// ޤץ󤷤եǤ¸ߤʤХɽ
		if (nowControlSet.getFlgNew() ||
			fm.isFileExists(nowControlSet.getFullName()) == false) {

			handleFileSaveAs();
			return;
		}
		setSaveFileNames();
		result = fm.saveText(nowControlSet.getStyledText().getText());
		if (result != null) {
			nowControlSet.setEdited(false);
		}
	}

	/**
	 * ե̾դ¸ν
	 */
	public void handleFileSaveAs() {
		String result = null;
		setSaveFileNames();
		result = fm.saveAsText(nowControlSet.getStyledText().getText());
		if (result != null) {
			String fname = fm.getSavedFileName();
			nowControlSet.setFlgNew(false);
			nowControlSet.setFileName(fname);
			nowControlSet.setFullName(result);
			nowControlSet.setPath(fm.getSavedPath());
			nowControlSet.setTabItemText(fname);

			nowControlSet.setEdited(false);

			System.out.println("File Saved !!!");
		}
	}

	/**
	 * ե뽪λν
	 */
	public void handleFileExit() {
		getShell().close();
	}

	/**
	 * ԽUndoν
	 */
	public void handleEditUndo() {
		if (nowControlSet != null) {
			nowControlSet.undo();
		}
	}

	/**
	 * ԽRedoν
	 */
	public void handleEditRedo() {
		if (nowControlSet != null) {
			nowControlSet.redo();
		}
	}

	/**
	 * Խڤν
	 */
	public void handleEditCut() {
		if (nowControlSet != null) {
			nowControlSet.getStyledText().cut();
		}
	}

	/**
	 * Խԡν
	 */
	public void handleEditCopy() {
		if (nowControlSet != null) {
			nowControlSet.getStyledText().copy();
		}
	}

	/**
	 * ԽŽդν
	 */
	public void handleEditPaste() {
		if (nowControlSet != null) {
			nowControlSet.getStyledText().paste();
		}
	}

	/**
	 * եν
	 */
	public void handleSettingFont() {
		if (fontManager.getFontData() == null) setNowFontData();
		if (fontManager.getFont() != null) {
			Enumeration enum = cm.getControlSets().elements();
			ControlSet cset;
			while (enum.hasMoreElements()) {
				cset = (ControlSet)enum.nextElement();
				cset.getStyledText().setFont(fontManager.getNowFont());
			}
		}
	}

	/**
	 * ꥨ󥳡ǥν
	 */
	public void handleSettingEncode() {
//		System.out.println(mm.getNowEncoding());
		fm.setEncoding(mm.getNowEncoding());
	}

	/**
	 * إץХν
	 */
	public void handleHelpAbout() {
		String msg = "    JLightEditor Ver.0.1    ";
		message.displayInformation(msg);
	}


	/**
	 * nowControlSetStyledTextꤵƤեȤեȥޥ͡
	 */
	private void setNowFontData() {
		if (tabFolder.getItemCount() < 1) return;
		FontData[] fd = nowControlSet.getStyledText().getFont().getFontData();
		FontData fontData = new FontData(fd[0].getName(),
						fd[0].getHeight(), fd[0].getStyle());

		fontManager.setFontData(fontData);
	}

	/**
	 * ¸ե̾եޥ͡
	 */
	private void setSaveFileNames() {
		setSaveFileNames(nowControlSet);
	}

	/**
	 * ¸ե̾եޥ͡()
	 * @param cset
	 */
	private void setSaveFileNames(ControlSet cset) {
		if (cset != null) {
			fm.setSaveFileName(cset.getFileName());
			fm.setSaveFullName(cset.getFullName());
			fm.setSavePath(cset.getPath());
		}
	}

	/**
	 * Shell˥ꥹʡ(λν)
	 */
	private void setShellListener() {
		getShell().addListener(SWT.Close, new Listener() {
			public void handleEvent(Event event) {
				if (nowControlSet == null || getEditedTexts() == false) return;
//				if (!saveNewAndReadOnlyFiles()) {
//					event.doit = false;
//					return;
//				}
				SaveDialog saveDialog = new SaveDialog(getShell(), cm, fm);
				event.doit = saveDialog.initDialog() == SWT.OK;
			}
		});
	}

	/**
	 * 줿ƥȤ뤫ɤõ
	 * @return boolean
	 */
	private boolean getEditedTexts() {
		boolean edited = false;
		Enumeration enum = cm.getControlSets().elements();
		if (enum == null) return edited;
		ControlSet cset;
		while (enum.hasMoreElements()) {
			cset = (ControlSet)enum.nextElement();
			if (cset.getEdited()) {
				edited = true;
				break;
			} 
		}
		return edited;
	}

	/**
	 * եȥ꡼ɥ꡼եξ硢ɽ
	 * ե¸ܤ(Ȥʤ)
	 * @return boolean
	 */
	private boolean saveNewAndReadOnlyFiles() {
		Enumeration enum = cm.getControlSets().elements();
		if (enum == null) return true;
		ControlSet cset;

		while (enum.hasMoreElements()) {
			cset = (ControlSet)enum.nextElement();
			if ((cset.getEdited() && cset.getFlgNew()) ||
				(cset.getEdited() && !cset.getFlgNew() &&
				!fm.fileCanWrite(cset.getFullName()))) {

				tabFolder.setSelection(cset.getID());
				setNowControlSet(cset.getID());
				
				int result = fm.messageFileChanged(cset.getFileName());
				if (result == SWT.NO) {
				
				} else if (result == SWT.YES) {
					setSaveFileNames(cset);
					String rs = fm.saveAsText(cset.getStyledText().getText());
					if (rs != null) {
						String fname = fm.getSavedFileName();
						cset.setFlgNew(false);
						cset.setFileName(fname);
						cset.setFullName(rs);
						cset.setPath(fm.getSavedPath());
						cset.setTabItemText(fname);
						cset.setEdited(false);
					} else {
						return false;
					}
				} else {
					return false;
				}
			}
		}
		return true;
	}


}

