/* -----------------------------------------------------------------------
 Resources.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/02/25
 *
 * File Name: Resources.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 * 
 */
package jp.co.jlight;

import java.util.ResourceBundle;
/**
 * ץꥱѤ꥽륯饹
 */
public class Resources {
	
	private static ResourceBundle resources = ResourceBundle.getBundle("resources.jlighteditor");
	
	/**
	 * ᥤ󥿥ȥ
	 * @return String
	 */
	public String getTitle() {
		return resources.getString("MainTitle");
	}
	/**
	 * File˥塼ʸ
	 * @return String
	 */
	public String getMenuFile() {
		return resources.getString("MenuItem.File");
	}
	/**
	 * Edit˥塼ʸ
	 * @return String
	 */
	public String getMenuEdit() {
		return resources.getString("MenuItem.Edit");
	}
	/**
	 * Setting˥塼ʸ
	 * @return String
	 */
	public String getMenuSetting() {
		return resources.getString("MenuItem.Setting");
	}
	/**
	 * Help˥塼ʸ
	 * @return String
	 */
	public String getMenuHelp() {
		return resources.getString("MenuItem.Help");
	}


	/**
	 * File.New˥塼ʸ
	 * @return String
	 */
	public String getItemFileNew() {
		return resources.getString("MenuItem.File.New");
	}
	/**
	 * File.Open˥塼ʸ
	 * @return String
	 */
	public String getItemFileOpen() {
		return resources.getString("MenuItem.File.Open");
	}
	/**
	 * File.Close˥塼ʸ
	 * @return String
	 */
	public String getItemFileClose() {
		return resources.getString("MenuItem.File.Close");
	}
	/**
	 * File.Save˥塼ʸ
	 * @return String
	 */
	public String getItemFileSave() {
		return resources.getString("MenuItem.File.Save");
	}
	/**
	 * File.SaveAs˥塼ʸ
	 * @return String
	 */
	public String getItemFileSaveAs() {
		return resources.getString("MenuItem.File.SaveAs");
	}
	/**
	 * File.Exit˥塼ʸ
	 * @return String
	 */
	public String getItemFileExit() {
		return resources.getString("MenuItem.File.Exit");
	}


	/**
	 * Edit.Undo˥塼ʸ
	 * @return String
	 */
	public String getItemEditUndo() {
		return resources.getString("MenuItem.Edit.Undo");
	}
	/**
	 * Edit.Redo˥塼ʸ
	 * @return String
	 */
	public String getItemEditRedo() {
		return resources.getString("MenuItem.Edit.Redo");
	}
	/**
	 * Edit.Cut˥塼ʸ
	 * @return String
	 */
	public String getItemEditCut() {
		return resources.getString("MenuItem.Edit.Cut");
	}
	/**
	 * Edit.Copy˥塼ʸ
	 * @return String
	 */
	public String getItemEditCopy() {
		return resources.getString("MenuItem.Edit.Copy");
	}
	/**
	 * Edit.Paste˥塼ʸ
	 * @return String
	 */
	public String getItemEditPaste() {
		return resources.getString("MenuItem.Edit.Paste");
	}


	/**
	 * Setting.Font˥塼ʸ
	 * @return String
	 */
	public String getItemFont() {
		return resources.getString("MenuItem.Setting.Font");
	}
	/**
	 * Setting.Encoding˥塼ʸ
	 * @return String
	 */
	public String getItemEncoding() {
		return resources.getString("MenuItem.Setting.Encoding");
	}


	/**
	 * Help.About˥塼ʸ
	 * @return String
	 */
	public String getItemHelpAbout() {
		return resources.getString("MenuItem.Help.About");
	}


	/**
	 * եΥȥ
	 * @return String
	 */
	public String getFontDialogTitle() {
		return resources.getString("FontDialogTitle");
	}
	/**
	 * ե¸Υȥ
	 * @return String
	 */
	public String getFileSaveDialogTitle() {
		return resources.getString("FileSaveDialogTitle");
	}
	/**
	 * ե򳫤Υȥ
	 * @return String
	 */
	public String getFileOpenDialogTitle() {
		return resources.getString("FileOpenDialogTitle");
	}
}
