/* -----------------------------------------------------------------------
 CommandMacro.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/11/09
 *
 * File Name: CommandMacro.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight.undo;

import java.util.*;
/**
 * CommandUnit򥹥åˤޤȤ
 */
class CommandMacro {

	private Stack macro = new Stack();
	private Stack rmc = new Stack();


	void append(CommandUnit commandUnit) {
		macro.push(commandUnit);
	}
	
	void clear() {
		macro.clear();
	}
	
	void undo() {
		for (int i = macro.size() - 1; i >= 0; i--) {
			((CommandUnit)macro.get(i)).undoText();
		}
	}
	
	void redo() {
		Iterator it = macro.iterator();
		while (it.hasNext()) {
			((CommandUnit)it.next()).redoText();
		}
	}

	private Stack getCommandMacroStack() {
		rmc.clear();
		for (int i = macro.size() - 1; i >= 0; i--) {
			rmc.push(((CommandUnit)macro.get(i)).getCommandUnitReverse());
		}
		return rmc;
	}
	
	CommandMacro getCommandMacroReverse() {
		CommandMacro cm = new CommandMacro();
		getCommandMacroStack();
		Iterator it = rmc.iterator();
		while (it.hasNext()) {
			cm.append((CommandUnit)it.next());
		}
		return cm;
	}

}
