/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.CopyAncestorOption;
import org.asyrinx.joey.gen.command.rdb2java.PackagingStrategy;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.PackageType;

public class BasicPackaging
implements PackagingStrategy {
    private final Map properties;
    private CopyAncestorOption categoryResolver = new CopyAncestorOption("category");
    private static final String TEMPLATE_SYMBOL = "${category}";
    private static final Map PACKAGE_TEMPLATES = BasicPackaging.initPackageTemplates();

    public BasicPackaging(Map properties) {
        this.properties = properties;
    }

    public void preparePackageNames(Entity entity) {
        Element original = entity.getOriginal();
        if (original == null) {
            return;
        }
        String entityCategory = this.categoryResolver.getOptionValue(original);
        Iterator i = PackageType.getElements().iterator();
        while (i.hasNext()) {
            PackageType packageType = (PackageType)((Object)i.next());
            String template = (String)PACKAGE_TEMPLATES.get((Object)packageType);
            String packageName = String.valueOf(this.getPackageHeader()) + StringUtils.replace((String)template, (String)TEMPLATE_SYMBOL, (String)entityCategory);
            entity.setPackage(packageType.getName(), packageName);
        }
    }

    public void preparePackageName(JavaEnumeration javaEnumeration) {
        Element original = javaEnumeration.getOriginal();
        if (original == null) {
            return;
        }
        String entityCategory = this.categoryResolver.getOptionValue(original);
        String template = (String)PACKAGE_TEMPLATES.get((Object)PackageType.ENTITY);
        String packageName = String.valueOf(this.getPackageHeader()) + StringUtils.replace((String)template, (String)TEMPLATE_SYMBOL, (String)entityCategory);
        javaEnumeration.setPackageName(packageName);
    }

    private static Map initPackageTemplates() {
        HashMap<PackageType, String> result = new HashMap<PackageType, String>();
        String omHeader = "om.${category}";
        result.put(PackageType.ENTITY, "om.${category}.entity");
        result.put(PackageType.DAO, "om.${category}.dao");
        result.put(PackageType.DAO_HIBERNATE, "om.${category}.dao.hibernate");
        result.put(PackageType.SERVICE, "om.${category}.service");
        result.put(PackageType.SERVICE_IMPL, "om.${category}.service.impl");
        result.put(PackageType.VIEW_SWING_COMPONENT, "swing.component.${category}");
        result.put(PackageType.VIEW_SWING_PAGE, "swing.mst.${category}");
        result.put(PackageType.VIEW_TAPESTRY_COMPONENT, "tapestry.component.${category}");
        result.put(PackageType.VIEW_TAPESTRY_PAGE, "tapestry.mst.${category}");
        return result;
    }

    public String getPackageHeader() {
        if (this.properties == null) {
            return "";
        }
        return String.valueOf((String)this.properties.get("joey-gen.proj.base.package")) + ".";
    }
}

