/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.EntitySet;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.JavaEnumerationSet;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;

public class AppDomain
extends Element {
    private final EntitySet classes = new EntitySet(this);
    private final JavaEnumerationSet enumerations = new JavaEnumerationSet(this);

    public AppDomain() {
    }

    public AppDomain(String name) {
        super(name);
    }

    public void add(Element element) {
        if (element instanceof Entity) {
            this.classes.add((Entity)element);
        } else if (element instanceof JavaEnumeration) {
            this.enumerations.add((JavaEnumeration)element);
        } else {
            super.add(element);
        }
    }

    public EntitySet getClasses() {
        return this.classes;
    }

    public JavaEnumerationSet getEnumerations() {
        return this.enumerations;
    }

    public List getReferencesContainedAsForeign(Property property) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        Iterator i = this.getClasses().iterator();
        while (i.hasNext()) {
            Entity javaClass = (Entity)i.next();
            Iterator j = javaClass.getReferences().iterator();
            while (j.hasNext()) {
                Reference reference = (Reference)j.next();
                if (!reference.containsAsForeign(property)) continue;
                result.add(reference);
            }
        }
        return result;
    }

    public List getReferencesContainedAsForeign(Entity javaClass) {
        ArrayList result = new ArrayList();
        Iterator i = this.getClasses().iterator();
        while (i.hasNext()) {
            Entity class1 = (Entity)i.next();
            class1.findReferencesContainedAsForeign(javaClass, result);
        }
        return result;
    }

    public List getReferencesContainedAsLocal(Entity javaClass) {
        ArrayList result = new ArrayList();
        Iterator i = this.getClasses().iterator();
        while (i.hasNext()) {
            Entity class1 = (Entity)i.next();
            class1.findReferencesContainedAsLocal(javaClass, result);
        }
        return result;
    }

    public List findReferences(Entity local, Entity foreign) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        Iterator i = this.getReferencesContainedAsLocal(local).iterator();
        while (i.hasNext()) {
            Reference reference = (Reference)i.next();
            if (reference.getReferenceClass() != foreign) continue;
            result.add(reference);
        }
        return result;
    }
}

