/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asyrinx.brownie.core.collection.maptree.MapTreeKey;

public interface MapTreeKeyFactory {
    public MapTreeKey createKey(Object var1);

    public static class Simple
    implements MapTreeKeyFactory {
        public MapTreeKey createKey(Object object) {
            if (object == null) {
                return MapTreeKey.NULL;
            }
            if (object instanceof Object[]) {
                return new MapTreeKey.Default((Object[])object);
            }
            if (object instanceof List) {
                return new MapTreeKey.Default(((List)object).toArray());
            }
            return null;
        }
    }

    public static class Wrapper
    implements MapTreeKeyFactory {
        protected final MapTreeKeyFactory wrapped;

        public Wrapper(MapTreeKeyFactory wrapped) {
            this.wrapped = wrapped;
        }

        public MapTreeKey createKey(Object object) {
            return this.wrapped.createKey(object);
        }
    }

    public static final class BufferedKeyFactory
    extends Wrapper {
        public BufferedKeyFactory(MapTreeKeyFactory wrapped) {
            super(wrapped);
        }

        public MapTreeKey createKey(Object object) {
            return new MapTreeKey.Buffered(super.createKey(object));
        }
    }

    public static class KeyPool
    extends Wrapper {
        final Map objectKeyMap = new HashMap();

        public KeyPool(MapTreeKeyFactory wrapped) {
            super(wrapped);
        }

        private MapTreeKey getKey(Object object) {
            return (MapTreeKey)this.objectKeyMap.get(object);
        }

        public MapTreeKey createKey(Object object) {
            MapTreeKey pooled = this.getKey(object);
            if (pooled != null) {
                return pooled;
            }
            MapTreeKey result = super.createKey(object);
            this.objectKeyMap.put(object, result);
            return result;
        }
    }
}

