/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection.matrix;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.asyrinx.brownie.core.collection.matrix.MapMatrix;

public abstract class AbstractMapMatrix
implements MapMatrix {
    private Map baseRows = this.newBaseRowsMap();

    public String toString() {
        return String.valueOf(this.baseRows);
    }

    private Map findByRow(Object row) {
        return (Map)this.baseRows.get(row);
    }

    protected abstract Map newRowMap();

    protected abstract Map newBaseRowsMap();

    protected abstract Map newGetColResult();

    protected abstract Map newGetRowResult(Map var1);

    protected abstract Set newColKeySet();

    protected abstract Set newRowKeySet(Set var1);

    private Map needByRow(Object row) {
        Map result = this.findByRow(row);
        if (result == null) {
            result = this.newRowMap();
            this.baseRows.put(row, result);
        }
        return result;
    }

    public Object get(Object col, Object row) {
        Map source = this.findByRow(row);
        if (source == null) {
            return null;
        }
        return source.get(col);
    }

    public void put(Object col, Object row, Object value) {
        Map dest = this.needByRow(row);
        dest.put(col, value);
    }

    public void remove(Object col, Object row) {
        Map source = this.findByRow(row);
        if (source == null) {
            return;
        }
        source.remove(col);
    }

    public void clear() {
        this.baseRows.clear();
    }

    public Set colKeySet() {
        Set result = this.newColKeySet();
        Iterator iter = this.baseRows.keySet().iterator();
        while (iter.hasNext()) {
            Map row = (Map)this.baseRows.get(iter.next());
            result.addAll(row.keySet());
        }
        return result;
    }

    public Set rowKeySet() {
        Set result = this.newRowKeySet(this.baseRows.keySet());
        return result;
    }

    public Map getCol(Object colKey) {
        Map result = this.newGetColResult();
        Iterator iter = this.baseRows.keySet().iterator();
        while (iter.hasNext()) {
            Object rowKey = iter.next();
            Map row = (Map)this.baseRows.get(rowKey);
            Object val = row.get(colKey);
            if (val == null) continue;
            result.put(rowKey, val);
        }
        return result;
    }

    public Map getRow(Object rowKey) {
        return this.newGetRowResult(this.findByRow(rowKey));
    }
}

