/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.query.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.query.model.Field;
import org.asyrinx.brownie.core.query.model.TableAlias;

public class Table {
    private String rdbName;
    private String javaName;
    private final List fields = new ArrayList();
    private final Map aliasMap = new HashMap();

    public Table(String rdbName, String javaName) {
        this.rdbName = rdbName;
        this.javaName = javaName;
    }

    public String getRdbName() {
        return this.rdbName;
    }

    public void setRdbName(String name) {
        this.rdbName = name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public Table add(Field field) {
        if (field == null) {
            return null;
        }
        if (this.contains(field)) {
            return this;
        }
        this.fields.add(field);
        if (field.getTable() != this) {
            field.setParent(this);
        }
        return this;
    }

    public Table addField(Class type, String rdbName) {
        return this.addField(type, rdbName, null);
    }

    public Table addField(Class type, String rdbName, String format) {
        return this.add(new Field(this, type, rdbName, format));
    }

    public void clear() {
        this.fields.clear();
    }

    public boolean contains(Field field) {
        return this.fields.contains(field);
    }

    public boolean equals(Object obj) {
        return this.fields.equals(obj);
    }

    public Field get(int index) {
        return (Field)this.fields.get(index);
    }

    public Field getField(String fieldName) {
        int index = this.indexOfRdbName(fieldName);
        if (index < 0) {
            return null;
        }
        return this.get(index);
    }

    public int indexOf(Field field) {
        return this.fields.indexOf(field);
    }

    public int indexOfRdbName(String rdbName) {
        if (StringUtils.isEmpty((String)rdbName)) {
            return -1;
        }
        int i = 0;
        while (i < this.fields.size()) {
            Field field = (Field)this.fields.get(i);
            if (rdbName.equals(field.getRdbName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOfJavaName(String javaName) {
        if (StringUtils.isEmpty((String)javaName)) {
            return -1;
        }
        int i = 0;
        while (i < this.fields.size()) {
            Field field = (Field)this.fields.get(i);
            if (javaName.equals(field.getJavaName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public Iterator iterator() {
        return this.fields.iterator();
    }

    public boolean remove(Field field) {
        return this.fields.remove(field);
    }

    public int size() {
        return this.fields.size();
    }

    public Field[] toArray() {
        return (Field[])this.fields.toArray();
    }

    public TableAlias findAlias(String name) {
        return (TableAlias)this.aliasMap.get(name);
    }

    public TableAlias alias() {
        return this.alias(this.getRdbName());
    }

    public TableAlias alias(String aliasName) {
        TableAlias alias = this.findAlias(aliasName);
        if (alias != null) {
            return alias;
        }
        TableAlias resutl = new TableAlias(this, aliasName);
        this.aliasMap.put(aliasName, resutl);
        return resutl;
    }
}

