/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.lang.ArrayUtils;

public abstract class InsertBean
extends AbstractComponent {
    private final LocalRenderer tagAttrRenderer = new LocalRenderer(){

        public void render(IMarkupWriter writer, String key, String value) {
            writer.attribute(key, value);
        }
    };
    private final LocalRenderer asTextRenderer = new LocalRenderer(){

        public void render(IMarkupWriter writer, String key, String value) {
            writer.print(' ');
            writer.print(key);
            writer.print("=\"");
            writer.print(value);
            writer.print('\"');
        }
    };

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String element;
        if (cycle.isRewinding()) {
            return;
        }
        Object bean = this.getBean();
        if (bean == null) {
            return;
        }
        Map map = this.getPropertyMap();
        if (bean == null) {
            return;
        }
        String styleClass = this.getStyleClass();
        if (styleClass != null) {
            map.put("class", styleClass);
        }
        if (!StringUtils.isEmpty((String)(element = this.getElement()))) {
            writer.begin(element);
            this.renderAttributes(writer, map, this.tagAttrRenderer);
            this.renderInformalParameters(writer, cycle);
            IMarkupWriter nested = writer.getNestedWriter();
            this.renderBody(nested, cycle);
            nested.close();
            writer.end(element);
        } else {
            this.renderAttributes(writer, map, this.asTextRenderer);
        }
    }

    private Map getPropertyMap() {
        Collection propNames = this.toCollection(this.getProperties(), "properties");
        Map result = propNames == null || propNames.isEmpty() ? this.getPropertyMapByDesc() : this.getPropertyMapByEach();
        this.deleteIgnoreProp(result);
        return result;
    }

    private Map getPropertyMapByDesc() {
        Map result;
        try {
            result = PropertyUtils.describe((Object)this.getBean());
        }
        catch (Exception e) {
            if (this.isStrict()) {
                throw new ApplicationRuntimeException((Throwable)e);
            }
            return new HashMap();
        }
        return result;
    }

    private Map getPropertyMapByEach() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object bean = this.getBean();
        Collection propNames = this.toCollection(this.getProperties(), "properties");
        Iterator i = propNames.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (key == null) continue;
            String propName = String.valueOf(key);
            try {
                Object value = PropertyUtils.getProperty((Object)bean, (String)propName);
                result.put(propName, value);
            }
            catch (Exception e) {
                if (!this.isStrict()) continue;
                throw new ApplicationRuntimeException((Throwable)e);
            }
        }
        return result;
    }

    private void deleteIgnoreProp(Map result) {
        result.remove("class");
        Collection ignorePropNames = this.toCollection(this.getIgnoreProperties(), "ignoreProperties");
        if (ignorePropNames == null || ignorePropNames.isEmpty()) {
            return;
        }
        Iterator i = ignorePropNames.iterator();
        while (i.hasNext()) {
            result.remove(i.next());
        }
    }

    private void renderAttributes(IMarkupWriter writer, Map map, LocalRenderer renderer) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            if (value == null || StringUtils.isEmpty((String)value.toString())) continue;
            renderer.render(writer, key, value.toString());
        }
    }

    protected Collection toCollection(Object object, String propName) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object.getClass().isArray()) {
            return ArrayUtils.toArrayList((Object[])object);
        }
        throw new ApplicationRuntimeException(String.valueOf(propName) + "was neither Collection nor Object[]");
    }

    public abstract Object getBean();

    public abstract String getElement();

    public abstract String getStyleClass();

    public abstract Object getProperties();

    public abstract Object getIgnoreProperties();

    public abstract boolean isStrict();

    interface LocalRenderer {
        public void render(IMarkupWriter var1, String var2, String var3);
    }
}

