/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/14 14:37:58
 */
package org.asyrinx.joey.s2hibernate;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.type.Type;

import org.seasar.hibernate.HibernateRuntimeException;
import org.seasar.hibernate.S2Session;

/**
 * @author takeshi
 */
public class S2SessionWrapper implements S2Session {

    /**
     *  
     */
    public S2SessionWrapper(S2Session impl) {
        super();
        this.impl = impl;
    }

    protected final S2Session impl;

    public Transaction beginTransaction() throws HibernateRuntimeException {
        return impl.beginTransaction();
    }

    public void cancelQuery() throws HibernateRuntimeException {
        impl.cancelQuery();
    }

    public void clear() {
        impl.clear();
    }

    public Connection close() throws HibernateRuntimeException {
        return impl.close();
    }

    public Connection connection() throws HibernateRuntimeException {
        return impl.connection();
    }

    public boolean contains(Object object) {
        return impl.contains(object);
    }

    public Criteria createCriteria(Class persistentClass) {
        return impl.createCriteria(persistentClass);
    }

    public Query createFilter(Object collection, String queryString) throws HibernateRuntimeException {
        return impl.createFilter(collection, queryString);
    }

    public Query createQuery(String queryString) throws HibernateRuntimeException {
        return impl.createQuery(queryString);
    }

    public Query createSQLQuery(String sql, String returnAlias, Class returnClass) {
        return impl.createSQLQuery(sql, returnAlias, returnClass);
    }

    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses) {
        return impl.createSQLQuery(sql, returnAliases, returnClasses);
    }

    public void delete(Object object) throws HibernateRuntimeException {
        impl.delete(object);
    }

    public int delete(String query) throws HibernateRuntimeException {
        return impl.delete(query);
    }

    public int delete(String query, Object value, Type type) throws HibernateRuntimeException {
        return impl.delete(query, value, type);
    }

    public int delete(String query, Object[] values, Type[] types) throws HibernateRuntimeException {
        return impl.delete(query, values, types);
    }

    public Connection disconnect() throws HibernateRuntimeException {
        return impl.disconnect();
    }

    public void evict(Object object) throws HibernateRuntimeException {
        impl.evict(object);
    }

    public Collection filter(Object collection, String filter) throws HibernateRuntimeException {
        return impl.filter(collection, filter);
    }

    public Collection filter(Object collection, String filter, Object value, Type type)
            throws HibernateRuntimeException {
        return impl.filter(collection, filter, value, type);
    }

    public Collection filter(Object collection, String filter, Object[] values, Type[] types)
            throws HibernateRuntimeException {
        return impl.filter(collection, filter, values, types);
    }

    public List find(String query) throws HibernateRuntimeException {
        return impl.find(query);
    }

    public List find(String query, Object value, Type type) throws HibernateRuntimeException {
        return impl.find(query, value, type);
    }

    public List find(String query, Object[] values, Type[] types) throws HibernateRuntimeException {
        return impl.find(query, values, types);
    }

    public void flush() throws HibernateRuntimeException {
        impl.flush();
    }

    public Object get(Class clazz, Serializable id) throws HibernateRuntimeException {
        return impl.get(clazz, id);
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateRuntimeException {
        return impl.get(clazz, id, lockMode);
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateRuntimeException {
        return impl.getCurrentLockMode(object);
    }

    public FlushMode getFlushMode() {
        return impl.getFlushMode();
    }

    public Serializable getIdentifier(Object object) throws HibernateRuntimeException {
        return impl.getIdentifier(object);
    }

    public Query getNamedQuery(String queryName) throws HibernateRuntimeException {
        return impl.getNamedQuery(queryName);
    }

    public Session getSession() {
        return impl.getSession();
    }

    public SessionFactory getSessionFactory() {
        return impl.getSessionFactory();
    }

    public boolean isConnected() {
        return impl.isConnected();
    }

    public boolean isDirty() throws HibernateRuntimeException {
        return impl.isDirty();
    }

    public boolean isOpen() {
        return impl.isOpen();
    }

    public Iterator iterate(String query) throws HibernateRuntimeException {
        return impl.iterate(query);
    }

    public Iterator iterate(String query, Object value, Type type) throws HibernateRuntimeException {
        return impl.iterate(query, value, type);
    }

    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateRuntimeException {
        return impl.iterate(query, values, types);
    }

    public Object load(Class theClass, Serializable id) throws HibernateRuntimeException {
        return impl.load(theClass, id);
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateRuntimeException {
        return impl.load(theClass, id, lockMode);
    }

    public void load(Object object, Serializable id) throws HibernateRuntimeException {
        impl.load(object, id);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateRuntimeException {
        impl.lock(object, lockMode);
    }

    public void reconnect() throws HibernateRuntimeException {
        impl.reconnect();
    }

    public void reconnect(Connection connection) throws HibernateRuntimeException {
        impl.reconnect(connection);
    }

    public void refresh(Object object) throws HibernateRuntimeException {
        impl.refresh(object);
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateRuntimeException {
        impl.refresh(object, lockMode);
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateRuntimeException {
        impl.replicate(object, replicationMode);
    }

    public Serializable save(Object object) throws HibernateRuntimeException {
        return impl.save(object);
    }

    public void save(Object object, Serializable id) throws HibernateRuntimeException {
        impl.save(object, id);
    }

    public void saveOrUpdate(Object object) throws HibernateRuntimeException {
        impl.saveOrUpdate(object);
    }

    public Object saveOrUpdateCopy(Object object) throws HibernateRuntimeException {
        return impl.saveOrUpdateCopy(object);
    }

    public Object saveOrUpdateCopy(Object object, Serializable id) throws HibernateRuntimeException {
        return impl.saveOrUpdateCopy(object, id);
    }

    public void setFlushMode(FlushMode flushMode) {
        impl.setFlushMode(flushMode);
    }

    public void update(Object object) throws HibernateRuntimeException {
        impl.update(object);
    }

    public void update(Object object, Serializable id) throws HibernateRuntimeException {
        impl.update(object, id);
    }
}