/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/08 6:02:25
 */
package org.asyrinx.joey.s2hibernate.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.seasar.servlet.S2ContainerLoader;
import org.seasar.framework.container.S2Container;

/**
 * @author takeshi
 */
public class OpenSessionInViewFilter implements Filter {

    final Log log = LogFactory.getLog(this.getClass());

    /**
     *  
     */
    public OpenSessionInViewFilter() {
        super();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException,
            ServletException {
        //S2Container container = SingletonS2ContainerFactory.getContainer();
        final ServletContext context;
        if (request instanceof HttpServletRequest) {
            context = ((HttpServletRequest) request).getSession().getServletContext();
        } else {
            throw new ServletException("Couldn't get S2Container because request isn't HttpSession but "
                    + request.getClass().getName());
        }
        final S2Container container = S2ContainerLoader.getContainer(context);
        final FilterChainTx chainProxy = (FilterChainTx) container
                .getComponent(FilterChainTx.class);
        chainProxy.doFilter(request, response, chain);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        //do nothing
    }

    public void destroy() {
        //do nothing
    }

}