/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/08 8:34:56
 */
package org.asyrinx.joey.s2hibernate.filter.impl;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.asyrinx.joey.s2hibernate.filter.FilterChainTx;
import org.asyrinx.joey.s2hibernate.filter.S2SessionFactorySurrogate;
import org.asyrinx.joey.s2hibernate.filter.S2SessionFactoryWrapper;
import org.seasar.hibernate.S2Session;

/**
 * @author takeshi
 */
public class FilterChainTxImpl implements FilterChainTx {

    private final S2SessionFactorySurrogate sessionFactory;

    private final S2SessionFactoryWrapper factoryWrapper;

    public FilterChainTxImpl(S2SessionFactorySurrogate sessionFactory, S2SessionFactoryWrapper factoryWrapper) {
        this.sessionFactory = sessionFactory;
        this.factoryWrapper = factoryWrapper;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException,
            ServletException {
        final S2Session s2session = factoryWrapper.getSession();
        sessionFactory.openSession(s2session);
        try {
            chain.doFilter(request, response);
        } finally {
            sessionFactory.closeSession();
        }
    }

}