/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/08 9:34:55
 */
package org.asyrinx.joey.s2hibernate.filter.impl;

import javax.sql.DataSource;
import javax.transaction.TransactionManager;

import org.asyrinx.joey.s2hibernate.filter.S2SessionFactoryWrapper;
import org.seasar.hibernate.S2Session;
import org.seasar.hibernate.impl.S2SessionFactoryImpl;

/**
 * @author takeshi
 */
public class S2SessionFactoryWrapperImpl implements S2SessionFactoryWrapper {

    public S2SessionFactoryWrapperImpl(TransactionManager transactionManager, DataSource dataSource) {
        this.impl = new S2SessionFactoryImpl(transactionManager, dataSource);
    }

    private final S2SessionFactoryImpl impl;

    public S2Session getSession() {
        return impl.getSession();
    }

}