/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/13 1:29:35
 */
package org.asyrinx.joey.tapestry.components.entity;

import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.tapestry.seasar.S2BaseComponent;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;

/**
 * @author takeshi
 */
public abstract class AbstractEntityActionLink extends S2BaseComponent implements IEntityServiceComponent {

    private final IEntityServiceStrategy entityServiceStrategy = new EntityServiceStrategyImpl(this);

    public EntityServiceDispatcher getDispatcher() {
        return entityServiceStrategy.getDispatcher();
    }

    public void linkAction(IRequestCycle cycle) {
        doAction(cycle);
    }

    protected abstract void doAction(IRequestCycle cycle);

    /**
     * @param cycle
     * @return
     */
    protected abstract Object deserialize(IRequestCycle cycle);

    protected abstract Object[] serialize();

    public Object[] getEntityParameter() {
        return serialize();
    }

}