/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/13 4:41:39
 */
package org.asyrinx.joey.tapestry.components.entity;

import java.io.Serializable;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;

/**
 * @author takeshi
 */
public abstract class AbstractEntityInstanceActionLink extends AbstractEntityActionLink {

    public Object getEntity() {
        final IBinding aEntityBinding = getEntityBinding();
        if (aEntityBinding != null)
            return aEntityBinding.getObject();
        else
            return null;
    }

    private IBinding _entityBinding = null;

    public IBinding getEntityBinding() {
        return _entityBinding;
    }

    public void setEntityBinding(IBinding entityBinding) {
        _entityBinding = entityBinding;
    }

    public abstract Class getEntityClass();

    public abstract Serializable getEntityPrimaryKey();

    public abstract String getKeyPropertyName();

    /**
     * @param cycle
     * @return
     */
    public Object deserialize(IRequestCycle cycle) {
        final Object[] parameters = cycle.getServiceParameters();
        final String entityClassName = (String) parameters[0];
        final Serializable pk = (Serializable) parameters[1];
        final Class entityClass;
        try {
            entityClass = Class.forName(entityClassName);
        } catch (ClassNotFoundException e) {
            throw new ApplicationRuntimeException("Class not found. '" + entityClassName + "'.");
        }
        final Object entity = getDispatcher().load(entityClass, pk);
        return entity;
    }

    private Serializable getPrimaryKey(Object entity) {
        try {
            return (Serializable) PropertyUtils.getProperty(entity, getKeyPropertyName());
        } catch (Exception e) {
            throw new ApplicationRuntimeException("couldn't get property value '" + getKeyPropertyName() + "'.");
        }
    }

    public Object[] serialize() {
        final IBinding aEntityBinding = getEntityBinding();
        if (aEntityBinding != null) {
            final Object aEntity = aEntityBinding.getObject();
            if (aEntity != null) {
                return new Object[] { aEntity.getClass().getName(), getPrimaryKey(aEntity) };
            } else {
                return null;
            }
        } else if (getEntityClass() != null) {
            if (getEntityPrimaryKey() != null) {
                return new Object[] { getEntityClass().getName(), getEntityPrimaryKey() };
            } else {
                return null;
            }
        } else if (getEntityClass() == null) {
            throw new ApplicationRuntimeException("entityClass was null");
        } else {
            throw new ApplicationRuntimeException("entityPrimaryKey was null");
        }
    }

}