/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/12 22:11:35
 */
package org.asyrinx.joey.tapestry.components.entity;

import org.apache.tapestry.IRequestCycle;
import org.asyrinx.joey.tapestry.page.EntityPageDictionary;
import org.asyrinx.joey.tapestry.page.IEntityPagingComponent;
import org.asyrinx.joey.tapestry.page.IEntityPagingStrategy;
import org.asyrinx.joey.tapestry.page.impl.EntityPagingStrategyImpl;

/**
 * @author takeshi
 */
public abstract class EntityDetailLink extends AbstractEntityInstanceActionLink implements IEntityPagingComponent {

    public abstract EntityPageDictionary getDetailPageDictionary();

    public abstract String getDetailPageDictionaryName();

    public abstract String getDetailPageName();

    private final IEntityPagingStrategy pagingStrategy = new EntityPagingStrategyImpl(this);

    /**
     * @param cycle
     */
    protected void doAction(IRequestCycle cycle) {
        final Object entity = deserialize(cycle);
        pagingStrategy.showEntity(cycle, entity);
    }

}