/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/15 9:53:55
 */
package org.asyrinx.joey.tapestry.components.entity;

import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;

/**
 * @author takeshi
 */
public class EntityServiceStrategyImpl implements IEntityServiceStrategy {

    /**
     *  
     */
    public EntityServiceStrategyImpl(IEntityServiceComponent owner) {
        super();
        this.owner = owner;
    }

    protected final IEntityServiceComponent owner;

    private EntityServiceDispatcher dispatcher = null;

    public EntityServiceDispatcher getDispatcher() {
        EntityServiceDispatcher result = owner.getEntityServiceDispatcher();
        if (result != null)
            return result;
        if (this.dispatcher != null)
            return this.dispatcher;
        if (!StringUtils.isEmpty(owner.getEntityServiceDispatcherName())) {
            result = (EntityServiceDispatcher) owner.getS2Container().getComponent(
                    owner.getEntityServiceDispatcherName());
            if (result != null)
                return result;
        }
        result = (EntityServiceDispatcher) owner.getS2Container().getComponent(EntityServiceDispatcher.class);
        if (result == null)
            throw new ApplicationRuntimeException("Component was not found. '" + owner.getEntityServiceDispatcherName()
                    + "'.");
        return result;
    }
}