/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/17 21:49:28
 */
package org.asyrinx.joey.tapestry.components.entity.table.impl;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.tapestry.seasar.S2BaseComponent;
import org.asyrinx.joey.tapestry.components.entity.table.IListTable;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableColumn;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableRow;

/**
 * @author takeshi
 */
public abstract class AbstractListTableColumnTemplate extends S2BaseComponent implements IListTableColumn {

    protected final ListTableColumnImpl impl;

    public AbstractListTableColumnTemplate() {
        super();
        impl = new ListTableColumnImpl(this);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        impl.renderComponent(writer, cycle);
    }

    public void renderCell(IMarkupWriter writer, IRequestCycle cycle, IListTableRow row) {
        impl.renderCell(writer, cycle, row);
    }

    public Object getValue(Object bean) {
        return impl.getValue(bean);
    }

    protected final void renderTemplate(IMarkupWriter writer, IRequestCycle cycle) {
        super.renderComponent(writer, cycle);
    }

    public abstract void renderCellContents(IMarkupWriter writer, IRequestCycle cycle);

    private IListTable table = null;

    public IListTable getTable() {
        return table;
    }

    public void setTable(IListTable table) {
        this.table = table;
    }
}