/*
 * joey-rt-test and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/11 23:38:27
 */
package org.asyrinx.joey.tapestry.components.entity.table.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.spec.IComponentSpecification;
import org.asyrinx.brownie.tapestry.seasar.S2AbstractComponent;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;
import org.asyrinx.joey.tapestry.components.entity.EntityServiceStrategyImpl;
import org.asyrinx.joey.tapestry.components.entity.IEntityServiceComponent;
import org.asyrinx.joey.tapestry.components.entity.IEntityServiceStrategy;
import org.asyrinx.joey.tapestry.components.entity.table.IListTable;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableColumn;
import org.asyrinx.joey.tapestry.page.EntityPageDictionary;
import org.asyrinx.joey.tapestry.page.IEntityPagingComponent;
import org.asyrinx.joey.tapestry.page.IEntityPagingStrategy;
import org.asyrinx.joey.tapestry.page.impl.EntityPagingStrategyImpl;

/**
 * @author takeshi
 */
public abstract class ListTable extends S2AbstractComponent implements IListTable, IEntityServiceComponent,
        IEntityPagingComponent {

    public void finishLoad(IRequestCycle cycle, IPageLoader loader, IComponentSpecification specification) {
        super.finishLoad(cycle, loader, specification);
    }

    private static final String ATTRIBUTE_NAME = "org.apache.tapestry.active.ListTable";

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        log.debug("renderComponent begin");

        if (cycle.getAttribute(ATTRIBUTE_NAME) != null)
            throw new ApplicationRuntimeException("ListTable may not nest");
        cycle.setAttribute(ATTRIBUTE_NAME, this);
        if (columns == null)
            columns = new ArrayList();
        else
            columns.clear();
        final IMarkupWriter nested = writer.getNestedWriter();
        renderBody(nested, cycle);
        // Start the table tag.
        writer.println();
        writer.begin(getElement());
        renderInformalParameters(writer, cycle);
        writer.println();
        nested.close();
        writer.end(); // <table>
        cycle.removeAttribute(ATTRIBUTE_NAME);

        log.debug("renderComponent end");
    }

    public static ListTable get(IRequestCycle cycle) {
        return (ListTable) cycle.getAttribute(ATTRIBUTE_NAME);
    }

    public abstract String getElement();

    public abstract void setElement(String element);

    protected void finishLoad() {
        setElement("table");
    }

    public abstract List getTargets();

    private final IEntityPagingStrategy pagingStrategy = new EntityPagingStrategyImpl(this);

    public EntityPageDictionary getPageDictionary() {
        return pagingStrategy.getPageDictionary();
    }

    protected IEntityServiceStrategy serviceStrategy = new EntityServiceStrategyImpl(this);

    public EntityServiceDispatcher getDispatcher() {
        return serviceStrategy.getDispatcher();
    }

    final Log log = LogFactory.getLog(this.getClass());

    private List columns = null;

    public List getColumns() {
        return Collections.unmodifiableList(columns);
    }

    public void addColumnDef(IListTableColumn columnDef) {
        log.debug("addColumnDef(" + columnDef + ")");
        columns.add(columnDef);
    }

}