/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/17 22:24:53
 */
package org.asyrinx.joey.tapestry.components.entity.table.impl;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;
import org.asyrinx.joey.tapestry.components.entity.EntityServiceStrategyImpl;
import org.asyrinx.joey.tapestry.components.entity.IEntityServiceComponent;
import org.asyrinx.joey.tapestry.components.entity.IEntityServiceStrategy;
import org.asyrinx.joey.tapestry.components.entity.table.IListTable;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableColumnAction;
import org.asyrinx.joey.tapestry.page.EntityPageDictionary;
import org.asyrinx.joey.tapestry.page.IEntityPagingComponent;
import org.asyrinx.joey.tapestry.page.IEntityPagingStrategy;
import org.asyrinx.joey.tapestry.page.impl.EntityPagingStrategyImpl;

/**
 * @author takeshi
 */
public abstract class ListTableColumnAction extends AbstractListTableColumnTemplate implements IListTableColumnAction,
        IEntityServiceComponent, IEntityPagingComponent {

    public void renderCellContents(IMarkupWriter writer, IRequestCycle cycle) {
        super.renderTemplate(writer, cycle);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        checkActionType();
        super.renderComponent(writer, cycle);
    }

    private void checkActionType() {
        final String actionType = getActionType();
        if (actionType != null)
            for (int i = 0; i < ACTION_TYPES.length; i++)
                if (actionType.equals(ACTION_TYPES[i]))
                    return;
        throw new ApplicationRuntimeException("Illegal actionType: " + actionType + ". actionType must be "
                + getActionTypeNames());
    }

    private static final String getActionTypeNames() {
        final StringBuffer result = new StringBuffer();
        for (int i = 0; i < ACTION_TYPES.length; i++) {
            if (i > 0)
                result.append(" or ");
            result.append('"');
            result.append(ACTION_TYPES[i]);
            result.append('"');
        }
        return result.toString();
    }

    public static final String[] ACTION_TYPES = new String[] { "delete", "detail", "choice" };

    private final IEntityPagingStrategy pagingStrategy = new EntityPagingStrategyImpl(this);

    public EntityPageDictionary getPageDictionary() {
        final EntityPageDictionary result = pagingStrategy.getPageDictionary();
        if (result != null)
            return result;
        final IListTable table = getTable();
        if (table == null)
            return null;
        setDetailPageDictionary(table.getPageDictionary());
        return getDetailPageDictionary();
    }

    protected IEntityServiceStrategy serviceStrategy = new EntityServiceStrategyImpl(this);

    public EntityServiceDispatcher getDispatcher() {
        final EntityServiceDispatcher result = serviceStrategy.getDispatcher();
        if (result != null)
            return result;
        final IListTable table = getTable();
        if (table == null)
            return null;
        setEntityServiceDispatcher(table.getDispatcher());
        return getEntityServiceDispatcher();
    }
}