/*
 * joey-sample1 and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/17 21:50:30
 */
package org.asyrinx.joey.tapestry.components.entity.table.impl;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.tapestry.util.BindingUtils;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableColumn;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableRow;

/**
 * @author takeshi
 */
public class ListTableColumnImpl {

    ListTableColumnImpl(IListTableColumn owner) {
        super();
        this.owner = owner;
    }

    private final IListTableColumn owner;

    void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        final ListTable table = ListTable.get(cycle);
        if (table == null)
            throw new ApplicationRuntimeException("ListTableRow may not be used without ListTable");
        owner.setTable(table);
        final AbstractListTableRow row = AbstractListTableRow.get(cycle);
        if (row == null) {
            //EntityListTableColumnDefgrenderingꂽƂEntityListTableɎgo^邾B
            //final ListTable table = ListTable.get(cycle);
            table.addColumnDef(owner);
        } else {
            //AbstractEntityListTableRow珈ϏꂽƂɎgrenderingB
            owner.renderCell(writer, cycle, row);
        }
    }

    private static final String ATTRIBUTE_NAME = "org.apache.tapestry.active.IListTableColumn";

    void renderCell(IMarkupWriter writer, IRequestCycle cycle, IListTableRow row) {
        if (cycle.getAttribute(ATTRIBUTE_NAME) != null)
            throw new ApplicationRuntimeException("IListTableColumn may not nest");
        cycle.setAttribute(ATTRIBUTE_NAME, this);
        //
        owner.setRow(row);
        final IMarkupWriter nested = writer.getNestedWriter();
        owner.renderCellContents(nested, cycle);
        //
        writer.println();
        writer.begin(row.getCellElement());
        BindingUtils.renderInformalParametersFilteredTail(owner, writer, cycle, StringUtils.capitalize(row
                .getCellElement()));
        nested.close();
        writer.end();
        writer.println();
        //
        cycle.removeAttribute(ATTRIBUTE_NAME);
    }

    public static IListTableColumn get(IRequestCycle cycle) {
        return (IListTableColumn) cycle.getAttribute(ATTRIBUTE_NAME);
    }

    public Object getValue(Object bean) {
        return owner.getValue();
    }

}