/*
 * joey-rt-test and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/15 1:55:22
 */
package org.asyrinx.joey.tapestry.components.entity.table.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;
import org.asyrinx.joey.tapestry.components.entity.EntityServiceStrategyImpl;
import org.asyrinx.joey.tapestry.components.entity.IEntityServiceComponent;
import org.asyrinx.joey.tapestry.components.entity.IEntityServiceStrategy;
import org.asyrinx.joey.tapestry.components.entity.table.IListTable;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableColumn;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableRowRepeatable;
import org.asyrinx.joey.tapestry.page.EntityPageDictionary;
import org.asyrinx.joey.tapestry.page.IEntityPagingComponent;
import org.asyrinx.joey.tapestry.page.IEntityPagingStrategy;
import org.asyrinx.joey.tapestry.page.impl.EntityPagingStrategyImpl;

/**
 * @author takeshi
 */
public abstract class ListTableRow extends AbstractListTableRow implements IEntityServiceComponent,
        IEntityPagingComponent, IListTableRowRepeatable {

    protected void finishLoad() {
        super.finishLoad();
        setCellElement("td");
    }

    public void renderCellContent(IMarkupWriter writer, IRequestCycle cycle) {
        final IListTableColumn columnDef = getColumn();
        final Object v = columnDef.getValue(getTarget());
        setValue(v);
        super.renderCellContent(writer, cycle);
    }

    protected void checkEntity() {
        setLinkProp(null);
        if (value == null)
            return;
        final IListTable table = getTable();
        final String pageName = table.getPageDictionary().getPageName(value.getClass());
        if (!StringUtils.isEmpty(pageName))
            setLinkProp(value);
    }

    private Object value = null;

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
        checkEntity();
    }

    private Object linkProp = null;

    public Object getLinkProp() {
        return linkProp;
    }

    public void setLinkProp(Object linkProp) {
        this.linkProp = linkProp;
    }

    private final IEntityPagingStrategy pagingStrategy = new EntityPagingStrategyImpl(this);

    public EntityPageDictionary getPageDictionary() {
        final EntityPageDictionary result = pagingStrategy.getPageDictionary();
        if (result != null)
            return result;
        final IListTable table = getTable();
        if (table == null)
            return null;
        setDetailPageDictionary(table.getPageDictionary());
        return getDetailPageDictionary();
    }

    protected IEntityServiceStrategy serviceStrategy = new EntityServiceStrategyImpl(this);

    public EntityServiceDispatcher getDispatcher() {
        final EntityServiceDispatcher result = serviceStrategy.getDispatcher();
        if (result != null)
            return result;
        final IListTable table = getTable();
        if (table == null)
            return null;
        setEntityServiceDispatcher(table.getDispatcher());
        return getEntityServiceDispatcher();
    }

}