/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/12
 */
package org.asyrinx.joey.user.impl;

import org.apache.commons.lang.exception.NestableRuntimeException;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.joey.user.ApplicationUser;
import org.asyrinx.joey.user.UserCertifier;

/**
 * @author akima
 */
public class SimpleLoginManager {

    /**
     *  
     */
    public SimpleLoginManager(UserCertifier certifier) {
        super();
        this.certifier = certifier;
    }

    /**
     *  
     */
    public SimpleLoginManager(String certifierClassName) {
        this(newCertifier(certifierClassName));
    }

    protected final UserCertifier certifier;

    private static UserCertifier newCertifier(String certifierClassName) {
        try {
            return (UserCertifier) ClassUtils.newObject(certifierClassName, UserCertifier.class);
        } catch (InstantiationException e) {
            throw new NestableRuntimeException(e);
        }
    }

    public ApplicationUser tryLogin(String userId, String password) {
        if (certifier == null)
            return null;
        return certifier.canLogin(userId, password);
    }

}