/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.om;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.om.ConditionTranslator;
import org.asyrinx.joey.om.SearchCondition;

public abstract class AbstractSearchCondition
implements SearchCondition {
    private int maxRecordCount = 10;
    private DateFormat dateFormat = new SimpleDateFormat();
    protected ConditionTranslator translater;
    public static final String EQUAL = "=";
    public static final String GREATER_EQUAL = ">=";
    public static final String GREATER = ">";
    public static final String LESS_EQUAL = "<=";
    public static final String LESS = "<";
    public static final String LIKE = "like";
    public static final String IN = "in";
    public static final String NOT_IN = "not in";

    protected abstract void prepare();

    public void attach(ConditionTranslator conditionTranslater) {
        this.translater = conditionTranslater;
        try {
            this.prepare();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.translater = null;
            throw throwable;
        }
        Object var2_4 = null;
        this.translater = null;
    }

    public int getMaxRecordCount() {
        return this.maxRecordCount;
    }

    public void setMaxRecordCount(int i) {
        this.maxRecordCount = i;
    }

    protected final void addFrom(String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return;
        }
        this.translater.addFrom(tableName);
    }

    private boolean isAvailableValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            return ((String)value).length() > 0;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        return true;
    }

    protected final void addInt(String fieldName, Object value, Object operator) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return;
        }
        if (!this.isAvailableValue(value)) {
            return;
        }
        this.translater.addInt(fieldName, value, operator);
    }

    protected final void addInt(String fieldName, String value) {
        this.addInt(fieldName, value, EQUAL);
    }

    protected final void addIntMin(String fieldName, String value) {
        this.addInt(fieldName, value, GREATER_EQUAL);
    }

    protected final void addIntMax(String fieldName, String value) {
        this.addInt(fieldName, value, LESS_EQUAL);
    }

    protected final void addLong(String fieldName, Object value, Object operator) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return;
        }
        if (!this.isAvailableValue(value)) {
            return;
        }
        this.translater.addLong(fieldName, value, operator);
    }

    protected final void addLong(String fieldName, String value) {
        this.addLong(fieldName, value, EQUAL);
    }

    protected final void addLongMin(String fieldName, String value) {
        this.addLong(fieldName, value, GREATER_EQUAL);
    }

    protected final void addLongMax(String fieldName, String value) {
        this.addLong(fieldName, value, LESS_EQUAL);
    }

    protected final void addDate(String fieldName, Object value, Object operator, DateFormat dateFormat) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return;
        }
        if (!this.isAvailableValue(value)) {
            return;
        }
        this.translater.addDate(fieldName, value, operator, dateFormat);
    }

    protected final void addDate(String fieldName, Object value, Object operator) {
        this.addDate(fieldName, value, operator, this.getDateFormat());
    }

    protected final void addDate(String fieldName, String value) {
        this.addDate(fieldName, value, EQUAL);
    }

    protected final void addDateMin(String fieldName, String value) {
        this.addDate(fieldName, value, GREATER_EQUAL);
    }

    protected final void addDateMax(String fieldName, String value) {
        this.addDate(fieldName, value, LESS_EQUAL);
    }

    protected final void addString(String fieldName, Object value, Object operator) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return;
        }
        if (!this.isAvailableValue(value)) {
            return;
        }
        this.translater.addString(fieldName, value, operator);
    }

    protected final void addString(String fieldName, String value) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return;
        }
        if (!this.isAvailableValue(value)) {
            return;
        }
        if (value.indexOf("*") > -1) {
            this.translater.addString(fieldName, value, LIKE);
        } else {
            this.translater.addString(fieldName, value, EQUAL);
        }
    }

    protected final void addAscendingOrderByColumn(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return;
        }
        this.translater.addAscendingOrderByColumn(fieldName);
    }

    protected final void addDescendingOrderByColumn(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return;
        }
        this.translater.addDescendingOrderByColumn(fieldName);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat format) {
        this.dateFormat = format;
    }

    public ConditionTranslator getTranslater() {
        return this.translater;
    }
}

