/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.om.hibernate;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.Session;
import net.sf.hibernate.exception.NestableRuntimeException;
import net.sf.hibernate.expression.Order;
import org.asyrinx.brownie.core.sql.Operator;
import org.asyrinx.joey.om.ConditionTranslator;
import org.asyrinx.joey.om.SearchCondition;
import org.asyrinx.joey.om.hibernate.AbstractHibernateTranslator;
import org.asyrinx.joey.om.hibernate.CriteriaUtils;

public class CriteriaTranslator
extends AbstractHibernateTranslator
implements ConditionTranslator {
    private final Session session;
    private final Class targetClass;
    private final Criteria criteria;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CriteriaTranslator(Map columnToProperty, Map tableToClass, Session session, Class targetClass) {
        super(columnToProperty, tableToClass);
        this.session = session;
        this.targetClass = targetClass;
        this.criteria = session.createCriteria(targetClass);
        this.setUsePropertyInCondition(true);
    }

    public void addFrom(String tableName) {
    }

    public void addInt(String fieldName, Object value, Object operator) {
        Object val;
        fieldName = this.toFieldName(fieldName);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((val = this.toNumber(value, clazz)) == null) {
            return;
        }
        this.criteria.add(CriteriaUtils.toExpression(Operator.get((Object)operator), fieldName, val));
    }

    public void addLong(String fieldName, Object value, Object operator) {
        Object val;
        fieldName = this.toFieldName(fieldName);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((val = this.toNumber(value, clazz)) == null) {
            return;
        }
        this.criteria.add(CriteriaUtils.toExpression(Operator.get((Object)operator), fieldName, val));
    }

    public void addDate(String fieldName, Object value, Object operator, DateFormat dateFormat) {
        fieldName = this.toFieldName(fieldName);
        try {
            Date d = value instanceof Date ? (Date)value : dateFormat.parse(String.valueOf(value));
            this.criteria.add(CriteriaUtils.toExpression(Operator.get((Object)operator), fieldName, d));
        }
        catch (ParseException e) {
            throw new NestableRuntimeException((Throwable)e);
        }
    }

    public void addString(String fieldName, Object value, Object operator) {
        fieldName = this.toFieldName(fieldName);
        this.criteria.add(CriteriaUtils.toExpression(Operator.get((Object)operator), fieldName, value));
    }

    public void addAscendingOrderByColumn(String fieldName) {
        fieldName = this.toFieldName(fieldName);
        this.criteria.addOrder(Order.asc((String)fieldName));
    }

    public void addDescendingOrderByColumn(String fieldName) {
        fieldName = this.toFieldName(fieldName);
        this.criteria.addOrder(Order.desc((String)fieldName));
    }

    public Criteria toCriteria(SearchCondition condition) {
        condition.attach(this);
        return this.criteria;
    }
}

