/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.tapestry.components.stative;

import java.io.Serializable;
import java.util.Stack;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.user.IUser;
import org.asyrinx.joey.om.SearchCondition;
import org.asyrinx.joey.tapestry.components.stative.BaseEditPage;
import org.asyrinx.joey.tapestry.components.stative.BaseListPage;

public class BaseVisit
implements Serializable {
    private IUser loginUser = null;
    private boolean requestDebug = false;
    private boolean disableInspector = false;
    private final Stack accessHistories = new Stack();

    public boolean isUserLogined() {
        return this.loginUser != null;
    }

    public String getLoginUserDisplayName() {
        return this.loginUser != null ? this.loginUser.getDisplayName() : "";
    }

    public void setRequestDebug(boolean value) {
        this.requestDebug = value;
    }

    public boolean getRequestDebug() {
        return this.requestDebug;
    }

    public boolean getDisableInspector() {
        return this.disableInspector;
    }

    public void setDisableInspector(boolean disableInspector) {
        this.disableInspector = disableInspector;
    }

    public void saveLastAccessPage(IPage page) {
        Object object;
        if (page == null) {
            return;
        }
        if (page instanceof BaseEditPage) {
            BaseEditPage editPage = (BaseEditPage)page;
            object = editPage.getEditObject();
        } else {
            BaseListPage listPage = (BaseListPage)page;
            object = listPage.getWayToSearch();
        }
        this.accessHistories.push(new AccessObject(page.getPageName(), object));
    }

    public void goBackToLastAccessPage(IRequestCycle cycle) {
        if (this.accessHistories.isEmpty()) {
            return;
        }
        AccessObject accessObject = (AccessObject)this.accessHistories.pop();
        IPage page = cycle.getPage(accessObject.pageName);
        if (page == null) {
            return;
        }
        if (page instanceof BaseEditPage) {
            BaseEditPage editPage = (BaseEditPage)page;
            editPage.setEditObject(accessObject.object);
        } else {
            BaseListPage listPage = (BaseListPage)page;
            if (accessObject.object instanceof SearchCondition) {
                listPage.setWayToSearch((SearchCondition)accessObject.object);
            }
            listPage.search(cycle);
        }
        cycle.activate(page);
    }

    public IUser getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(IUser user) {
        this.loginUser = user;
    }

    class AccessObject
    implements Serializable {
        final String pageName;
        final Object object;

        public AccessObject(String pageName, Object object) {
            this.pageName = pageName;
            this.object = object;
        }
    }
}

