/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JFrame;
import jongs.jongsButton;
import jongs.jongsImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jongsDisplay
extends JFrame {
    static final long serialVersionUID = 0x100001L;
    BufferedImage disp_buf00 = null;
    BufferedImage disp_buf01 = null;
    Font textFont;
    String fontName;
    int fontStyle;
    int fontSize;
    int fontCol1;
    int fontCol2;
    Color fontColor1;
    Color fontColor2;
    String text;
    int txX;
    int txY;
    int txW;
    int txH;
    jongsImage[] cellImages;
    boolean[] cellViews;
    boolean[] cellViewsWithMouse;
    int cellNum;
    boolean getEvent;
    char presskey;
    int clickx;
    int clicky;
    boolean mouseenter;
    int mouseX;
    int mouseY;
    jongsButton[] button;
    int buttonvalue;
    int buttonNum;
    int btX;
    int btY;
    int btW;
    int btH;
    int bc0;
    int bc1;
    int bc2;
    int bc3;

    public jongsDisplay() {
        this.initJongsDisplay(800, 600);
    }

    public jongsDisplay(int w, int h) {
        this.initJongsDisplay(w, h);
    }

    public void initJongsDisplay(int dispw, int disph) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                jongsDisplay.this.presskey = e.getKeyChar();
                jongsDisplay.this.getEvent = true;
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                jongsDisplay.this.mouseX = e.getX();
                jongsDisplay.this.mouseY = e.getY();
                if (jongsDisplay.this.buttonvalue < 0) {
                    jongsDisplay.this.buttonvalue = jongsDisplay.this.getClickedButton(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY);
                    if (jongsDisplay.this.buttonvalue > 0) {
                        jongsDisplay.this.drawImageBuf();
                    } else {
                        int n = 0;
                        while (n < jongsDisplay.this.button.length) {
                            jongsDisplay.this.button[n].pressed = false;
                            ++n;
                        }
                        jongsDisplay.this.repaint();
                    }
                } else {
                    jongsDisplay.this.getEvent = true;
                }
            }

            public void mousePressed(MouseEvent e) {
                jongsDisplay.this.mouseX = e.getX();
                jongsDisplay.this.mouseY = e.getY();
                if (jongsDisplay.this.buttonvalue < 0) {
                    int n = 0;
                    while (n < jongsDisplay.this.button.length) {
                        jongsDisplay.this.button[n].pressed = jongsDisplay.this.button[n].checkArea(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY);
                        ++n;
                    }
                    jongsDisplay.this.repaint();
                }
            }

            public void mouseExited(MouseEvent e) {
                jongsDisplay.this.mouseenter = false;
                jongsDisplay.this.repaint();
            }

            public void mouseEntered(MouseEvent e) {
                jongsDisplay.this.mouseenter = true;
                jongsDisplay.this.repaint();
            }
        });
        this.setBounds(dispw, disph);
        this.setTextFont("Selif", "plain", 14);
        this.setFontColor(0xFFFFFF, 0xAAAAAA);
        this.setCellNumber(3);
        this.text = "";
        this.setSelectArea(50, 400, 700, 40);
        this.setSelectColor(0xAAAAAA, 0xEEEEEE, 0xFFFFFF, 0);
    }

    public void setBounds(int w, int h) {
        this.setVisible(false);
        this.setBounds(0, 0, w, h);
        this.disp_buf00 = new BufferedImage(w, h, 4);
        this.disp_buf01 = new BufferedImage(w, h, 4);
        this.setVisible(true);
        this.setTextArea(10, 30, w - 20, h - 60);
    }

    public void setTextArea(int x, int y, int w, int h) {
        this.txX = x;
        this.txY = y;
        this.txW = w;
        this.txH = h;
    }

    public void setFontColor(int fc1, int fc2) {
        this.fontColor1 = new Color(fc1);
        this.fontColor2 = new Color(fc2);
        this.fontCol1 = fc1;
        this.fontCol2 = fc2;
    }

    public void setTextFont(String fn, int fst, int fsz) {
        this.textFont = new Font(fn, fst, fsz);
        this.fontName = fn;
        this.fontStyle = fst;
        this.fontSize = fsz;
    }

    public void setTextFont(String fn, String fst, int fsz) {
        int style = 0;
        style = fst.toLowerCase().equals("plain") ? 0 : (fst.toLowerCase().equals("bold") ? 1 : (fst.toLowerCase().equals("italic") ? 2 : 0));
        this.setTextFont(fn, style, fsz);
    }

    public void setCellNumber(int cn) {
        this.cellNum = cn;
        this.cellImages = new jongsImage[cn];
        this.cellViews = new boolean[cn];
        this.cellViewsWithMouse = new boolean[cn];
        int n = 0;
        while (n < cn) {
            this.cellViews[n] = false;
            this.cellViewsWithMouse[n] = false;
            ++n;
        }
    }

    public void setButtonArea(int xnum, int ynum, int xspan, int yspan) {
        int bnum = xnum * ynum;
        int bwid = (this.btW - xspan * (xnum - 1)) / xnum;
        int bhei = (this.btH - yspan * (ynum - 1)) / ynum;
        if (bwid < 0) {
            bwid = this.btW / xnum;
            xspan = 0;
        }
        if (bhei < 0) {
            bhei = this.btH / ynum;
            yspan = 0;
        }
        this.button = new jongsButton[bnum];
        Font fnt = new Font("selif", 1, 8);
        int bn = 0;
        int bpy = this.btY;
        int by = 0;
        while (by < ynum) {
            int bpx = this.btX;
            int bx = 0;
            while (bx < xnum) {
                this.button[bn] = new jongsButton(bpx, bpy, bwid, bhei, this.bc0, this.bc1, this.bc2, this.bc3);
                this.button[bn].setFont(fnt);
                ++bn;
                ++bx;
                bpx += bwid + xspan;
            }
            ++by;
            bpy += bhei + yspan;
        }
    }

    public void setButtonColor() {
        int n = 0;
        while (n < this.button.length) {
            this.button[n].setColor(this.bc0, this.bc1, this.bc2, this.bc3);
            ++n;
        }
    }

    public void setSelectColor(int c1, int c2, int c3, int c4) {
        this.bc0 = c1;
        this.bc1 = c2;
        this.bc2 = c3;
        this.bc3 = c4;
    }

    public void setSelectArea(int x, int y, int w, int h) {
        this.btX = x;
        this.btY = y;
        this.btW = w;
        this.btH = h;
    }

    public void setButtonParam(Vector<String> vct) {
        int n = vct.size();
        if (n < 5) {
            this.setButtonArea(vct.size(), 1, 20, 20);
        } else if (n % 5 == 0) {
            this.setButtonArea(5, n / 5, 20, 20);
        } else if (n % 4 == 0) {
            this.setButtonArea(4, n / 4, 20, 20);
        } else if (n % 3 == 0) {
            this.setButtonArea(3, n / 3, 20, 20);
        } else {
            this.setButtonArea(5, n / 5 + 1, 20, 20);
        }
        n = 0;
        while (n < vct.size() && n < this.button.length) {
            this.button[n].setTextValue(vct.get(n), n);
            ++n;
        }
        this.getEvent = false;
        this.buttonvalue = -1;
        this.buttonNum = n;
        this.repaint();
    }

    public void drawButton(Graphics2D g2d) {
        int n = 0;
        while (n < this.buttonNum) {
            if (this.buttonvalue == n) {
                this.button[n].drawPressButton(g2d);
            } else {
                this.button[n].drawButton(g2d);
            }
            ++n;
        }
    }

    public int getClickedButton(int zx, int zy) {
        int n = 0;
        while (n < this.button.length) {
            if (this.button[n].checkArea(zx, zy)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setCellView(String flagStr) {
        int n = 0;
        while (n < flagStr.length() && n < this.cellNum) {
            char c = flagStr.charAt(n);
            if (c == '0') {
                this.cellViews[n] = false;
            } else if (c == '1') {
                this.cellViews[n] = true;
            }
            ++n;
        }
    }

    public void setCellView(int flag) {
        int flagHex = flag;
        int n = 0;
        while (n < 32 && n < this.cellNum) {
            int c = flagHex & 1;
            if (c == 0) {
                this.cellViews[n] = false;
            } else if (c == 1) {
                this.cellViews[n] = true;
            }
            flagHex >>= 1;
            ++n;
        }
    }

    public void setCellView(int cell, int val) {
        if (cell < this.cellNum) {
            if (val == 0) {
                this.cellViews[cell] = false;
            } else if (val == 1) {
                this.cellViews[cell] = true;
            }
        }
    }

    public void setCellView(int cell, String val) {
        if (cell < this.cellNum) {
            if (val.trim().toLowerCase().equals("false")) {
                this.cellViews[cell] = false;
            } else if (val.trim().toLowerCase().equals("true")) {
                this.cellViews[cell] = true;
            }
        }
    }

    public void drawImageBuf() {
        Graphics dbg = this.disp_buf00.getGraphics();
        dbg.setColor(Color.black);
        dbg.fillRect(0, 0, this.disp_buf00.getWidth(), this.disp_buf00.getHeight());
        int n = 0;
        while (n < this.cellNum) {
            if (this.cellViews[n] && this.cellImages[n] != null) {
                jongsImage ji = this.cellImages[n];
                System.out.println("FILENAME:" + ji.filename + "(" + ji.pos.x + "," + ji.pos.y + ")");
                dbg.drawImage(ji.image, ji.pos.x, ji.pos.y, this);
            }
            ++n;
        }
    }

    @Override
    public void paint(Graphics grp) {
        Graphics2D g2d = (Graphics2D)grp;
        Graphics2D gb1 = (Graphics2D)this.disp_buf01.getGraphics();
        gb1.drawImage((Image)this.disp_buf00, 0, 0, this);
        if (this.buttonvalue < 0) {
            this.drawButton(gb1);
        }
        this.drawText(g2d);
        g2d.drawImage((Image)this.disp_buf01, 0, 0, this);
    }

    public void setText(String txt) {
        this.text = txt;
    }

    public void drawText(Graphics2D bg) {
        if (this.text.length() != 0) {
            this.textWrite(bg, this.textFont, this.text, this.txX, this.txY, this.txW, this.txH, this.fontColor1, this.fontColor2);
        }
    }

    public void textWrite(Graphics2D vg, Font f, String str, int sx, int sy, int sw, int sh, Color c1, Color c2) {
        int yz;
        Graphics2D sg = (Graphics2D)this.disp_buf01.getGraphics();
        String S = String.valueOf(str) + " ";
        sg.setFont(f);
        FontMetrics slffm = sg.getFontMetrics(f);
        int fhei = slffm.getHeight();
        sg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int c = 1;
        int e = 0;
        int b = 0;
        while (e < S.length()) {
            if (slffm.stringWidth(S.substring(b, e + 1)) > sw || S.charAt(e) == '\\' && S.charAt(e + 1) == 'n') {
                yz = c * fhei;
                sg.setColor(c2);
                sg.drawString(S.substring(b, e), sx - 1, sy + yz - 1);
                sg.drawString(S.substring(b, e), sx + 1, sy + yz + 1);
                sg.drawString(S.substring(b, e), sx - 1, sy + yz + 1);
                sg.drawString(S.substring(b, e), sx + 1, sy + yz - 1);
                sg.setColor(c1);
                sg.drawString(S.substring(b, e), sx, sy + yz);
                if (S.charAt(e) == '\\' && S.charAt(e + 1) == 'n') {
                    e = b = e + 2;
                } else {
                    b = e;
                }
                ++c;
            }
            ++e;
        }
        yz = c * fhei;
        sg.setColor(c2);
        sg.drawString(S.substring(b), sx - 1, sy + yz - 1);
        sg.drawString(S.substring(b), sx + 1, sy + yz + 1);
        sg.drawString(S.substring(b), sx - 1, sy + yz + 1);
        sg.drawString(S.substring(b), sx + 1, sy + yz - 1);
        sg.setColor(c1);
        sg.drawString(S.substring(b), sx, sy + yz);
        vg.drawImage((Image)this.disp_buf01, 0, 0, this);
    }

    public boolean setCellImage(int cell, String filename) {
        if (this.cellImages[cell] == null) {
            this.cellImages[cell] = new jongsImage();
            this.cellImages[cell].setPoint(0, 0);
        }
        boolean ret = this.cellImages[cell].readImage(filename, this);
        return ret;
    }

    public void setTransColor(int cell, int tc) {
        if (this.cellImages[cell] != null) {
            this.cellImages[cell].setTransColor(tc);
        }
    }

    public void setTransColor(int cell, int col, int alpha) {
        if (this.cellImages[cell] != null) {
            int tc = alpha << 24 | col & 0xFFFFFF;
            this.cellImages[cell].setTransColor(tc);
        }
    }

    public void setTransColor(int cell, int x, int y, int alpha) {
        if (this.cellImages[cell] != null) {
            this.cellImages[cell].setTransColor(x, y, alpha);
        }
    }

    public void setCellPosition(int cell, int x, int y) {
        if (this.cellImages[cell] != null) {
            this.cellImages[cell].pos.x = x;
            this.cellImages[cell].pos.y = y;
        }
    }
}

