/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jongsImage {
    Vector<int[]> transColors;
    Point pos;
    String filename;
    BufferedImage image;

    public jongsImage() {
        this.resetTransColor();
        this.pos = new Point();
    }

    public void setImage(BufferedImage img, ImageObserver io) {
        this.image = new BufferedImage(img.getWidth(), img.getHeight(), 6);
        Graphics g = this.image.getGraphics();
        g.drawImage(img, 0, 0, io);
    }

    public void setFileName(String fname) {
        this.filename = fname;
    }

    public void setPoint(int x, int y) {
        this.pos.x = x;
        this.pos.y = y;
    }

    public void setTransColor(int tc) {
        if (this.image.getColorModel().getTransparency() == 3) {
            int[] col = new int[]{tc};
            this.transColors.add(col);
            this.setTransImage(tc);
        }
    }

    public void setTransColor(int x, int y, int alpha) {
        int tc = this.image.getRGB(x, y) & 0xFFFFFF;
        this.setTransColor(tc |= alpha << 24);
    }

    public void setTransColor(int color, int alpha) {
        int tc = color & 0xFFFFFF;
        this.setTransColor(tc |= alpha << 24);
    }

    public void setTransColors(Vector<int[]> tcs) {
        int n = 0;
        while (n < tcs.size()) {
            this.transColors.add(tcs.get(n));
            int tc = tcs.get(n)[0];
            this.setTransImage(tc);
            ++n;
        }
    }

    public void resetTransColor() {
        this.transColors = new Vector();
    }

    public void setTransImage(int tc) {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        int color = tc & 0xFFFFFF;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int col0 = this.image.getRGB(x, y) & 0xFFFFFF;
                if (col0 == color) {
                    this.image.setRGB(x, y, tc);
                }
                ++x;
            }
            ++y;
        }
    }

    public boolean readImage(String filename, ImageObserver iob) {
        try {
            BufferedImage bimg = ImageIO.read(new File("./" + filename));
            this.setImage(bimg, iob);
            this.setFileName(filename);
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }
}

