/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import jp.co.nissy.jpicosheet.core.Calculator;
import jp.co.nissy.jpicosheet.core.PicosheetException;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Resolver;
import jp.co.nissy.jpicosheet.core.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Book {
    private String _name;
    private Calculator _calculator;
    private Resolver _resolver;
    private HashMap<String, Sheet> _sheets = new HashMap();
    static final String BOOK_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static Pattern _bookNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");

    private Book() {
    }

    public Book(String bookName) throws IllegalArgumentException {
        this.validateBookName(bookName);
        this._name = bookName;
        this._calculator = new Calculator(this);
        this._resolver = new Resolver(this);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String bookName) throws IllegalArgumentException {
        this.validateBookName(bookName);
        this._name = bookName;
    }

    Calculator getCalculator() {
        return this._calculator;
    }

    public Resolver getResolver() {
        return this._resolver;
    }

    public Sheet addSheet(String sheetName) {
        if (this._sheets.containsKey(sheetName)) {
            return this._sheets.get(sheetName);
        }
        Sheet sheet = new Sheet(sheetName, this);
        this._sheets.put(sheetName, sheet);
        if (this._resolver.getDefaultSheet() == null) {
            this._resolver.setDefaultSheet(sheet);
        }
        return sheet;
    }

    public List<Sheet> getSheets() {
        return new ArrayList<Sheet>(this._sheets.values());
    }

    public void renameSheet(String sheetName, String newSheetName) throws PicosheetException {
        if (this._sheets.containsKey(sheetName)) {
            Sheet sheet = this._sheets.get(sheetName);
            sheet.setName(newSheetName);
            this._sheets.put(newSheetName, this._sheets.get(sheetName));
            this._sheets.remove(sheetName);
        }
    }

    public void deleteSheet(String sheetName) throws ReferenceNotFoundException {
        if (!this._sheets.containsKey(sheetName)) {
            throw new ReferenceNotFoundException("no such sheet " + sheetName);
        }
        this._sheets.remove(sheetName);
    }

    public Sheet sheet(String sheetName) throws ReferenceNotFoundException {
        if (this._sheets.containsKey(sheetName)) {
            return this._sheets.get(sheetName);
        }
        throw new ReferenceNotFoundException("no such sheet " + sheetName);
    }

    public void recalcEnable() throws Exception {
        this._calculator.recalcEnable();
    }

    public void recalcDisable() {
        this._calculator.recalcDisable();
    }

    private void validateBookName(String bookName) throws IllegalArgumentException {
        if (!_bookNamePattern.matcher(bookName).matches()) {
            throw new IllegalArgumentException("invalid book name \"" + bookName + "\"");
        }
    }
}

