/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.Element;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Resolver;
import jp.co.nissy.jpicosheet.core.Sheet;
import jp.co.nissy.jpicosheet.function.Function;
import jp.co.nissy.jpicosheet.function.Sum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Calculator {
    private Book book;
    private boolean recalcEnabled;
    private final Logger logger = Logger.getLogger("jp.co.nissy.jpicosheet");

    public Calculator(Book book) {
        this.book = book;
        this.recalcEnabled = true;
    }

    void calc(String cellname) throws ReferenceNotFoundException {
        this.calc(this.book.getResolver().getCell(cellname));
    }

    void calc(Cell cell) {
        if (this.recalcEnabled) {
            this.doCalc(cell);
            this.recalcReferencingCells(cell);
        }
    }

    void calc(Set<Cell> cells) {
        for (Cell cell : cells) {
            this.calc(cell);
        }
    }

    void recalcEnable() {
        this.recalcEnabled = true;
        ArrayList<Cell> recalcCells = new ArrayList<Cell>();
        for (Sheet sheet : this.book.getSheets()) {
            for (Cell cell : sheet.getCells()) {
                if (!cell.getCellType().equals((Object)Cell.CellType.FORMULA)) continue;
                cell.setStatus(Cell.CellStatus.REQUIRE_CALCULATION);
                recalcCells.add(cell);
            }
        }
        for (Cell cell : recalcCells) {
            this.doCalc(cell);
        }
    }

    void recalcDisable() {
        this.recalcEnabled = false;
    }

    void recalcReferencingCells(Cell cell) {
        Resolver resolver = this.book.getResolver();
        Set<Cell> recalcCells = resolver.getReferencingCells(cell);
        this.recalcReferencingCells(recalcCells);
    }

    void recalcReferencingCells(Collection<Cell> recalcCells) {
        for (Cell refCell : recalcCells) {
            refCell.setStatus(Cell.CellStatus.REQUIRE_CALCULATION);
        }
        for (Cell refCell : recalcCells) {
            this.doCalc(refCell);
        }
    }

    private void doCalc(Cell cell) {
        if (cell.getCellType() != Cell.CellType.FORMULA) {
            return;
        }
        if (cell.getStatus() != Cell.CellStatus.REQUIRE_CALCULATION) {
            return;
        }
        cell.setStatus(Cell.CellStatus.UNDER_CALCULATION);
        MathContext mc = cell.getSheet().getMathContext();
        Stack<Element> calcStack = new Stack<Element>();
        int i = 0;
        while (i < cell.getFormulaRPN().length) {
            Element token = cell.getFormulaRPN()[i];
            switch (token.getType()) {
                case NUMBER: {
                    calcStack.push(token);
                    break;
                }
                case STRING: {
                    calcStack.push(token);
                    break;
                }
                case REFERENCE: {
                    Element refCelValue = this.getReferencesCellValue(token);
                    if (refCelValue.getType() != Element.ElementType.ERROR) {
                        calcStack.push(refCelValue);
                        break;
                    }
                    cell.setValue(refCelValue);
                    cell.setStatus(Cell.CellStatus.ERROR);
                    return;
                }
                case GROUP_REFERENCE: {
                    Collection<Cell> cells;
                    try {
                        cells = this.book.getResolver().getCellsFromGroup(token.getGroupReference());
                        this.recalcIfRequired(cells);
                        calcStack.push(token);
                        break;
                    }
                    catch (ReferenceNotFoundException e) {
                        cell.setValue(new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_REFERENCES));
                        cell.setStatus(Cell.CellStatus.ERROR);
                        return;
                    }
                }
                case TABLE_REFERENCE: {
                    Collection<Cell> cells;
                    try {
                        cells = this.book.getResolver().getCellsFromTable(token.getTableReference());
                        this.recalcIfRequired(cells);
                        calcStack.push(token);
                        break;
                    }
                    catch (ReferenceNotFoundException e) {
                        cell.setValue(new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_REFERENCES));
                        cell.setStatus(Cell.CellStatus.ERROR);
                        return;
                    }
                }
                case OPERATOR: {
                    this.operate(calcStack, token, mc, cell.getSheet().getBook().getResolver());
                }
            }
            ++i;
        }
        assert (calcStack.size() == 1) : "\u8a08\u7b97\u7d42\u4e86\u6642\u70b9\u3067\u8a08\u7b97\u30b9\u30bf\u30c3\u30af\u4e2d\u306eElement\u6570\u304c1\u3067\u306a\u3051\u308c\u3070\u306a\u3089\u306a\u3044";
        cell.setValue((Element)calcStack.pop());
        cell.setStatus(Cell.CellStatus.CALCULATED);
    }

    private Element getReferencesCellValue(Element referenceElement) {
        Cell referCell = this.getReferencesCell(referenceElement);
        if (referCell == null) {
            return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_REFERENCES);
        }
        this.recalcIfRequired(referCell);
        return referCell.getValue();
    }

    private Cell getReferencesCell(Element referenceElement) {
        Cell referCell;
        try {
            referCell = this.book.getResolver().getCell(referenceElement.getCellReference());
        }
        catch (ReferenceNotFoundException e) {
            return null;
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        return referCell;
    }

    private void recalcIfRequired(Collection<Cell> cells) {
        for (Cell cell : cells) {
            this.recalcIfRequired(cell);
        }
    }

    private void recalcIfRequired(Cell cell) {
        if (cell.getStatus() == Cell.CellStatus.UNDER_CALCULATION) {
            cell.setValue(new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.CIRCULER_REFERENCE));
            cell.setStatus(Cell.CellStatus.ERROR);
        }
        if (cell.getStatus() == Cell.CellStatus.REQUIRE_CALCULATION) {
            this.doCalc(cell);
        }
    }

    private boolean operate(Stack<Element> calcStack, Element operatorElem, MathContext mc, Resolver resolver) {
        switch (operatorElem.getOperator()) {
            case PLUS: {
                BigDecimal rValue = calcStack.pop().getNumber();
                BigDecimal lValue = calcStack.pop().getNumber();
                BigDecimal resultValue = lValue.add(rValue, mc);
                calcStack.push(new Element(Element.ElementType.NUMBER, resultValue));
                break;
            }
            case MINUS: {
                BigDecimal rValue = calcStack.pop().getNumber();
                BigDecimal lValue = calcStack.pop().getNumber();
                BigDecimal resultValue = lValue.subtract(rValue, mc);
                calcStack.push(new Element(Element.ElementType.NUMBER, resultValue));
                break;
            }
            case TIMES: {
                BigDecimal rValue = calcStack.pop().getNumber();
                BigDecimal lValue = calcStack.pop().getNumber();
                BigDecimal resultValue = lValue.multiply(rValue, mc);
                calcStack.push(new Element(Element.ElementType.NUMBER, resultValue));
                break;
            }
            case DIVIDE: {
                BigDecimal rValue = calcStack.pop().getNumber();
                BigDecimal lValue = calcStack.pop().getNumber();
                if (rValue.signum() == 0) {
                    calcStack.push(new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.DIVIDE_BY_ZERO));
                    break;
                }
                BigDecimal resultValue = lValue.divide(rValue, mc);
                calcStack.push(new Element(Element.ElementType.NUMBER, resultValue));
                break;
            }
            case UNARY_PLUS: {
                break;
            }
            case UNARY_MINUS: {
                BigDecimal rValue = calcStack.pop().getNumber();
                BigDecimal resultValue = rValue.negate();
                calcStack.push(new Element(Element.ElementType.NUMBER, resultValue));
                break;
            }
            case FUNCTION: {
                Element topElem;
                int argCount = 0;
                while (calcStack.size() > 0 && (topElem = calcStack.peek()).getType() == Element.ElementType.OPERATOR && topElem.getOperator() == Element.Operator.COMMA) {
                    ++argCount;
                    calcStack.pop();
                }
                Element[] args = new Element[argCount];
                int i = argCount - 1;
                while (i >= 0) {
                    args[i] = calcStack.pop();
                    --i;
                }
                Sum func = new Sum();
                calcStack.push(((Function)func).call(args, mc, resolver));
                break;
            }
            case COMMA: {
                calcStack.push(operatorElem);
            }
        }
        return true;
    }
}

