/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.core;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.nissy.jpicosheet.core.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FormulaParser {
    private static final String SHEETCELL_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*";
    private static final String SHEETGROUP_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*@";
    private static final String SHEETTABLE_NAME_WITH_ADDRESS_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#(R[0-9]+C[0-9]+)";
    private static final String SHEETTABLE_NAME_WITH_RANGE_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#(?:R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+)";
    private static final String SHEETTABLE_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#";
    private static final String SPACE_PATTERN = "\\s+";
    private static final String NUMERIC_PATTERN = "(([0-9]+\\.[0-9]*)|(\\.[0-9]+)|([0-9]+))";
    private static final String STRING_PATTERN = "\"[^\"]*\"";
    private static final String FUNCTION_NAME_PATTERN = "[a-zA-Z][a-zA-Z0-9_]*\\(";
    private static Pattern _tokens = Pattern.compile("\\s+|(([0-9]+\\.[0-9]*)|(\\.[0-9]+)|([0-9]+))|\"[^\"]*\"|\\+|-|\\*|/|\\(|\\)|[a-zA-Z][a-zA-Z0-9_]*\\(|,|[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*@|[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*|[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#(?:R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+)|[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#(R[0-9]+C[0-9]+)|[a-zA-Z_][a-zA-Z0-9_]*@|[a-zA-Z_][a-zA-Z0-9_]*#(?:R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+)|[a-zA-Z_][a-zA-Z0-9_]*#(R[0-9]+C[0-9]+)|[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#|[a-zA-Z_][a-zA-Z0-9_]*#|[a-zA-Z_][a-zA-Z0-9_]*");
    private static Pattern _cellRefPattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#(R[0-9]+C[0-9]+)|[a-zA-Z_][a-zA-Z0-9_]*#(R[0-9]+C[0-9]+)|[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*|[a-zA-Z_][a-zA-Z0-9_]*");
    private static Pattern _groupRefPattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*@|[a-zA-Z_][a-zA-Z0-9_]*@");
    private static Pattern _tableRefPattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*#|[a-zA-Z_][a-zA-Z0-9_]*#|[a-zA-Z_][a-zA-Z0-9_]*#(?:R[0-9]+C[0-9]+:R[0-9]+C[0-9]+|R[0-9]+C[0-9]+:R[0-9]+Cx|R[0-9]+C[0-9]+:RxC[0-9]+|R[0-9]+C[0-9]+:RxCx|R[0-9]+Cx|RxC[0-9]+)");
    private static Pattern _spacePattern = Pattern.compile("\\s+");
    private static Pattern _numericPattern = Pattern.compile("(([0-9]+\\.[0-9]*)|(\\.[0-9]+)|([0-9]+))");
    private static Pattern _stringPattern = Pattern.compile("\"[^\"]*\"");
    private static Pattern _functionPattern = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*\\(");

    FormulaParser() {
    }

    static Element[] split(String calcString, MathContext mc) {
        ArrayList<Element> list = new ArrayList<Element>();
        Matcher match = _tokens.matcher(calcString);
        int nextStartIndex = 0;
        boolean containsFunction = false;
        while (match.find()) {
            if (nextStartIndex != match.start()) {
                list.clear();
                containsFunction = false;
                list.add(new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA));
                break;
            }
            String chunkStr = match.group();
            if (chunkStr.length() == 0) continue;
            if (chunkStr.equals("+") || chunkStr.equals("-")) {
                boolean isUnary = false;
                if (list.size() == 0) {
                    isUnary = true;
                } else if (((Element)list.get(list.size() - 1)).getType() == Element.ElementType.OPERATOR) {
                    switch (((Element)list.get(list.size() - 1)).getOperator()) {
                        case FUNCTION: 
                        case LEFT_PARENTHESIS: 
                        case PLUS: 
                        case MINUS: 
                        case TIMES: 
                        case DIVIDE: 
                        case UNARY_PLUS: 
                        case UNARY_MINUS: {
                            isUnary = true;
                            break;
                        }
                        default: {
                            isUnary = false;
                            break;
                        }
                    }
                } else {
                    isUnary = false;
                }
                if (isUnary) {
                    if (chunkStr.equals("+")) {
                        list.add(new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.UNARY_PLUS));
                    } else {
                        list.add(new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.UNARY_MINUS));
                    }
                } else if (chunkStr.equals("+")) {
                    list.add(new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.PLUS));
                } else {
                    list.add(new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.MINUS));
                }
            } else if (chunkStr.equals("*")) {
                list.add(new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.TIMES));
            } else if (chunkStr.equals("/")) {
                list.add(new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.DIVIDE));
            } else if (_cellRefPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.REFERENCE, chunkStr));
            } else if (_groupRefPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.GROUP_REFERENCE, chunkStr));
            } else if (_tableRefPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.TABLE_REFERENCE, chunkStr));
            } else if (chunkStr.equals("(")) {
                list.add(new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.LEFT_PARENTHESIS));
            } else if (_functionPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.FUNCTION));
                containsFunction = true;
            } else if (chunkStr.equals(")")) {
                list.add(new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.RIGHT_PARENTHESIS));
            } else if (chunkStr.equals(",")) {
                list.add(new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.COMMA));
            } else if (_numericPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.NUMBER, new BigDecimal(chunkStr, mc)));
            } else if (_stringPattern.matcher(chunkStr).matches()) {
                list.add(new Element(Element.ElementType.STRING, chunkStr));
            } else if (!_spacePattern.matcher(chunkStr).matches()) assert (false) : "unknown operator " + chunkStr;
            nextStartIndex = match.end();
        }
        if (containsFunction && list.size() > 1) {
            int i = list.size() - 1;
            while (i >= 0) {
                Element rightElem;
                Element elem = (Element)list.get(i);
                if (elem.getType() == Element.ElementType.OPERATOR && elem.getOperator() == Element.Operator.FUNCTION && i < list.size() - 1 && ((rightElem = (Element)list.get(i + 1)).getType() != Element.ElementType.OPERATOR || rightElem.getOperator() != Element.Operator.RIGHT_PARENTHESIS)) {
                    list.add(i + 1, new Element(Element.ElementType.OPERATOR, (Object)Element.Operator.COMMA));
                }
                --i;
            }
        }
        Element[] retStrArray = new Element[list.size()];
        retStrArray = list.toArray(retStrArray);
        return retStrArray;
    }

    static Element checkInfixNotation(Element[] infixElem) {
        IndexInfo indexInfo = new IndexInfo(0, infixElem.length);
        return FormulaParser.checkInfixNotation_doCheck(infixElem, indexInfo, null);
    }

    private static Element checkInfixNotation_doCheck(Element[] infixElem, IndexInfo indexInfo, Element.Operator opType) {
        int i = indexInfo.startIndex;
        while (i <= infixElem.length - 1) {
            Element checkElem = infixElem[i];
            Element beforeElem = FormulaParser.getBeforeElem(infixElem, i);
            Element afterElem = FormulaParser.getAfterElem(infixElem, i);
            block0 : switch (checkElem.getType()) {
                case NUMBER: 
                case STRING: 
                case DATE: 
                case REFERENCE: {
                    if (!(beforeElem != null && beforeElem.getType() != Element.ElementType.OPERATOR || afterElem != null && afterElem.getType() != Element.ElementType.OPERATOR)) break;
                    return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA);
                }
                case GROUP_REFERENCE: 
                case TABLE_REFERENCE: {
                    if (opType == Element.Operator.FUNCTION && (beforeElem == null || beforeElem.getType() == Element.ElementType.OPERATOR && beforeElem.getOperator() == Element.Operator.COMMA || afterElem == null || afterElem.getType() == Element.ElementType.OPERATOR && afterElem.getOperator() == Element.Operator.COMMA)) break;
                    return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA);
                }
                case OPERATOR: {
                    switch (checkElem.getOperator()) {
                        case UNARY_PLUS: 
                        case UNARY_MINUS: {
                            if (afterElem == null) {
                                return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA);
                            }
                            if (afterElem.getType() == Element.ElementType.NUMBER || afterElem.getType() == Element.ElementType.REFERENCE || afterElem.getType() == Element.ElementType.OPERATOR && afterElem.getOperator() == Element.Operator.UNARY_PLUS || afterElem.getOperator() == Element.Operator.UNARY_MINUS || afterElem.getOperator() == Element.Operator.FUNCTION || afterElem.getOperator() == Element.Operator.LEFT_PARENTHESIS) break block0;
                            return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA);
                        }
                        case PLUS: 
                        case MINUS: 
                        case TIMES: 
                        case DIVIDE: {
                            if (beforeElem == null || afterElem == null) {
                                return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA);
                            }
                            if ((beforeElem.getType() == Element.ElementType.NUMBER || beforeElem.getType() == Element.ElementType.REFERENCE || beforeElem.getType() == Element.ElementType.OPERATOR && beforeElem.getOperator() == Element.Operator.FUNCTION || beforeElem.getType() == Element.ElementType.OPERATOR && beforeElem.getOperator() == Element.Operator.RIGHT_PARENTHESIS) && afterElem.getType() == Element.ElementType.NUMBER || afterElem.getType() == Element.ElementType.REFERENCE || afterElem.getType() == Element.ElementType.OPERATOR && afterElem.getOperator() == Element.Operator.FUNCTION || afterElem.getType() == Element.ElementType.OPERATOR && afterElem.getOperator() == Element.Operator.LEFT_PARENTHESIS || afterElem.getType() == Element.ElementType.OPERATOR && afterElem.getOperator() == Element.Operator.UNARY_PLUS || afterElem.getType() == Element.ElementType.OPERATOR && afterElem.getOperator() == Element.Operator.UNARY_MINUS) break block0;
                            return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA);
                        }
                        case FUNCTION: 
                        case LEFT_PARENTHESIS: {
                            indexInfo.startIndex = i + 1;
                            Element elem = FormulaParser.checkInfixNotation_doCheck(infixElem, indexInfo, checkElem.getOperator());
                            if (elem == null) {
                                indexInfo.startIndex = indexInfo.endIndex;
                                i = indexInfo.endIndex;
                                break block0;
                            }
                            return elem;
                        }
                        case COMMA: {
                            if (opType == Element.Operator.FUNCTION) break block0;
                            return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA);
                        }
                        case RIGHT_PARENTHESIS: {
                            if (opType == Element.Operator.FUNCTION || opType == Element.Operator.LEFT_PARENTHESIS) {
                                indexInfo.endIndex = i;
                                return null;
                            }
                            return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA);
                        }
                        default: {
                            assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30aa\u30da\u30ec\u30fc\u30bf" + checkElem.getOperator().toString();
                            break block0;
                        }
                    }
                }
                default: {
                    assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30bf\u30a4\u30d7" + checkElem.getType().toString();
                    break;
                }
            }
            ++i;
        }
        if (opType == null) {
            return null;
        }
        return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA);
    }

    private static Element getBeforeElem(Element[] infixElem, int index) {
        if (index < 1) {
            return null;
        }
        return infixElem[index - 1];
    }

    private static Element getAfterElem(Element[] infixElem, int index) {
        if (infixElem.length - 1 <= index) {
            return null;
        }
        return infixElem[index + 1];
    }

    static Element[] infixToRPN(Element[] parsedTokens, MathContext mc) {
        ArrayList<Element> result = new ArrayList<Element>();
        Stack<Element> stack = new Stack<Element>();
        int i = 0;
        while (i < parsedTokens.length) {
            Element token = parsedTokens[i];
            switch (token.getType()) {
                case NUMBER: 
                case STRING: 
                case REFERENCE: 
                case GROUP_REFERENCE: 
                case TABLE_REFERENCE: {
                    result.add(token);
                    break;
                }
                case OPERATOR: {
                    FormulaParser.processOperator(token, stack, result);
                    break;
                }
                default: {
                    assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30c8\u30fc\u30af\u30f3\u306e\u30bf\u30a4\u30d7\u304c\u3042\u3063\u3066\u306f\u306a\u3089\u306a\u3044";
                    break;
                }
            }
            ++i;
        }
        while (!stack.empty()) {
            result.add((Element)stack.pop());
        }
        Element[] retStrArray = new Element[result.size()];
        retStrArray = result.toArray(retStrArray);
        return retStrArray;
    }

    private static void processOperator(Element token, Stack<Element> stack, List<Element> result) {
        block0 : switch (token.getOperator()) {
            case FUNCTION: 
            case LEFT_PARENTHESIS: {
                stack.add(token);
                break;
            }
            case RIGHT_PARENTHESIS: {
                FormulaParser.processRightparenthesis(stack, result);
                break;
            }
            case COMMA: {
                FormulaParser.processComma(token, stack, result);
                break;
            }
            default: {
                if (stack.empty()) {
                    stack.push(token);
                    break;
                }
                Element.Operator tokenOp = token.getOperator();
                switch (tokenOp) {
                    case PLUS: 
                    case MINUS: 
                    case TIMES: 
                    case DIVIDE: {
                        Element.Operator peekedOp = stack.peek().getOperator();
                        if (peekedOp == Element.Operator.UNARY_PLUS || peekedOp == Element.Operator.UNARY_MINUS) {
                            while (!(stack.empty() || peekedOp != Element.Operator.UNARY_PLUS && peekedOp != Element.Operator.UNARY_MINUS)) {
                                result.add(stack.pop());
                            }
                        }
                        if (!stack.empty() && peekedOp.evalPriority(tokenOp) >= 0) {
                            result.add(stack.pop());
                            stack.push(token);
                            break block0;
                        }
                        stack.push(token);
                        break block0;
                    }
                }
                stack.push(token);
            }
        }
    }

    private static void processRightparenthesis(Stack<Element> stack, List<Element> result) {
        while (true) {
            if (stack.size() == 0) assert (false) : "invalid parenthesis.";
            Element poppedElem = stack.pop();
            if (poppedElem.getOperator() == Element.Operator.LEFT_PARENTHESIS) break;
            if (poppedElem.getOperator() == Element.Operator.FUNCTION) {
                result.add(poppedElem);
                break;
            }
            result.add(poppedElem);
        }
    }

    private static void processComma(Element token, Stack<Element> stack, List<Element> result) {
        while (true) {
            if (stack.empty()) assert (false) : "invalid COMMA.";
            Element peekedElem = stack.peek();
            if (peekedElem.getOperator() == Element.Operator.COMMA || peekedElem.getOperator() == Element.Operator.FUNCTION) break;
            result.add(stack.pop());
        }
        stack.push(token);
    }

    private static class IndexInfo {
        int startIndex = 0;
        int endIndex = 0;

        IndexInfo(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }
}

