/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.Element;
import jp.co.nissy.jpicosheet.core.ReferenceNotFoundException;
import jp.co.nissy.jpicosheet.core.Resolver;
import jp.co.nissy.jpicosheet.function.Function;

public class Sum
extends Function {
    public Element call(Element[] elements, MathContext mc, Resolver resolver) {
        BigDecimal result = BigDecimal.ZERO;
        Element[] elementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Element elem = elementArray[n2];
            try {
                switch (elem.getType()) {
                    case NUMBER: {
                        result = result.add(elem.getNumber(), mc);
                        break;
                    }
                    case GROUP_REFERENCE: 
                    case TABLE_REFERENCE: {
                        Collection<Cell> collection = null;
                        if (elem.getType() == Element.ElementType.GROUP_REFERENCE) {
                            collection = resolver.getCellsFromGroup(elem.getGroupReference());
                        } else if (elem.getType() == Element.ElementType.TABLE_REFERENCE) {
                            collection = resolver.getCellsFromTable(elem.getTableReference());
                        }
                        for (Cell cell : collection) {
                            result = result.add(cell.getValue().getNumber());
                        }
                    }
                }
            }
            catch (ReferenceNotFoundException e) {
                return new Element(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_REFERENCES);
            }
            ++n2;
        }
        return new Element(Element.ElementType.NUMBER, result);
    }
}

