/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.application;

import java.awt.SplashScreen;
import java.lang.reflect.Constructor;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import net.osdn.util.javafx.event.SilentCallable;
import net.osdn.util.javafx.event.SilentCallback;
import net.osdn.util.javafx.event.SilentChangeListener;
import net.osdn.util.javafx.event.SilentChangeListenerNewValueOnly;
import net.osdn.util.javafx.event.SilentChangeListenerWithoutObservable;
import net.osdn.util.javafx.event.SilentEventHandler;
import net.osdn.util.javafx.event.SilentInvalidationListener;
import net.osdn.util.javafx.event.SilentRunnable;

public abstract class SingletonApplication
extends Application {
    private static Class<? extends Application> appClass;
    private static AtomicInteger count;
    private static CountDownLatch latch;
    private static Stage primaryStage;
    private static boolean isAutoCloseSplashScreen;

    public static void launch(Class<? extends Application> appClass, String ... args) {
        SingletonApplication.appClass = appClass;
        try {
            if (primaryStage == null) {
                if (count.getAndIncrement() == 0) {
                    Application.launch(Interceptor.class, (String[])args);
                    return;
                }
                latch.await();
            }
            Platform.runLater(() -> {
                if (primaryStage.isIconified()) {
                    primaryStage.setIconified(false);
                }
                primaryStage.toFront();
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void launch(String ... args) {
        if (appClass != null) {
            SingletonApplication.launch(appClass, args);
            return;
        }
        try {
            String callingClassName = SingletonApplication.findCallingClassName();
            Class<?> theClass = Class.forName(callingClassName, false, Thread.currentThread().getContextClassLoader());
            if (!Application.class.isAssignableFrom(theClass)) {
                throw new RuntimeException("Error: " + theClass + " is not a subclass of javafx.application.Application");
            }
            Class<?> appClass = theClass;
            SingletonApplication.launch(appClass, args);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static String findCallingClassName() throws ClassNotFoundException {
        StackTraceElement[] cause = Thread.currentThread().getStackTrace();
        boolean foundThisMethod = false;
        String callingClassName = null;
        for (StackTraceElement se : cause) {
            String className = se.getClassName();
            String methodName = se.getMethodName();
            if (foundThisMethod) {
                callingClassName = className;
                break;
            }
            if (!"launch".equals(methodName) || !Application.class.isAssignableFrom(Class.forName(className))) continue;
            foundThisMethod = true;
        }
        if (callingClassName == null) {
            throw new RuntimeException("Error: unable to determine Application class");
        }
        return callingClassName;
    }

    public static void setAutoCloseSplashScreen(boolean b) {
        isAutoCloseSplashScreen = b;
    }

    public Stage getPrimaryStage() {
        return primaryStage;
    }

    protected <T extends Event> EventHandler<T> wrap(SilentEventHandler<T> handler) {
        return SilentEventHandler.wrap(handler);
    }

    protected <P, R> Callback<P, R> wrap(SilentCallback<P, R> callback) {
        return SilentCallback.wrap(callback);
    }

    protected <T> ChangeListener<T> wrap(SilentChangeListener<T> listener) {
        return SilentChangeListener.wrap(listener);
    }

    protected <T> ChangeListener<T> wrap(SilentChangeListenerWithoutObservable<T> listener) {
        return SilentChangeListenerWithoutObservable.wrap(listener);
    }

    protected <T> ChangeListener<T> wrap(SilentChangeListenerNewValueOnly<T> listener) {
        return SilentChangeListenerNewValueOnly.wrap(listener);
    }

    protected InvalidationListener wrap(SilentInvalidationListener listener) {
        return SilentInvalidationListener.wrap(listener);
    }

    protected Runnable wrap(SilentRunnable runnable) {
        return SilentRunnable.wrap(runnable);
    }

    protected <V> Callable<V> wrap(SilentCallable<V> callable) {
        return SilentCallable.wrap(callable);
    }

    static {
        count = new AtomicInteger(0);
        latch = new CountDownLatch(1);
        isAutoCloseSplashScreen = true;
    }

    public static class Interceptor
    extends Application {
        private Application app;

        public Interceptor() throws ReflectiveOperationException {
            Constructor<? extends Application> c = appClass.getConstructor(new Class[0]);
            this.app = c.newInstance(new Object[0]);
        }

        public void init() throws Exception {
            this.app.init();
        }

        public void start(Stage stage) throws Exception {
            primaryStage = stage;
            stage.addEventHandler(WindowEvent.WINDOW_SHOWN, (EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent windowEvent) {
                    if (isAutoCloseSplashScreen) {
                        Platform.runLater(() -> Interceptor.closeSplashScreen());
                    }
                    primaryStage.removeEventHandler(windowEvent.getEventType(), (EventHandler)this);
                }
            });
            this.app.start(stage);
            latch.countDown();
        }

        public void stop() throws Exception {
            this.app.stop();
        }

        protected static void closeSplashScreen() {
            long SPLASH_TIME_MILLIS = 1500L;
            SplashScreen splash = SplashScreen.getSplashScreen();
            if (splash != null) {
                long startup = 0L;
                String s = System.getProperty("java.application.startup");
                if (s != null) {
                    try {
                        startup = Instant.parse(s).toEpochMilli();
                    }
                    catch (DateTimeParseException e) {
                        e.printStackTrace();
                    }
                }
                long elapsed = System.currentTimeMillis() - startup;
                long delay = Math.max(SPLASH_TIME_MILLIS - elapsed, 1L);
                new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), onFinished -> splash.close(), new KeyValue[0])}).play();
            }
        }
    }
}

