/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

import java.util.concurrent.Callable;

@FunctionalInterface
public interface SilentCallable<V> {
    public V call() throws Exception;

    public static <V> Callable<V> wrap(SilentCallable<V> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                } else {
                    SilentCallable.rethrow(e);
                }
                return null;
            }
        };
    }

    public static void rethrow(Throwable throwable) {
        SilentCallable.rethrow0(throwable);
    }

    public static <T extends Throwable> void rethrow0(Throwable throwable) throws T {
        throw throwable;
    }
}

