/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

import javafx.beans.value.ChangeListener;

@FunctionalInterface
public interface SilentChangeListenerNewValueOnly<T> {
    public void changed(T var1) throws Exception;

    public static <T> ChangeListener<T> wrap(SilentChangeListenerNewValueOnly<T> listener) {
        return (observable, oldValue, newValue) -> {
            try {
                listener.changed(newValue);
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                } else {
                    SilentChangeListenerNewValueOnly.rethrow(e);
                }
                return;
            }
        };
    }

    public static void rethrow(Throwable throwable) {
        SilentChangeListenerNewValueOnly.rethrow0(throwable);
    }

    public static <T extends Throwable> void rethrow0(Throwable throwable) throws T {
        throw throwable;
    }
}

