unit ja_embed;

{
        JagaScript Embed Object Unit by T.Nak
}

interface

//{$DEFINE DEBUG}

uses
    windows, tn_classes, tn_utils, tn_internet, tn_math, tn_bregexp;

type
    TErrorValue     =   (errParam, errMemberNotFound, errDivZero, errInvalidChar
                            , errNoIdentifer, errArrayErr, errInvalidID, errSyntax);
    TValueType      =   (nmInt, nmFloat, nmNaN, nmUndefined, nmPInf, nmMInf);

    //vg^Cv
    TErrors         =   class;
    TVirtualObject  =   class;
    TInternalFunc   =   function (args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject of Object;
    PInternalFunc   =   ^TInternalFunc;
    TObjectServer   =   class;
    TPluginLoader   =   class;
    PObjectServer   =   ^TObjectServer;

    TErrorData  =   record
        ErrCode : Integer;
        LineNum : Integer;
        Message : String;
        FileName : String;
    end;

    TErrors =   class
        private
            Errors : array of TErrorData;
        public
            Count : Integer;
            Line : Integer;
            FileName : String;
            Alert : Boolean;
            ErrOccured : Boolean;
            constructor Create;
            procedure Add(Line : Integer ; ErrCode : Integer ; Message : String ; FileName : String);
            procedure Clear;
            procedure RuntimeErr(ErrCode : TErrorValue);
            function GetErrMessage : String;
    end;

    TBaseObject     =   class
        public
            Parent : TBaseObject;
            Variants : TNStringList;
            Start : Integer;
            ClassName : String;
            PreCode : String;
            constructor Create;
            destructor Destroy; override;
    end;

    TFunction       =   class(TBaseObject)
        public
            Name : String;
            Code : String;
            InternalFunc : TInternalFunc;
            MaxParam : Integer;
            Line : Integer;
    end;

    TVariantList        =   class
        public
            Count : Integer;
            Names : array of String;
            Datas : array of TVirtualObject;
            Server : TObjectServer;
            constructor Create(ObjectServer : TObjectServer);
            destructor Destroy; override;
            function Add(Name : String) : TVirtualObject;
            procedure Clear;
            function GetIndex(Name : String) : Integer;
            function IsExists(Name : String) : Boolean;
            procedure SetString(Name : String ; Data : String ; Server : TObjectServer);
            procedure SetInt(Name : String ; Data : Integer ; Server : TObjectServer);
            procedure SetFloat(Name : String ; Data : Double ; Server : TObjectServer);
            procedure SetObject(Name : String ; Data : TVirtualObject);
            procedure SetBoolean(Name : String ; Data : Boolean ; Server : TObjectServer);
            function GetObject(Name : String) : TVirtualObject;
            procedure Erase(Name : String);
            procedure Blank(Name : String ; Server : TObjectServer);
    end;

    TArray          =   class
        public
            Count : Integer;
            Indexs : TNIntList;
            Datas : array of TVirtualObject;
            Server : TObjectServer;
            constructor Create(ObjectServer : TObjectServer);
            destructor Destroy; override;
            procedure Add(Index : Integer);
            function GetIndex(Index : Integer) : Integer;
            function GetMaxIndex : Integer;
            procedure AddNext(Obj : TVirtualObject);
            procedure Clear;
    end;

    TFunctionList   =   class
        public
            Count : Integer;
            Functions : array of TFunction;
            constructor Create;
            destructor Destroy; override;
            procedure Add(Func : TFunction);
            function Find(Name : String) : Integer;
    end;

    TJaObject       =   class(TBaseObject)
        protected
            function toString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function valueOf(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
        public
            Line : Integer;
            Parent : TBaseObject;
            Functions : TFunctionList;
            Properties : TFunctionList;
            FinalCode : String;
            ScriptFile : String;
            constructor Create;
            destructor Destroy; override;
            procedure CreateObject(This : TVirtualObject); virtual;
            procedure FreeObject(This : TVirtualObject); virtual;
            function Execute(Name : String ; args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
            function FindProperty(Name : String) : TFunction;
            procedure AddFunction(Name : String ; Func : TInternalFunc ; MaxParam : Integer);
            procedure AddProperty(Name : String ; Func : TInternalFunc);
            function IsParent(Name : String) : Boolean; virtual;
            function FindFunction(Name : String) : TFunction;
    end;

    TJaGlobal       =   class(TJaObject)
        private
            function escape(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function isNaN(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function messagebox(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function parseFloat(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function parseInt(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function unescape(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        public
            Main : String;
            constructor Create;
            destructor Destroy; override;
    end;

    TJaString       =   class(TJaObject)
        private
            //RXgN^
            function Construct(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            //StringIuWFNg̃\bh
            function anchor(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function big(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function blink(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function bold(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function charAt(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function charCodeAt(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function concat(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function fixed(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function fontcolor(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function fontsize(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function fromCharCode(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function indexOf(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function italics(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function lastIndexOf(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function length(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function link(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function match(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function replace(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function slice(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function small(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function split(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function strike(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function sub(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function substr(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function substring(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function sup(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function toLowerCase(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function toUpperCase(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function trim(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
            function sliceString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; virtual;
        protected
            //I[o[Ch
            function toString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; override;
        public
            constructor Create;
            destructor Destroy; override;
    end;

    TJaNumber       =   class(TJaObject)
        public
            constructor Create;
    end;

    TJaBoolean      =   class(TJaObject)
        protected
            function toString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; override;
        public
            constructor Create;
            destructor Destroy; override;
    end;

    TJaRegExp       =   class(TJaObject)
        private
            NotExec : Boolean;
            IsGlobal : Boolean;
            //RXgN^
            function Construct(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            //\bhEvpeB
            function compile(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function exec(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function test(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            procedure FreeRegExp;
        public
            RegExp : TRegExp;
            constructor Create;
            destructor Destroy; override;
    end;

    TJaArray        =   class(TJaObject)
        private
            function concat(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function join(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function length(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function pop(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function push(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function reverse(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function shift(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function slice(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function splice(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function unshift(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        protected
            //I[o[Ch
            function toString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; override;
        public
            constructor Create;
            destructor Destroy; override;
    end;

    TJaMath         =   class(TJaObject)
        private
            function abs(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function acos(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function asin(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function atan(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function atan2(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function ceil(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function cos(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function E(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function exp(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function floor(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function LN10(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function log(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function LOG10E(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function LOG2E(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function max(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function min(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function PI(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function pow(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function random(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function round(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function sin(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function sqrt(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function SQRT1_2(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function SQRT2(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function tan(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        public
            constructor Create;
            destructor Destroy; override;
    end;

    TJaDate         =   class(TJaObject)
        private
            //RXgN^
            function Construct(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            //\bh
            function getDate(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getDay(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getFullYear(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getHours(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getMilliSeconds(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getMinutes(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getMonth(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getSeconds(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getTime(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getTimeZoneOffset(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getUTCDate(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getUTCDay(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getUTCFullYear(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getUTCHours(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getUTCMilliSeconds(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getUTCMinutes(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getUTCMonth(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getUTCSeconds(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getVarDate(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getYear(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function parse(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setDate(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setFullYear(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setHours(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setMilliSeconds(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setMinutes(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setMonth(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setSeconds(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setTime(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setUTCDate(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setUTCFullYear(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setUTCHours(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setUTCMilliSeconds(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setUTCMinutes(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setUTCMonth(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setUTCSeconds(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setYear(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function toGMTString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function toLocaleString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function toUTCString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function UTC(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        protected
            //I[o[Ch
            function toString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; override;
        public
            constructor Create;
            destructor Destroy; override;
    end;

    TJaUndefined    =   class(TJaObject)
        public
            constructor Create;
    end;

    //XNvgGWŎۂɃCX^XIuWFNg
    TVirtualObject  =   class
        public
            Reference : TJaObject;          //ۂɎgpꂽIuWFNg
            Variants : TVariantList;        //ϐ̃Xg
            Server : TObjectServer;         //IuWFNgT[o
            Int_Data : Integer;
            Float_Data : Double;
            Str_Data : String;
            ValueType : TValueType;
            Includes : array of TVirtualObject;    //Globalp
            Include_Count : Integer;
            Global : TVirtualObject;
            Arrays : TArray;
            UseCount : Integer;
            Data : Pointer;
            Data2 : Pointer;
            constructor Create(ObjectServer : TObjectServer);
            destructor Destroy; override;
            procedure Free;
            procedure Inc;
            procedure Dec;
            procedure BAnd(Dest : TVirtualObject);
            procedure BOr(Dest : TVirtualObject);
            procedure BNot;
            procedure BitAnd(Dest : TVirtualObject);
            procedure BitOr(Dest : TVirtualObject);
            procedure BitNot;
            procedure BitXor(Dest : TVirtualObject);
            procedure Add(Dest : TVirtualObject);
            procedure Sub(Dest : TVirtualObject);
            procedure Mul(Dest : TVirtualObject);
            procedure Divide(Dest : TVirtualObject);
            procedure Mode(Dest : TVirtualObject);
            function Equal(Dest : TVirtualObject) : Boolean;
            function ShiftRight(Dest : TVirtualObject) : Boolean;
            function ShiftLeft(Dest : TVirtualObject) : Boolean;
            function ShiftRightNF(Dest : TVirtualObject) : Boolean;
            function Compare(Dest : TVirtualObject ; var Compatibled : Boolean) : Integer;
            function FindArray(Param : TVirtualObject) : Integer;
    end;

    TObjectServer   =   class
        private
            function Add(Name : String) : TJaObject;
            procedure EmbedObject;
        public
            Count : Integer;
            Types : array of TJaObject;
            Global : TVirtualObject;
            Plugin : TPluginLoader;
            DustBox : TNIntList;
            constructor Create;
            destructor Destroy; override;
            function PrepareInstance(Name : String) : TVirtualObject;
            function IsClassExists(Name : String) : Boolean;
            function CreateInherited(Name : String ; Parent : String) : TJaObject;
            function GetClass(Name : String) : TJaObject;
    end;

    TPluginLoader   =   class
        private
            Count : Integer;
            Names : array of String;
            Objects : array of TJaObject;
            function FindClass(Name : String) : TJaObject;
        public
            constructor Create;
            destructor Destroy; override;
            procedure Add(Name : String ; Obj : TJaObject);
    end;

    function ForceString(Obj : TVirtualObject) : String;
    function ForceInt(Obj : TVirtualObject ; var IsNaN : Boolean) : Integer;
    function ForceDouble(Obj : TVirtualObject ; var IsNaN : Boolean) : Double;
    function ForceBool(Obj : TVirtualObject) : Boolean;

    function ToWord(Value : Integer) : Word;
    procedure VarCopy(const Data : TVirtualObject ; var Dest : TVirtualObject ; Server : TObjectServer);
    procedure VarCopy2(const Data : TVirtualObject ; var Dest : TVirtualObject);

    function MakeInt(Value : Integer ; Server : TObjectServer) : TVirtualObject;
    function MakeFloat(Value : Double ; Server : TObjectServer) : TVirtualObject;
    function MakeNaN(Server : TObjectServer) : TVirtualObject;
    function MakeString(Value : String ; Server : TObjectServer) : TVirtualObject;
    function MakeBoolean(Value : Boolean ; Server : TObjectServer) : TVirtualObject;
    function MakeUndefined(Server : TObjectServer) : TVirtualObject;

    function JagaTimeAdjust(Time : TDateTime) : TDateTime;
    function DateTimeToJagaDate(Time : TDateTime) : Double;
    function JagaDateToDateTime(Time : Integer) : TDateTime;

    function IDCheck(ID : String) : Boolean;

const
    TITLE           =   'Grape Software JagaScript';
    ID_STRING       =   ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_$';

implementation

//******************************************************************************
//TErrors

constructor TErrors.Create;
begin
    inherited Create;
    Alert := True;
    ErrOccured := False;
    FileName := '';
end;

procedure TErrors.Add(Line : Integer ; ErrCode : Integer ; Message : String ; FileName : String);
begin
    SetLength(Errors, Count + 1);
    Errors[Count].ErrCode := ErrCode;
    Errors[Count].LineNum := Line;
    Errors[Count].Message := Message;
    Errors[Count].FileName := FileName;
    Count := Count + 1;
end;

procedure TErrors.Clear;
begin
    SetLength(Errors, 0);
    Count := 0;
    ErrOccured := False;
end;

procedure TErrors.RuntimeErr(ErrCode : TErrorValue);
var
    EMessage : String;
    temp : String;
begin
    EMessage := '';

    case ErrCode of
        errParam:
            EMessage := '֐̌Ăяoň̐ƈvĂ܂.';

        errMemberNotFound:
            EMessage := 'IuWFNg̃o[֐܂.';

        errDivZero:
            EMessage := '0ŏZ܂.';

        errInvalidChar:
            EMessage := 'sȕł.';

        errInvalidID:
            EMessage := 'ʎqsł.';

        else
            EMessage := '`G[.';
    end;

    if Alert then
    begin
        temp := 'sG[ - ' + EMessage + #13#10
                + 't@C : ' + FileName + #13#10
                + 's       : ' + IntToStr(Line);

        MessageBox(0, PChar(temp), 'sG[', MB_ICONWARNING);
        ErrOccured := True;
    end
    else
        ErrOccured := True;
end;

function TErrors.GetErrMessage : String;
var
    n : Integer;
begin
    Result := '';

    for n := 0 to Count - 1 do
    begin
        Result := Result
                    + '[G[]' + ExtractFileName(Errors[n].FileName)
                    + '(' + IntToStr(Errors[n].LineNum) + '): '
                    + Errors[n].Message + #13#10;
    end;
end;

//******************************************************************************
//TBaseObject

constructor TBaseObject.Create;
begin
    Variants := TNStringList.Create;
    ClassName := 'Function';
    PreCode := '';
    Start := 0;
    Parent := nil;
end;

destructor TBaseObject.Destroy;
begin
    Variants.Free;

    inherited Destroy;
end;

//******************************************************************************
//TVariantList

constructor TVariantList.Create(ObjectServer : TObjectServer);
begin
    Server := ObjectServer;
    SetLength(Names, 0);
    SetLength(Datas, 0);
    Count := 0;
end;

destructor TVariantList.Destroy;
begin
    Clear;
    inherited Destroy;
end;

function TVariantList.Add(Name : String) : TVirtualObject;
begin
    SetLength(Names, Count + 1);
    SetLength(Datas, Count + 1);
    Names[Count] := Name;
    Datas[Count] := Server.PrepareInstance('Undefined');
    Result := Datas[Count];
    Count := Count + 1;
end;

procedure TVariantList.Clear;
var
    n : Integer;
begin
    if Count = 0 then Exit;

    for n := 0 to Count - 1 do
    begin
        if Server.DustBox.IndexOf(Integer(Pointer(Datas[n]))) <> -1 then
            Datas[n].Free;
    end;

    SetLength(Names, 0);
    SetLength(Datas, 0);
    Count := 0;
end;

function TVariantList.GetIndex(Name : String) : Integer;
var
    n : Integer;
begin
    Result := -1;

    for n := 0 to Count - 1 do
    begin
        if Names[n] = Name then
        begin
            Result := n;
            Break;
        end;
    end;
end;

function TVariantList.IsExists(Name : String) : Boolean;
var
    n : Integer;
begin
    Result := False;

    for n := 0 to Count - 1 do
    begin
        if Names[n] = Name then
        begin
            Result := True;
            Break;
        end;
    end;
end;

procedure TVariantList.SetString(Name : String ; Data : String ; Server : TObjectServer);
var
    Index : Integer;
begin
    Index := GetIndex(Name);

    if Index = -1 then
    begin
        //Ȃ

        if IDCheck(Name) then
        begin
            //쐬Ċi[
            Add(Name);
            Index := GetIndex(Name);
            Datas[Index].Free;
            Datas[Index] := MakeString(Data, Server);
        end;
    end
    else
    begin
        Datas[Index].Free;
        Datas[Index] := MakeString(Data, Server);
    end;
end;

procedure TVariantList.SetInt(Name : String ; Data : Integer ; Server : TObjectServer);
var
    Index : Integer;
begin
    Index := GetIndex(Name);

    if Index = -1 then
    begin
        //Ȃ

        if IDCheck(Name) then
        begin
            //쐬Ċi[
            Add(Name);
            Index := GetIndex(Name);
            Datas[Index].Free;
            Datas[Index] := MakeInt(Data, Server);
        end;
    end
    else
    begin
        Datas[Index].Free;
        Datas[Index] := MakeInt(Data, Server);
    end;
end;

procedure TVariantList.SetFloat(Name : String ; Data : Double ; Server : TObjectServer);
var
    Index : Integer;
begin
    Index := GetIndex(Name);

    if Index = -1 then
    begin
        //Ȃ

        if IDCheck(Name) then
        begin
            //쐬Ċi[
            Add(Name);
            Index := GetIndex(Name);
            Datas[Index].Free;

            if Trunc(Data) = Data then
                Datas[Index] := MakeInt(Trunc(Data), Server)
            else
                Datas[Index] := MakeFloat(Data, Server);
        end;
    end
    else
    begin
        Datas[Index].Free;

        if Trunc(Data) = Data then
            Datas[Index] := MakeInt(Trunc(Data), Server)
        else
            Datas[Index] := MakeFloat(Data, Server);
    end;
end;

procedure TVariantList.SetObject(Name : String ; Data : TVirtualObject);
var
    Index : Integer;
begin
    Index := GetIndex(Name);

    if Index = -1 then
    begin
        //쐬Ċi[
        Add(Name);
        Index := GetIndex(Name);
        Datas[Index].Free;
        Datas[Index] := Data;
    end
    else
    begin
        Datas[Index].Free;
        Datas[Index] := Data;
    end;
end;

procedure TVariantList.SetBoolean(Name : String ; Data : Boolean ; Server : TObjectServer);
var
    Index : Integer;
begin
    Index := GetIndex(Name);

    if Index = -1 then
    begin
        //Ȃ

        if IDCheck(Name) then
        begin
            //쐬Ċi[
            Add(Name);
            Index := GetIndex(Name);
            Datas[Index].Free;
            Datas[Index] := MakeBoolean(Data, Server);
        end;
    end
    else
    begin
        Datas[Index].Free;
        Datas[Index] := MakeBoolean(Data, Server);
    end;
end;

function TVariantList.GetObject(Name : String) : TVirtualObject;
var
    Index : Integer;
begin
    Index := GetIndex(Name);
    if Index <> -1 then
        Result := Datas[Index]
    else
    begin
        Add(Name);
        Index := GetIndex(Name);
        Result := Datas[Index];
    end;
end;

procedure TVariantList.Erase(Name : String);
var
    Index : Integer;
    Obj : TVirtualObject;
begin
    Index := GetIndex(Name);

    if Index <> -1 then
    begin
        Obj := Datas[Index];
        Obj.Reference := nil;
    end;
end;

procedure TVariantList.Blank(Name : String ; Server : TObjectServer);
var
    Index : Integer;
    Obj : TVirtualObject;
begin
    Index := GetIndex(Name);

    if Index <> -1 then
    begin
        Obj := Datas[Index];
        Obj.Free;
        Datas[Index] := Server.PrepareInstance('Undefined');
    end;
end;

//******************************************************************************
//TArray

constructor TArray.Create(ObjectServer : TObjectServer);
begin
    Count := 0;
    Server := ObjectServer;
    Indexs := TNIntList.Create;
end;

destructor TArray.Destroy;
begin
    Clear;
    Indexs.Free;
end;

procedure TArray.Add(Index : Integer);
var
    Ind : Integer;
begin
    Ind := Indexs.IndexOf(Index);

    if Ind = -1 then
    begin
        Indexs.Add(Index);
        SetLength(Datas, Count + 1);
        Datas[Count] := Server.PrepareInstance('Undefined');
        Count := Count + 1;
    end;
end;

function TArray.GetIndex(Index : Integer) : Integer;
begin
    Result := Indexs.IndexOf(Index);
end;

function TArray.GetMaxIndex : Integer;
begin
    Result := Indexs.MaxValue;
    if Result < 0 then Result := -1;
end;

procedure TArray.AddNext(Obj : TVirtualObject);
var
    Index : Integer;
begin
    Index := GetMaxIndex + 1;
    Indexs.Add(Index);

    //if (Count = 0) or (Count div 50 <> (Count + 1) div 50) then
    //begin
    //    Setlength(Datas, ((Count + 1) div 50 + 1) * 50);
    //end;

    SetLength(Datas, Count + 1);
    Datas[Count] := Obj;
    Count := Count + 1;
end;

procedure TArray.Clear;
var
    n : Integer;
begin
    if Count = 0 then Exit;

    for n := 0 to Count - 1 do
    begin
        if Server.DustBox.IndexOf(Integer(Pointer(Datas[n]))) <> -1 then
            Datas[n].Free;
    end;

    Indexs.Clear;
    Setlength(Datas, 0);
    Count := 0;
end;

//******************************************************************************
//TFunctionList

constructor TFunctionList.Create;
begin
    SetLength(Functions, 0);
    Count := 0;
end;

destructor TFunctionList.Destroy;
var
    n : Integer;
begin
    for n := 0 to Count - 1 do
        Functions[n].Free;

    inherited Destroy;
end;

procedure TFunctionList.Add(Func : TFunction);
begin
    SetLength(Functions, Count + 1);
    Functions[Count] := Func;
    Count := Count + 1;
end;

function TFunctionList.Find(Name : String) : Integer;
var
    n : Integer;
begin
    Result := -1;

    for n := Count - 1 downto 0 do
    begin
        if Functions[n].Name = Name then
        begin
            Result := n;
            Exit;
        end;
    end;
end;

//******************************************************************************
//TJaObject -> Object

constructor TJaObject.Create;
begin
    inherited Create;

    Functions := TFunctionList.Create;
    Properties := TFunctionList.Create;
    ClassName := 'Object';
    FinalCode := '';
    ScriptFile := '';
    Parent := nil;

    //\bh̒ǉ
    AddFunction('toString', toString, 0);
    AddFunction('valueOf', valueOf, 0);
end;

destructor TJaObject.Destroy;
begin
    Functions.Free;
    Properties.Free;

    inherited Destroy;
end;

procedure TJaObject.CreateObject(This : TVirtualObject);
begin
    //KvɉăI[o[Ch
    Exit;
end;

procedure TJaObject.FreeObject(This : TVirtualObject);
begin
    //KvɉăI[o[Ch
    Exit;
end;

function TJaObject.Execute(Name : String ; args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
    Index : Integer;
begin
    Result := nil;

    //ǉꂽ֐Ăяo
    Index := Functions.Find(Name);

    if Index = -1 then
    begin
        //Parenť

        if Parent = nil then
        begin
            Error.RuntimeErr(errMemberNotFound);
            Exit;
        end;

        Result := TJaObject(Parent).Execute(Name, args, This, Error);
    end
    else
    begin
        //`FbN
        if Functions.Functions[Index].MaxParam >= High(args) + 1 then
        begin
            if @Functions.Functions[Index].InternalFunc <> nil then
                //s
                Result := Functions.Functions[Index].InternalFunc(args, This, Error)
            else
            begin
                //^CIuWFNgɐڂ

            end;
        end
        else
            Error.RuntimeErr(errParam);
    end;
end;

function TJaObject.FindProperty(Name : String) : TFunction;
var
    Index : Integer;
begin
    Result := nil;
    Index := Properties.Find(Name);

    if Index <> -1 then
        Result := Properties.Functions[Index]
    else if Parent <> nil then
    begin
        Result := TJaObject(Parent).FindProperty(Name);
    end;
end;

procedure TJaObject.AddFunction(Name : String ; Func : TInternalFunc ; MaxParam : Integer);
var
    NewFunc : TFunction;
begin
    NewFunc := TFunction.Create;
    NewFunc.Name := Name;
    NewFunc.InternalFunc := Func;
    NewFunc.MaxParam := MaxParam;
    Functions.Add(NewFunc);
end;

procedure TJaObject.AddProperty(Name : String ; Func : TInternalFunc);
var
    NewFunc : TFunction;
begin
    NewFunc := TFunction.Create;
    NewFunc.Name := Name;
    NewFunc.InternalFunc := Func;
    Properties.Add(NewFunc);
end;

function TJaObject.IsParent(Name : String) : Boolean;
begin
    Result := False;

    if Name = 'Object' then
        Result := True
    else if Name = ClassName then
        Result := True
    else if Parent <> nil then
        Result := TJaObject(Parent).IsParent(Name);
end;

function TJaObject.FindFunction(Name : String) : TFunction;
var
    Index : Integer;
begin
    Result := nil;
    Index := Functions.Find(Name);

    if Index <> -1 then
        Result := Functions.Functions[Index]
    else if Parent <> nil then
    begin
        Result := TJaObject(Parent).FindFunction(Name);
    end;
end;

function TJaObject.toString(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString('[' + ClassName + ']', This.Server);
end;

function TJaObject.valueOf(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    VarCopy(This, Result, This.Server);
end;

//******************************************************************************
//TJaGlobal

constructor TJaGlobal.Create;
begin
    inherited Create;
    ClassName := 'Global';
    ScriptFile := '';

    //\bh̒ǉ
    AddFunction('escape', escape, 1);
    AddFunction('isNaN', isNaN, 1);
    AddFunction('messagebox', messagebox, 1);
    AddFunction('parseFloat', parseFloat, 1);
    AddFunction('parseInt', parseInt, 1);
    AddFunction('unescape', unescape, 1);
end;

destructor TJaGlobal.Destroy;
begin
    inherited Destroy;
end;

function TJaGlobal.escape(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(UrlEncode(ForceString(args[0])), This.Server);
end;

function TJaGlobal.isNaN(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeBoolean(args[0].ValueType = nmNaN, This.Server);
end;

function TJaGlobal.messagebox(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
begin
    temp := ForceString(args[0]);
    Windows.MessageBox(0, PChar(temp), TITLE, MB_ICONWARNING);
    Result := MakeUndefined(This.Server);
end;

function TJaGlobal.parseFloat(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    NaN : Boolean;
begin
    Result := MakeFloat(ForceDouble(args[0], NaN), This.Server);
    if NaN then Result.ValueType := nmNaN;
end;

function TJaGlobal.parseInt(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    NaN : Boolean;
begin
    Result := MakeInt(ForceInt(args[0], NaN), This.Server);
    if NaN then Result.ValueType := nmNaN;
end;

function TJaGlobal.unescape(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(UrlDecode(ForceString(args[0])), This.Server);
end;

//******************************************************************************
//TJaString -> String
constructor TJaString.Create;
begin
    inherited Create;
    ClassName := 'String';

    //RXgN^
    AddFunction('String', Construct, 1);

    //\bh̒ǉ
    AddFunction('anchor', anchor, 1);
    AddFunction('big', big, 0);
    AddFunction('blink', blink, 0);
    AddFunction('bold', bold, 0);
    AddFunction('charAt', charAt, 1);
    AddFunction('charCodeAt', charCodeAt, 1);
    AddFunction('concat', concat, 1);
    AddFunction('fixed', fixed, 0);
    AddFunction('fontcolor', fontcolor, 1);
    AddFunction('fontsize', fontsize, 1);
    AddFunction('fromCharCode', fromCharCode, 0);
    AddFunction('indexOf', indexOf, 1);
    AddFunction('italics', italics, 0);
    AddFunction('lastIndexOf', lastIndexOf, 1);
    AddFunction('link', link, 1);
    AddFunction('match', match, 1);
    AddFunction('replace', replace, 2);
    AddFunction('slice', slice, 1);
    AddFunction('small', small, 0);
    AddFunction('split', split, 1);
    AddFunction('strike', strike, 0);
    AddFunction('sub', sub, 0);
    AddFunction('substr', subStr, 1);
    AddFunction('substring', subString, 2);
    AddFunction('sup', sup, 0);
    AddFunction('toLowerCase', toLowerCase, 0);
    AddFunction('toUpperCase', toUpperCase, 0);
    AddFunction('trim', trim, 0);
    AddFunction('sliceString', sliceString, 2);

    //vpeB
    AddProperty('length', length);
end;

destructor TJaString.Destroy;
begin
    inherited Destroy;
end;

function TJaString.Construct(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    if High(args) = 0 then
        This.Str_Data := args[0].Str_Data;

    Result := MakeString(This.Str_Data, This.Server);
end;

function TJaString.toString(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(This.Str_Data, This.Server);
end;

function TJaString.anchor(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
begin
    temp := '<A NAME="' + ForceString(args[0]) + '">'
                                        + This.Str_Data + '</A>';
    Result := MakeString(temp, This.Server);
end;

function TJaString.big(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
begin
    temp := '<BIG>' + This.Str_Data + '</BIG>';
    Result := MakeString(temp, This.Server);
end;

function TJaString.blink(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
begin
    temp := '<BLINK>' + This.Str_Data + '</BLINK>';
    Result := MakeString(temp, This.Server);
end;

function TJaString.bold(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
begin
    temp := '<B>' + This.Str_Data + '</B>';
    Result := MakeString(temp, This.Server);
end;

function TJaString.charAt(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Index : Integer;
    NaN : Boolean;
begin
    Index := ForceInt(args[0], NaN) + 1;

    if NaN then
        Result := MakeUndefined(This.Server)
    else
    begin
        if (Index < 1) or (Index > System.Length(This.Str_Data)) then
            Result := MakeUndefined(This.Server)
        else
            Result := MakeString(This.Str_Data[Index], This.Server);
    end;
end;

function TJaString.charCodeAt(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Index : Integer;
    NaN : Boolean;
begin
    Index := ForceInt(args[0], NaN) + 1;

    if NaN then
        Result := MakeUndefined(This.Server)
    else
    begin
        if (Index < 1) or (Index > System.Length(This.Str_Data)) then
            Result := MakeUndefined(This.Server)
        else
            Result := MakeInt(Integer(This.Str_Data[Index]), This.Server);
    end;
end;

function TJaString.concat(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
    n : Integer;
begin
    temp := This.Str_Data;

    for n := 0 to High(args) do
    begin
        temp := temp + ForceString(args[n]);
    end;

    Result := MakeString(temp, This.Server);
end;

function TJaString.fixed(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
begin
    temp := '<TT>' + This.Str_Data + '</TT>';
    Result := MakeString(temp, This.Server);
end;

function TJaString.fontcolor(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
begin
    temp := '<FONT COLOR="' + ForceString(args[0]) + '">'
                                            + This.Str_Data + '</FONT>';
    Result := MakeString(temp, This.Server);
end;

function TJaString.fontsize(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
begin
    temp := '<FONT SIZE="' + ForceString(args[0]) + '">'
                                        + This.Str_Data + '</FONT>';
    Result := MakeString(temp, This.Server);
end;

function TJaString.fromCharCode(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    n : Integer;
    temp : WideString;
    NaN : Boolean;
begin
    for n := 0 to High(args) do
        temp := temp + WideChar(ToWord(ForceInt(args[n], NaN)));

    Result := MakeString(AnsiString(temp), This.Server);
end;

function TJaString.indexOf(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Data : String;
    Index : Integer;
    NaN : Boolean;
begin
    Data := ForceString(args[0]);

    if High(args) = 0 then
        Index := 0
    else
        Index := ForceInt(args[1], NaN);

    if Index >= System.Length(This.Str_Data) then
        Index := System.Length(This.Str_Data) - 1;

    if Index < 0 then
        Index := 0;

    Result := MakeInt(Pos(Data
                    , String(PChar(PChar(This.Str_Data) + Index)))
                        , This.Server);

    if Result.Int_Data <> 0 then
        Result.Int_Data := Result.Int_Data + Index - 1
    else
        Result.Int_Data := -1;
end;

function TJaString.italics(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString('<I>' + This.Str_Data + '</I>', This.Server);
end;

function TJaString.lastIndexOf(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Data : String;
    temp : String;
    Index : Integer;
    NaN : Boolean;
begin
    Data := ForceString(args[0]);

    if High(args) = 0 then
        Index := 0
    else
        Index := ForceInt(args[1], NaN);

    if Index >= System.Length(This.Str_Data) then
        Index := System.Length(This.Str_Data) - 1;

    if Index < 0 then
        Index := 0;

    temp := Copy(This.Str_Data, 1, Index + 1);
    Result := MakeInt(BackPos(Data, temp), This.Server);
    Result.Int_Data := Result.Int_Data - 1;
end;

function TJaString.length(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeInt(System.Length(This.Str_Data), This.Server);
end;

function TJaString.link(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(
                '<A HREF="' + ForceString(args[0]) + '">' + This.Str_Data + '</A>'
                    , This.Server);
end;

function TJaString.match(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Target : TVirtualObject;
    temp : String;
    newargs : array of TVirtualObject;
begin
    if args[0].Reference = nil then
        Result := MakeBoolean(False, This.Server)
    else
    begin
        if args[0].Reference.ClassName = 'RegExp' then
        begin
            SetLength(newargs, 1);
            newargs[0] := This;
            Target := TJaRegExp(args[0].Reference).exec(newargs, args[0], Error);
            TJaRegExp(args[0].Reference).FreeRegExp;
            Result := MakeBoolean(Target.Arrays.Count <> 0, This.Server);
            Target.Free;
        end
        else
        begin
            temp := ForceString(args[0]);
            Result := MakeBoolean(Pos(temp, This.Str_Data) <> 0, This.Server);
        end;
    end;
end;

function TJaString.replace(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Target_Str : String;
    Replace_Str : String;
begin
    if args[0].Reference = nil then
    begin
        Result := MakeBoolean(False, This.Server);
        Exit;
    end;

    if args[0].Reference.ClassName = 'RegExp' then
    begin
        Replace_Str := ForceString(args[1]);
        This.Str_Data := TJaRegExp(args[0].Reference).RegExp.Replace(This.Str_Data, Replace_Str);
    end
    else
    begin
        //Iɕɂ
        Target_Str := ForceString(args[0]);
        Replace_Str := ForceString(args[1]);
        This.Str_Data := tn_utils.Replace(This.Str_Data, Target_Str, Replace_Str);
    end;

    VarCopy(This, Result, This.Server);
end;

function TJaString.slice(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    ArrayCount : Integer;
    Start : Integer;
    Ends : Integer;
    NaN : Boolean;
    temp : String;
begin
    ArrayCount := High(args) + 1;

    if ArrayCount = 1 then
    begin
        Start := ForceInt(args[0], NaN);
        temp := Copy(This.Str_Data, Start + 1, System.Length(This.Str_Data) - Start);
        Result := MakeString(temp, This.Server)
    end
    else if ArrayCount = 2 then
    begin
        Start := ForceInt(args[0], NaN);
        Ends := ForceInt(args[1], NaN);
        temp := Copy(This.Str_Data, Start + 1, Ends - Start + 1);
        Result := MakeString(temp, This.Server)
    end
    else
        Result := MakeUndefined(This.Server);
end;

function TJaString.small(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString('<SMALL>' + This.Str_Data + '</SMALL>', This.Server);
end;

function TJaString.split(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Splitter : String;
    Limit : Integer;
    RegExp : TRegExp;
    List : TNStringList;
    n : Integer;
    NaN : Boolean;
begin
    List := TNStringList.Create;
    Result := This.Server.PrepareInstance('Array');
    Splitter := ForceString(args[0]);

    if High(args) = 1 then
    begin
        Limit := ForceInt(args[1], NaN);
        if Limit <= 0 then Limit := -1;
    end
    else
        Limit := -1;

    RegExp := TRegExp.Create(Splitter, '');
    RegExp.Split(This.Str_Data, Limit);

    SetLength(Result.Arrays.Datas, RegExp.Count);
    Result.Arrays.Count := RegExp.Count;

    for n := 0 to RegExp.Count - 1 do
    begin
        Result.Arrays.Datas[n] := MakeString(RegExp.Match[n], This.Server);
        Result.Arrays.Indexs.Add(n);
    end;

    List.Free;
    RegExp.Free;
end;

function TJaString.strike(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString('<STRIKE>' + This.Str_Data + '</STRIKE>', This.Server);
end;

function TJaString.sub(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString('<SUB>' + This.Str_Data + '</SUB>', This.Server);
end;

function TJaString.substr(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    ArrayCount : Integer;
    Start : Integer;
    Ln : Integer;
    NaN : Boolean;
    temp : String;
begin
    ArrayCount := High(args) + 1;

    if ArrayCount = 1 then
    begin
        Start := ForceInt(args[0], NaN);
        temp := Copy(This.Str_Data, Start + 1, System.Length(This.Str_Data) - Start);
        Result := MakeString(temp, This.Server)
    end
    else if ArrayCount = 2 then
    begin
        Start := ForceInt(args[0], NaN);
        Ln := ForceInt(args[1], NaN);
        temp := Copy(This.Str_Data, Start + 1, Ln);
        Result := MakeString(temp, This.Server)
    end
    else
        Result := MakeUndefined(This.Server);
end;

function TJaString.substring(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    ArrayCount : Integer;
    Start : Integer;
    Ends : Integer;
    NaN : Boolean;
    temp : String;
begin
    ArrayCount := High(args) + 1;

    if ArrayCount = 2 then
    begin
        Start := ForceInt(args[0], NaN);
        Ends := ForceInt(args[1], NaN);
        temp := Copy(This.Str_Data, Start + 1, Ends - Start + 1);
        Result := MakeString(temp, This.Server)
    end
    else
        Result := MakeUndefined(This.Server);
end;

function TJaString.sup(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString('<SUP>' + This.Str_Data + '</SUP>', This.Server);
end;

function TJaString.toLowerCase(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(LowerCase(This.Str_Data), This.Server);
end;

function TJaString.toUpperCase(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(UpperCase(This.Str_Data), This.Server);
end;

function TJaString.trim(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(tn_utils.Trim(This.Str_Data), This.Server);
end;

function TJaString.sliceString(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    AStr , BStr : String;
begin
    AStr := ForceString(args[0]);
    BStr := ForceString(args[1]);
    Result := MakeString(tn_utils.SliceString(This.Str_Data, AStr, BStr)
                            , This.Server);
end;

//******************************************************************************
//TJaNumber -> Number

constructor TJaNumber.Create;
begin
    inherited Create;
    ClassName := 'Number';
end;

//******************************************************************************
//TJaBoolean -> Boolean

constructor TJaBoolean.Create;
begin
    inherited Create;
    ClassName := 'Boolean';
end;

destructor TJaBoolean.Destroy;
begin
    inherited Destroy;
end;

function TJaBoolean.toString(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := nil;
    
    if Result.Int_Data = 0 then
        Result := MakeString('false', This.Server)
    else
        Result := MakeString('true', This.Server);
end;

//******************************************************************************
//TJaRegExp -> RegExp

constructor TJaRegExp.Create;
begin
    inherited Create;
    ClassName := 'RegExp';
    RegExp := TRegExp.Create('', '');
    IsGlobal := True;
    NotExec := True;

    //RXgN^
    AddFunction('RegExp', Construct, 1);

    //\bh̒ǉ
    AddFunction('compile', compile, 0);
    AddFunction('exec', exec, 1);
    AddFunction('test', test, 1);

    //vpeB̒ǉ
    //AddProperty('input', input);
    //AddProperty('index', index);
    //AddProperty('lastIndex', lastIndex);
    //AddProperty('lastMatch', lastMatch);
    //AddProperty('lastParen', lastParen);
    //AddProperty('leftContext', leftContext);
    //AddProperty('rightContext', rightContext);
end;

destructor TJaRegExp.Destroy;
begin
    FreeRegExp;
    RegExp.Free;
    inherited Destroy;
end;

function TJaRegExp.Construct(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    n : Integer;
begin
    RegExp.Expression := ForceString(args[0]);

    if High(args) = 1 then
    begin
        //IvV
        RegExp.Option := ForceString(args[1]);
    end;

    //vpeB($1`$9)ݒ
    for n := 1 to 9 do
        This.Variants.SetString('$' + IntToStr(n), '', This.Server);

    //̑̃vpeB
    This.Variants.SetString('pattern', RegExp.Expression, This.Server);
    This.Variants.SetString('option', RegExp.Option, This.Server);
    This.Variants.SetString('input', '', This.Server);
    This.Variants.SetInt('index', -1, This.Server);
    This.Variants.SetInt('lastIndex', -1, This.Server);
    This.Variants.SetString('lastMatch', '', This.Server);
    This.Variants.SetString('lastParen', '', This.Server);
    This.Variants.SetString('leftContext', '', This.Server);
    This.Variants.SetString('rightContext', '', This.Server);

    //߂lݒ
    Result := MakeUndefined(This.Server);
end;

function TJaRegExp.compile(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    //{̓RpCsׂȂ̂AJagaScriptł͍sȂ
    Result := MakeUndefined(This.Server);
end;

function TJaRegExp.exec(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    n : Integer;
    temp : String;
begin
    //NotExecFalse
    NotExec := False;

    //߂l̔z
    Result := This.Server.PrepareInstance('Array');

    //ExpressionEOptionݒ
    RegExp.Expression := ForceString(This.Variants.GetObject('pattern'));
    RegExp.Option := ForceString(This.Variants.GetObject('option'));

    //}b`O
    temp := ForceString(args[0]);
    RegExp.Exec(temp);

    //v
    if RegExp.Match[0] <> '' then
        Result.Arrays.AddNext(MakeString(RegExp.Match[0], This.Server));

    //O[ow
    if IsGlobal then
    begin
        while RegExp.ExecNext do
            Result.Arrays.AddNext(MakeString(RegExp.Match[0], This.Server));
    end;

    //ϐRs[
    for n := 1 to 9 do
    begin
        temp := RegExp.Match[n];
        This.Variants.SetString('$' + IntToStr(n)
                                    , temp
                                    , This.Server);
    end;

    //inputZbg
    This.Variants.SetString('input', String(RegExp.InputString) ,This.Server);

    //indexZbg
    if RegExp.MatchPos[0] > -1 then
        This.Variants.SetInt('index', RegExp.MatchPos[0] - 1, This.Server)
    else
        This.Variants.SetInt('index', -1, This.Server);

    //lastIndex
    if RegExp.MatchLen[0] > -1 then
        This.Variants.SetInt('lastIndex'
                                , RegExp.MatchPos[0] + RegExp.MatchLen[0] - 1
                                    , This.Server)
    else
        This.Variants.SetInt('lastIndex', -1, This.Server);

    //lastMatch
    This.Variants.SetString('lastMatch', RegExp.Match[0], This.Server);

    //lastParen
    This.Variants.SetString('lastParen', RegExp.Match[RegExp.SubExprMatchCount]
                                , This.Server);
    //leftContext
    This.Variants.SetString('leftContext', Copy(RegExp.InputString
                                                    , 1, RegExp.MatchPos[0] - 1)
                                , This.Server);
    //rightContext
    This.Variants.SetString('rightContext', Copy(RegExp.InputString
                                , RegExp.MatchPos[0] + RegExp.MatchLen[0]
                                    ,MaxInt), This.Server);
    //|C^ЂÂ
    FreeRegExp;
end;

function TJaRegExp.test(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
begin
    temp := ForceString(args[0]);

    //ExpressionEOptionݒ
    RegExp.Expression := ForceString(This.Variants.GetObject('pattern'));
    RegExp.Option := ForceString(This.Variants.GetObject('option'));

    Result := MakeBoolean(RegExp.Exec(temp), This.Server);
    FreeRegExp;
end;

procedure TJaRegExp.FreeRegExp;
begin
    RegExp.FreeRegExp;
    RegExp.RegInfo := nil;
end;

//******************************************************************************
//TJaArray -> Array

constructor TJaArray.Create;
begin
    inherited Create;
    ClassName := 'Array';

    //RXgN^
    AddFunction('Array', concat, 0);

    //\bh̒ǉ
    AddFunction('concat', concat, 0);
    AddFunction('join', join, 1);
    AddFunction('pop', pop, 0);
    AddFunction('push', push, 0);
    AddFunction('reverse', reverse, 0);
    AddFunction('shift', shift, 0);
    AddFunction('slice', slice, 1);
    AddFunction('splice', splice, 0);
    AddFunction('unshift', unshift, 0);
    AddFunction('valueOf', toString, 0);

    //vpeB
    AddProperty('length', length);
end;

destructor TJaArray.Destroy;
begin
    inherited Destroy;
end;

function TJaArray.concat(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    m, n : Integer;
    Index : Integer;
    Ar : TArray;
    ThisArray : TArray;
begin
    Result := nil;
    VarCopy(This, Result, This.Server);
    ThisArray := This.Arrays;

    try
        Index := ThisArray.GetMaxIndex + 1;
    except
        Exit;
    end;

    for n := 0 to High(args) do
    begin
        if (args[n].Reference = nil)
            or (not args[n].Reference.IsParent('Array')) then
        begin
            ThisArray.Add(Index);
            ThisArray.Datas[ThisArray.Count - 1].Free;
            VarCopy(args[n], ThisArray.Datas[ThisArray.Count - 1], This.Server);

            try
                Index := Index + 1;
            except
                Exit;
            end;
        end
        else
        begin
            Ar := args[n].Arrays;

            for m := 0 to Ar.Count - 1 do
            begin
                ThisArray.Add(Index);
                ThisArray.Datas[ThisArray.Count - 1].Free;
                VarCopy(Ar.Datas[m]
                            , ThisArray.Datas[ThisArray.Count - 1]
                                , This.Server);

                try
                    Index := Index + 1;
                except
                    Exit;
                end;
            end;
        end;
    end;
end;

function TJaArray.join(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    temp, stemp : String;
    n : Integer;
begin
    temp := '';
    stemp := ForceString(args[0]);

    for n := 0 to This.Arrays.Count - 1 do
    begin
        if temp <> '' then
            temp := temp + stemp;

        temp := temp + ForceString(This.Arrays.Datas[n]);
    end;

    Result := MakeString(temp, This.Server);
end;

function TJaArray.length(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    Index : Integer;
begin
    Index := This.Arrays.GetMaxIndex + 1;
    Result := MakeInt(Index, This.Server);
end;

function TJaArray.pop(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := nil;

    if This.Arrays.Count = 0 then
        Result := MakeUndefined(This.Server)
    else
        VarCopy(This.Arrays.Datas[This.Arrays.Count - 1], Result, This.Server);
end;

function TJaArray.push(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    n : Integer;
    Index : Integer;
    ThisArray : TArray;
begin
    ThisArray := This.Arrays;
    Index := This.Arrays.GetMaxIndex + 1;

    for n := 0 to High(args) do
    begin
        ThisArray.Add(Index);
        ThisArray.Datas[ThisArray.Count - 1].Free;
        VarCopy(args[n], ThisArray.Datas[ThisArray.Count - 1], This.Server);
        Index := Index + 1;
    end;

    Result := MakeInt(Index, This.Server);
end;

function TJaArray.reverse(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    m, n : Integer;
    NewArray : TArray;
    ThisArray : TArray;
    List : TNIntList;
    Index : Integer;
begin
    ThisArray := This.Arrays;
    NewArray := TArray.Create(This.Server);
    List := TNIntList.Create;
    m := 0;

    //Ŷ݂Xg
    for n := 0 to ThisArray.Count - 1 do
    begin
        Index := ThisArray.Indexs.GetValue(n);
        List.Add(Index);
    end;

    //\[g
    List.Sort;

    //f[^̈p
    NewArray.Count := List.Count;
    SetLength(NewArray.Datas, List.Count);

    //f[^ړ
    for n := List.Count - 1 downto 0 do
    begin
        Index := List.GetValue(n);
        NewArray.Indexs.Add(m);
        Index := ThisArray.Indexs.IndexOf(Index);
        NewArray.Datas[m] := ThisArray.Datas[Index];
        m := m + 1;
    end;

    List.Free;
    ThisArray.Count := 0;
    ThisArray.Free;
    This.Arrays := NewArray;
    VarCopy(This, Result, This.Server);
end;

function TJaArray.shift(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := nil;

    if This.Arrays.Count = 0 then
        Result := MakeUndefined(This.Server)
    else
        VarCopy(This.Arrays.Datas[0], Result, This.Server);
end;

function TJaArray.slice(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    Start : Integer;
    Ends : Integer;
    NaN : Boolean;
    n : Integer;
    m : Integer;
    Count : Integer;
begin
    m := 0;
    Count := 0;
    Ends := 0;
    Start := ForceInt(args[0], NaN);
    Result := This.Server.PrepareInstance('Array');
    if NaN then Exit;

    if High(args) = 0 then
    begin
        Count := This.Arrays.Count - Start;
        Ends := This.Arrays.Count - 1;
    end
    else if High(args) = 1 then
    begin
        Ends := ForceInt(args[1], NaN);
        if NaN then Exit;
        if Ends >= This.Arrays.Count then
            Ends := This.Arrays.Count - 1
        else if Ends < 0 then
            Ends := This.Arrays.Count - Ends - 1;

        Count := Ends - Start + 1;
    end;

    if Count < 0 then Exit;
    SetLength(Result.Arrays.Datas, Count);

    for n := Start to Ends do
    begin
        VarCopy(This.Arrays.Datas[n], Result.Arrays.Datas[m], This.Server);
        This.Arrays.Indexs.Add(n);
        m := m + 1;
    end;

    Result.Arrays.Count := Count;
end;

function TJaArray.splice(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
end;

function TJaArray.toString(args : array of TVirtualObject ; This : TVirtualObject
                                ; Error : TErrors) : TVirtualObject;
var
    temp : String;
    n : Integer;
begin
    temp := '';

    for n := 0 to This.Arrays.Count - 1 do
    begin
        if temp <> '' then
            temp := temp + ',';

        temp := temp + ForceString(This.Arrays.Datas[n]);
    end;

    Result := MakeString(temp, This.Server);
end;

function TJaArray.unshift(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
end;

//******************************************************************************
//TJaMath

constructor TJaMath.Create;
begin
    inherited Create;
    ClassName := 'Math';

    //\bh̒ǉ
    AddFunction('abs', abs, 1);
    AddFunction('acos', acos, 1);
    AddFunction('asin', asin, 1);
    AddFunction('atan', atan, 1);
    AddFunction('atan2', atan2, 2);
    AddFunction('ceil', ceil, 1);
    AddFunction('cos', cos, 1);
    AddFunction('exp', exp, 2);
    AddFunction('floor', floor, 1);
    AddFunction('log', log, 1);
    AddFunction('max', max, 2);
    AddFunction('min', min, 2);
    AddFunction('pow', pow, 2);
    AddFunction('random', random, 0);
    AddFunction('round', round, 1);
    AddFunction('sin', sin, 1);
    AddFunction('sqrt', sqrt, 1);
    AddFunction('tan', tan, 1);

    //vpeB̒ǉ
    AddProperty('E', E);
    AddProperty('LN10', LN10);
    AddProperty('LOG10E', LOG10E);
    AddProperty('LOG2E', LOG2E);
    AddProperty('PI', PI);
    AddProperty('SQRT1_2', SQRT1_2);
    AddProperty('SQRT2', SQRT2);
end;

destructor TJaMath.Destroy;
begin
    inherited Destroy;
end;

function TJaMath.abs(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := nil;

    if args[0].Reference = nil then
    begin
        Result := MakeUndefined(This.Server);
        Exit;
    end;

    if args[0].Reference.ClassName = 'Number' then
    begin
        case args[0].ValueType of
            nmInt:
                Result := MakeInt(System.Abs(args[0].Int_Data), This.Server);

            nmFloat:
                Result := MakeFloat(System.Abs(args[0].Float_Data), This.Server);
        end;
    end
    else if args[0].Reference.ClassName = 'Boolean' then
    begin
        Result := MakeInt(System.Abs(args[0].Int_Data), This.Server);
    end;

    if Result = nil then
        Result := MakeUndefined(This.Server);
end;

function TJaMath.acos(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := nil;

    if args[0].Reference = nil then
    begin
        Result := MakeUndefined(This.Server);
        Exit;
    end;

    if args[0].Reference.ClassName = 'Number' then
    begin
        case args[0].ValueType of
            nmInt:
                Result := MakeFloat(tn_math.ArcCos(args[0].Int_Data), This.Server);

            nmFloat:
                Result := MakeFloat(tn_math.ArcCos(args[0].Float_Data), This.Server);
        end;
    end
    else if args[0].Reference.ClassName = 'Boolean' then
    begin
        Result := MakeFloat(tn_math.ArcCos(System.Abs(args[0].Int_Data)), This.Server);
    end;

    if Result = nil then
        Result := MakeUndefined(This.Server);
end;

function TJaMath.asin(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := nil;

    if args[0].Reference = nil then
    begin
        Result := MakeUndefined(This.Server);
        Exit;
    end;

    if args[0].Reference.ClassName = 'Number' then
    begin
        case args[0].ValueType of
            nmInt:
                Result := MakeFloat(tn_math.ArcSin(args[0].Int_Data), This.Server);

            nmFloat:
                Result := MakeFloat(tn_math.ArcSin(args[0].Float_Data), This.Server);
        end;
    end
    else if args[0].Reference.ClassName = 'Boolean' then
    begin
        Result := MakeFloat(tn_math.ArcSin(System.Abs(args[0].Int_Data)), This.Server);
    end;

    if Result = nil then
        Result := MakeUndefined(This.Server);
end;

function TJaMath.atan(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := nil;

    if args[0].Reference = nil then
    begin
        Result := MakeUndefined(This.Server);
        Exit;
    end;

    if args[0].Reference.ClassName = 'Number' then
    begin
        case args[0].ValueType of
            nmInt:
                Result := MakeFloat(System.ArcTan(args[0].Int_Data), This.Server);

            nmFloat:
                Result := MakeFloat(System.ArcTan(args[0].Float_Data), This.Server);
        end;
    end
    else if args[0].Reference.ClassName = 'Boolean' then
    begin
        Result := MakeFloat(System.ArcTan(System.Abs(args[0].Int_Data)), This.Server);
    end;

    if Result = nil then
        Result := MakeUndefined(This.Server);
end;

function TJaMath.atan2(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x, y : Double;
    NaN : Boolean;
    NaN2 : Boolean;
begin
    x := ForceDouble(args[1], NaN);
    y := ForceDouble(args[0], NaN2);

    if (x <> 0) and (not NaN) and (not NaN2) then
        Result := MakeFloat(tn_math.ArcTan2(y, x), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.ceil(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := nil;

    if args[0].Reference = nil then
    begin
        Result := MakeUndefined(This.Server);
        Exit;
    end;

    if args[0].Reference.ClassName = 'Number' then
    begin
        case args[0].ValueType of
            nmInt:
                Result := MakeInt(tn_math.Ceil(args[0].Int_Data), This.Server);

            nmFloat:
                Result := MakeInt(tn_math.Ceil(args[0].Float_Data), This.Server);
        end;
    end
    else if args[0].Reference.ClassName = 'Boolean' then
    begin
        Result := MakeInt(tn_math.Ceil(System.Abs(args[0].Int_Data)), This.Server);
    end;

    if Result = nil then
        Result := MakeUndefined(This.Server);
end;

function TJaMath.cos(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x : Double;
    NaN : Boolean;
begin
    x := ForceDouble(args[0], NaN);

    if not NaN then
        Result := MakeFloat(System.Cos(x), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.exp(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x : Double;
    NaN : Boolean;
begin
    x := ForceDouble(args[0], NaN);

    if not NaN then
        Result := MakeFloat(System.Exp(x), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.floor(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x : Double;
    NaN : Boolean;
begin
    x := ForceDouble(args[0], NaN);

    if not NaN then
        Result := MakeFloat(tn_math.Floor(x), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.log(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x : Double;
    NaN : Boolean;
begin
    x := ForceDouble(args[0], NaN);

    if not NaN then
        Result := MakeFloat(Ln(x), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.max(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x, y : Double;
    NaN : Boolean;
    NaN2 : Boolean;
begin
    x := ForceDouble(args[0], NaN);
    y := ForceDouble(args[1], NaN2);

    if (not NaN) and (not NaN2) then
        Result := MakeFloat(tn_math.Max(x, y), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.min(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x, y : Double;
    NaN : Boolean;
    NaN2 : Boolean;
begin
    x := ForceDouble(args[0], NaN);
    y := ForceDouble(args[1], NaN2);

    if (not NaN) and (not NaN2) then
        Result := MakeFloat(tn_math.Min(x, y), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.pow(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x, y : Double;
    NaN : Boolean;
    NaN2 : Boolean;
begin
    x := ForceDouble(args[0], NaN);
    y := ForceDouble(args[1], NaN2);

    if (not NaN) and (not NaN2) then
        Result := MakeFloat(tn_math.Power(x, y), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.random(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeFloat(System.Random, This.Server)
end;

function TJaMath.round(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := nil;

    if args[0].Reference = nil then
    begin
        Result := MakeUndefined(This.Server);
        Exit;
    end;

    if args[0].Reference.ClassName = 'Number' then
    begin
        case args[0].ValueType of
            nmInt:
                Result := MakeInt(Trunc(args[0].Int_Data), This.Server);

            nmFloat:
                Result := MakeInt(Trunc(args[0].Float_Data), This.Server);
        end;
    end
    else if args[0].Reference.ClassName = 'Boolean' then
    begin
        Result := MakeInt(Trunc(System.Abs(args[0].Int_Data)), This.Server);
    end;

    if Result = nil then
        Result := MakeUndefined(This.Server);
end;

function TJaMath.sin(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x : Double;
    NaN : Boolean;
begin
    x := ForceDouble(args[0], NaN);

    if not NaN then
        Result := MakeFloat(System.Sin(x), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.sqrt(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x : Double;
    NaN : Boolean;
begin
    x := ForceDouble(args[0], NaN);

    if not NaN then
        Result := MakeFloat(System.Sqrt(x), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.tan(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    x : Double;
    NaN : Boolean;
begin
    x := ForceDouble(args[0], NaN);

    if not NaN then
        Result := MakeFloat(tn_math.Tan(x), This.Server)
    else
        Result := MakeUndefined(This.Server);
end;

function TJaMath.E(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeFloat(2.718281828459045, This.Server)
end;

function TJaMath.LN10(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeFloat(2.302585092994046, This.Server)
end;

function TJaMath.LOG2E(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeFloat(1.4426950408889633, This.Server)
end;

function TJaMath.LOG10E(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeFloat(0.4342944819032518, This.Server)
end;

function TJaMath.PI(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeFloat(3.141592653589793, This.Server)
end;

function TJaMath.SQRT1_2(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeFloat(0.7071067811865476, This.Server)
end;

function TJaMath.SQRT2(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeFloat(1.4142135623730951, This.Server)
end;

//******************************************************************************
//TJaData -> Data

constructor TJaDate.Create;
begin
    inherited Create;
    ClassName := 'Date';

    //RXgN^
    AddFunction('Date', Construct, 0);

    //\bh̒ǉ
    AddFunction('getDate', getDate, 0);
    AddFunction('getDay', getDay, 0);
    AddFunction('getFullYear', getFullYear, 0);
    AddFunction('getHours', getHours, 0);
    AddFunction('getMilliSeconds', getMilliSeconds, 0);
    AddFunction('getMinutes', getMinutes, 0);
    AddFunction('getMonth', getMonth, 0);
    AddFunction('getSeconds', getSeconds, 0);
    AddFunction('getTime', getTime, 0);
    AddFunction('getTimeZoneOffset', getTimeZoneOffset, 0);
    AddFunction('getUTCDate', getUTCDate, 0);
    AddFunction('getUTCDay', getUTCDay, 0);
    AddFunction('getUTCFullYear', getUTCFullYear, 0);
    AddFunction('getUTCHours', getUTCHours, 0);
    AddFunction('getUTCMilliSeconds', getUTCMilliSeconds, 0);
    AddFunction('getUTCMinutes', getUTCMinutes, 0);
    AddFunction('getUTCMonth', getUTCMonth, 0);
    AddFunction('getUTCSeconds', getUTCSeconds, 0);
    AddFunction('getVarDate', getVarDate, 0);
    AddFunction('getYear', getYear, 0);
    AddFunction('parse', parse, 0);
    AddFunction('setDate', setDate, 1);
    AddFunction('setFullYear', setFullYear, 1);
    AddFunction('setHours', setHours, 1);
    AddFunction('setMilliSeconds', setMilliSeconds, 1);
    AddFunction('setMinutes', setMinutes, 1);
    AddFunction('setMonth', setMonth, 1);
    AddFunction('setSeconds', setSeconds, 1);
    AddFunction('setTime', setTime, 1);
    AddFunction('setUTCDate', setUTCDate, 1);
    AddFunction('setUTCFullYear', setUTCFullYear, 1);
    AddFunction('setUTCHours', setUTCHours, 1);
    AddFunction('setUTCMilliSeconds', setUTCMilliSeconds, 1);
    AddFunction('setUTCMinutes', setUTCMinutes, 1);
    AddFunction('setUTCMonth', setUTCMonth, 1);
    AddFunction('setUTCSeconds', setUTCSeconds, 1);
    AddFunction('setYear', setYear, 1);
    AddFunction('toGMTString', toGMTString, 0);
    AddFunction('toLocaleString', toLocaleString, 0);
    AddFunction('toUTCString', toUTCString, 0);
    AddFunction('UTC', UTC, 3);
end;

destructor TJaDate.Destroy;
begin
    inherited Destroy;
end;

function TJaDate.toString(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(EncodeGMTString(This.Float_Data, TimeZone), This.Server);
end;

function TJaDate.Construct(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year : Integer;
    mon : Integer;
    day : Integer;
    hour : Integer;
    min : Integer;
    sec : Integer;
    msec : Integer;
    NaN : Boolean;
begin
    This.Float_Data := NowDateTime;
    hour := 0;
    min := 0;
    sec := 0;
    msec := 0;

    if High(args) >= 2 then
    begin
        year := ForceInt(args[0], NaN);
        mon := ForceInt(args[1], NaN);
        day := ForceInt(args[2], NaN);

        case High(args) of
            3:
                begin
                    hour := ForceInt(args[3], NaN);
                end;
            4:
                begin
                    hour := ForceInt(args[3], NaN);
                    min := ForceInt(args[4], NaN);
                end;
            5:
                begin
                    hour := ForceInt(args[3], NaN);
                    min := ForceInt(args[4], NaN);
                    sec := ForceInt(args[5], NaN);
                end;
            6:
                begin
                    hour := ForceInt(args[3], NaN);
                    min := ForceInt(args[4], NaN);
                    sec := ForceInt(args[5], NaN);
                    msec := ForceInt(args[6], NaN);
                end;
        end;

        This.Float_Data := EncodeDateTime(year, mon, day, hour, min, sec, msec);
    end
    else if High(args) = 0 then
        This.Float_Data := ForceDouble(args[0], NaN) / 24 * 60 * 60 * 1000;

    Result := MakeUndefined(This.Server);
end;

function TJaDate.getDate(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
begin
    DecodeDate(This.Float_Data, year, month, day);
    Result := MakeInt(day, This.Server);
end;

function TJaDate.getDay(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeInt(GetDayOfWeek(This.Float_Data), This.Server);
end;

function TJaDate.getFullYear(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
begin
    DecodeDate(This.Float_Data, year, month, day);
    Result := MakeInt(year, This.Server);
end;

function TJaDate.getHours(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msecond : Integer;
begin
    DecodeTime(This.Float_Data, hour, minute, second, msecond);
    Result := MakeInt(hour, This.Server);
end;

function TJaDate.getMilliseconds(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msecond : Integer;
begin
    DecodeTime(This.Float_Data, hour, minute, second, msecond);
    Result := MakeInt(msecond, This.Server);
end;

function TJaDate.getMinutes(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msecond : Integer;
begin
    DecodeTime(This.Float_Data, hour, minute, second, msecond);
    Result := MakeInt(minute, This.Server);
end;

function TJaDate.getMonth(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
begin
    DecodeDate(This.Float_Data, year, month, day);
    Result := MakeInt(month, This.Server);
end;

function TJaDate.getSeconds(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msecond : Integer;
begin
    DecodeTime(This.Float_Data, hour, minute, second, msecond);
    Result := MakeInt(second, This.Server);
end;

function TJaDate.getTime(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeFloat(DateTimeToJagaDate(JagaTimeAdjust(This.Float_Data)) ,This.Server);
end;

function TJaDate.getTimeZoneOffset(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    TZ : TDateTime;
    hour, minute, second, msecond : Integer;
begin
    TZ := TimeZone;
    DecodeTime(TZ, hour, minute, second, msecond);
    Result := MakeFloat(DateTimeToJagaDate(TZ), This.Server);
end;

function TJaDate.getUTCDate(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
    UTCTime : TDateTime;
begin
    UTCTime := JagaTimeAdjust(This.Float_Data);
    DecodeDate(UTCTime, year, month, day);
    Result := MakeInt(day, This.Server);
end;

function TJaDate.getUTCDay(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    UTCTime : TDateTime;
begin
    UTCTime := JagaTimeAdjust(This.Float_Data);
    Result := MakeInt(GetDayOfWeek(UTCTime), This.Server);
end;

function TJaDate.getUTCFullYear(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
    UTCTime : TDateTime;
begin
    UTCTime := JagaTimeAdjust(This.Float_Data);
    DecodeDate(UTCTime, year, month, day);
    Result := MakeInt(year, This.Server);
end;

function TJaDate.getUTCHours(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msecond : Integer;
    UTCTime : TDateTime;
begin
    UTCTime := JagaTimeAdjust(This.Float_Data);
    DecodeTime(UTCTime, hour, minute, second, msecond);
    Result := MakeInt(hour, This.Server);
end;

function TJaDate.getUTCMilliSeconds(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msecond : Integer;
    UTCTime : TDateTime;
begin
    UTCTime := JagaTimeAdjust(This.Float_Data);
    DecodeTime(UTCTime, hour, minute, second, msecond);
    Result := MakeInt(msecond, This.Server);
end;

function TJaDate.getUTCMinutes(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msecond : Integer;
    UTCTime : TDateTime;
begin
    UTCTime := JagaTimeAdjust(This.Float_Data);
    DecodeTime(UTCTime, hour, minute, second, msecond);
    Result := MakeInt(minute, This.Server);
end;

function TJaDate.getUTCMonth(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
    UTCTime : TDateTime;
begin
    UTCTime := JagaTimeAdjust(This.Float_Data);
    DecodeDate(UTCTime, year, month, day);
    Result := MakeInt(month, This.Server);
end;

function TJaDate.getUTCSeconds(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msecond : Integer;
    UTCTime : TDateTime;
begin
    UTCTime := JagaTimeAdjust(This.Float_Data);
    DecodeTime(UTCTime, hour, minute, second, msecond);
    Result := MakeInt(second, This.Server);
end;

function TJaDate.getVarDate(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeFloat(This.Float_Data, This.Server);
end;

function TJaDate.getYear(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
begin
    DecodeDate(This.Float_Data, year, month, day);
    Result := MakeInt(year, This.Server);
end;

function TJaDate.setDate(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
    Value : Integer;
    NaN : Boolean;
begin
    Value := ForceInt(args[0], NaN);
    if Value = 0 then Exit;
    DecodeDate(This.Float_Data, year, month, day);
    This.Float_Data := EncodeDate(year, month, Value)
                        + This.Float_Data - Trunc(This.Float_Data);
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setFullYear(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
    Value, Value2, Value3 : Integer;
    NaN : Boolean;
begin
    DecodeDate(This.Float_Data, year, month, day);
    Value := ForceInt(args[0], NaN);

    case High(args) of
        1:
            begin
                Value2 := ForceInt(args[1], NaN);
                Value3 := day;
            end;
        2:
            begin
                Value2 := ForceInt(args[1], NaN);
                Value3 := ForceInt(args[2], NaN);
            end;

        else
            begin
                Value2 := month;
                Value3 := day;
            end;
    end;

    This.Float_Data := EncodeDate(Value, Value2, Value3)
                        + This.Float_Data - Trunc(This.Float_Data);
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setHours(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msec : Integer;
    Value, Value2, Value3, Value4 : Integer;
    NaN : Boolean;
begin
    DecodeTime(This.Float_Data, hour, minute, second, msec);
    Value := ForceInt(args[0], NaN);

    case High(args) of
        1:
            begin
                Value2 := ForceInt(args[1], NaN);
                Value3 := second;
                Value4 := msec;
            end;
        2:
            begin
                Value2 := ForceInt(args[1], NaN);
                Value3 := ForceInt(args[2], NaN);
                Value4 := msec;
            end;

        3:
            begin
                Value2 := ForceInt(args[1], NaN);
                Value3 := ForceInt(args[2], NaN);
                Value4 := ForceInt(args[3], NaN);
            end;

        else
            begin
                Value2 := minute;
                Value3 := second;
                Value4 := msec;
            end;
    end;

    This.Float_Data := Trunc(This.Float_Data)
                        + EncodeTime(Value, Value2, Value3, Value4);
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setMilliseconds(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msec : Integer;
    Value : Integer;
    NaN : Boolean;
begin
    Value := ForceInt(args[0], NaN);
    if Value = 0 then Exit;
    DecodeTime(This.Float_Data, hour, minute, second, msec);
    This.Float_Data := Trunc(This.Float_Data)
                            + EncodeTime(hour, minute, second, Value);
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setMinutes(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msec : Integer;
    Value, Value2, Value3 : Integer;
    NaN : Boolean;
begin
    DecodeTime(This.Float_Data, hour, minute, second, msec);

    case High(args) of
        1:
            begin
                Value := ForceInt(args[0], NaN);
                Value2 := ForceInt(args[1], NaN);
                Value3 := msec;
            end;
        2:
            begin
                Value := ForceInt(args[0], NaN);
                Value2 := ForceInt(args[1], NaN);
                Value3 := ForceInt(args[2], NaN);
            end;

        else
            begin
                Value := ForceInt(args[0], NaN);
                Value2 := second;
                Value3 := msec;
            end;
    end;

    This.Float_Data := Trunc(This.Float_Data)
                            + EncodeTime(hour, Value, Value2, Value3);
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setMonth(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
    Value, Value2 : Integer;
    NaN : Boolean;
begin
    DecodeDate(This.Float_Data, year, month, day);

    case High(args) of
        1:
            begin
                Value := ForceInt(args[0], NaN);
                Value2 := ForceInt(args[1], NaN);
            end;

        else
            begin
                Value := ForceInt(args[0], NaN);
                Value2 := day;
            end;
    end;


    This.Float_Data := EncodeDate(year, Value, Value2)
                            + This.Float_Data - Trunc(This.Float_Data);
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setSeconds(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msec : Integer;
    Value , Value2 : Integer;
    NaN : Boolean;
begin
    Value := ForceInt(args[0], NaN);
    if Value = 0 then Exit;
    DecodeTime(This.Float_Data, hour, minute, second, msec);

    if High(args) = 1 then
        Value2 := ForceInt(args[1], NaN)
    else
        Value2 := msec;

    This.Float_Data := Trunc(This.Float_Data)
                        + EncodeTime(hour, minute, Value, Value2);
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setTime(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    Value : Integer;
    NaN : Boolean;
    UTCTime : TDateTime;
begin
    Value := ForceInt(args[0], NaN);
    UTCTime := JagaDateToDateTime(Value);
    This.Float_Data := UTCTime + TimeZone;
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setUTCDate(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
    Value : Integer;
    NaN : Boolean;
    UTCTime : TDateTime;
begin
    UTCTime := This.Float_Data - TimeZone;
    DecodeDate(UTCTime, year, month, day);
    Value := ForceInt(args[0], NaN);
    This.Float_Data := EncodeDate(year, month, Value)
                        + This.Float_Data - Trunc(This.Float_Data)
                        + TimeZone;
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setUTCFullYear(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
    Value, Value2, Value3 : Integer;
    NaN : Boolean;
    UTCTime : TDateTime;
begin
    UTCTime := This.Float_Data - TimeZone;
    DecodeDate(UTCTime, year, month, day);
    Value := ForceInt(args[0], NaN);

    case High(args) of
        1:
            begin
                Value2 := ForceInt(args[1], NaN);
                Value3 := day;
            end;
        2:
            begin
                Value2 := ForceInt(args[1], NaN);
                Value3 := ForceInt(args[2], NaN);
            end;

        else
            begin
                Value2 := month;
                Value3 := day;
            end;
    end;

    This.Float_Data := EncodeDate(Value, Value2, Value3)
                        + This.Float_Data - Trunc(This.Float_Data)
                        + TimeZone;
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setUTCHours(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msec : Integer;
    Value, Value2, Value3, Value4 : Integer;
    NaN : Boolean;
    UTCTime : TDateTime;
begin
    UTCTime := This.Float_Data - TimeZone;
    DecodeTime(UTCTime, hour, minute, second, msec);
    Value := ForceInt(args[0], NaN);

    case High(args) of
        1:
            begin
                Value2 := ForceInt(args[1], NaN);
                Value3 := second;
                Value4 := msec;
            end;
        2:
            begin
                Value2 := ForceInt(args[1], NaN);
                Value3 := ForceInt(args[2], NaN);
                Value4 := msec;
            end;

        3:
            begin
                Value2 := ForceInt(args[1], NaN);
                Value3 := ForceInt(args[2], NaN);
                Value4 := ForceInt(args[3], NaN);
            end;

        else
            begin
                Value2 := minute;
                Value3 := second;
                Value4 := msec;
            end;
    end;

    This.Float_Data := Trunc(This.Float_Data)
                        + EncodeTime(Value, Value2, Value3, Value4)
                        + TimeZone;
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setUTCMilliSeconds(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msec : Integer;
    Value : Integer;
    NaN : Boolean;
    UTCTime : TDateTime;
begin
    UTCTime := This.Float_Data - TimeZone;
    DecodeTime(UTCTime, hour, minute, second, msec);
    Value := ForceInt(args[0], NaN);
    This.Float_Data := Trunc(This.Float_Data)
                            + EncodeTime(hour, minute, second, Value)
                            + TimeZone;
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setUTCMinutes(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msec : Integer;
    Value, Value2, Value3 : Integer;
    NaN : Boolean;
    UTCTime : TDateTime;
begin
    UTCTime := This.Float_Data - TimeZone;
    DecodeTime(UTCTime, hour, minute, second, msec);

    case High(args) of
        1:
            begin
                Value := ForceInt(args[0], NaN);
                Value2 := ForceInt(args[1], NaN);
                Value3 := msec;
            end;
        2:
            begin
                Value := ForceInt(args[0], NaN);
                Value2 := ForceInt(args[1], NaN);
                Value3 := ForceInt(args[2], NaN);
            end;

        else
            begin
                Value := ForceInt(args[0], NaN);
                Value2 := second;
                Value3 := msec;
            end;
    end;

    This.Float_Data := Trunc(This.Float_Data)
                            + EncodeTime(hour, Value, Value2, Value3)
                            + TimeZone;
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setUTCMonth(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
    Value, Value2 : Integer;
    NaN : Boolean;
    UTCTime : TDateTime;
begin
    UTCTime := This.Float_Data - TimeZone;
    DecodeDate(UTCTime, year, month, day);

    case High(args) of
        1:
            begin
                Value := ForceInt(args[0], NaN);
                Value2 := ForceInt(args[1], NaN);
            end;

        else
            begin
                Value := ForceInt(args[0], NaN);
                Value2 := day;
            end;
    end;


    This.Float_Data := EncodeDate(year, Value, Value2)
                            + This.Float_Data - Trunc(This.Float_Data)
                            + TimeZone;
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setUTCSeconds(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    hour, minute, second, msec : Integer;
    Value , Value2 : Integer;
    NaN : Boolean;
    UTCTime : TDateTime;
begin
    UTCTime := This.Float_Data - TimeZone;
    DecodeTime(UTCTime, hour, minute, second, msec);
    Value := ForceInt(args[0], NaN);

    if High(args) = 1 then
        Value2 := ForceInt(args[1], NaN)
    else
        Value2 := msec;

    This.Float_Data := Trunc(This.Float_Data)
                        + EncodeTime(hour, minute, Value, Value2)
                        +TimeZone;
    VarCopy(This, Result, This.Server);
end;

function TJaDate.setYear(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, month, day : Integer;
    Value : Integer;
    NaN : Boolean;
begin
    DecodeDate(This.Float_Data, year, month, day);
    Value := ForceInt(args[0], NaN);

    if (Value >= 0) and (Value <= 99) then
        Value := Value + 1900;

    This.Float_Data := EncodeDate(Value, month, day)
                        + This.Float_Data - Trunc(This.Float_Data);
    VarCopy(This, Result, This.Server);
end;

function TJaDate.toGMTString(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    UTCTime : TDateTime;
begin
    UTCTime := This.Float_Data - TimeZone;
    Result := MakeString(EncodeGMTString(UTCTime, 0), This.Server);
end;

function TJaDate.toLocaleString(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(DateTimeToStr(This.Float_Data), This.Server);
end;

function TJaDate.toUTCString(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    UTCTime : TDateTime;
    temp : String;
begin
    UTCTime := This.Float_Data - TimeZone;
    temp := Replace(EncodeGMTString(UTCTime, 0), 'GMT', 'UTC');
    Result := MakeString(temp, This.Server);
end;

function TJaDate.parse(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    Time : TDateTime;
begin
    Time := DecodeGMTString(ForceString(args[0]));
    Result := MakeFloat(Time, This.Server);
end;

function TJaDate.UTC(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    year, mon, day, hour, min, sec, msec : Integer;
    NaN : Boolean;
    UTCTime : TDateTime;
begin
    year := ForceInt(args[0], NaN);
    mon := ForceInt(args[1], NaN);
    day := ForceInt(args[2], NaN);

    case High(args) of
        3:
            begin
                hour := ForceInt(args[3], NaN);
                min := 0;
                sec := 0;
                msec := 0;
            end;

        4:
            begin
                hour := ForceInt(args[3], NaN);
                min := ForceInt(args[4], NaN);
                sec := 0;
                msec := 0;
            end;

        5:
            begin
                hour := ForceInt(args[3], NaN);
                min := ForceInt(args[4], NaN);
                sec := ForceInt(args[5], NaN);
                msec := 0;
            end;

        6:
            begin
                hour := ForceInt(args[3], NaN);
                min := ForceInt(args[4], NaN);
                sec := ForceInt(args[5], NaN);
                msec := ForceInt(args[6], NaN);
            end;

        else
            begin
                hour := 0;
                min := 0;
                sec := 0;
                msec := 0;
            end;
    end;

    UTCTime := EncodeDateTime(year, mon, day, hour, min, sec, msec);
    Result := MakeFloat(DateTimeToJagaDate(UTCTime), This.Server);
end;

//******************************************************************************
//TJaUndefined -> Undefined

constructor TJaUndefined.Create;
begin
    inherited Create;
    ClassName := 'Undefined';
end;

//******************************************************************************
//TVirtualObject

constructor TVirtualObject.Create(ObjectServer : TObjectServer);
begin
    Variants := TVariantList.Create(ObjectServer);
    Arrays := TArray.Create(ObjectServer);
    Reference := nil;
    Server := ObjectServer;
    Int_Data := 0;
    Float_Data := 0;
    Str_Data := '';
    ValueType := nmNaN;
    SetLength(Includes, 0);
    Include_Count := 0;
    UseCount := 1;
end;

destructor TVirtualObject.Destroy;
begin
    {$IFDEF DEBUG}
        (*
        if Reference = nil then
            WriteLn('Destroy : Undefined')
        else
            WriteLn('Destroy: ' + Reference.ClassName);
        *)
        //WriteLn(IntToStr(Server.DustBox.Count));
    {$ENDIF}

    Variants.Free;
    Arrays.Free;
    inherited Destroy;
end;

procedure TVirtualObject.Free;
var
    Index : Integer;
begin
    System.Dec(UseCount);

    Index := Server.DustBox.IndexOf(Integer(Pointer(Self)));
    if Index = -1 then
    begin
        Exit;
    end;

    if UseCount = 0 then
    begin
        //UseCount0̂Ƃ
        if Reference <> nil then
        begin
            //fXgN^Ăяo
            Reference.FreeObject(Self);
        end;

        //_Xg{bNX폜
        Index := Server.DustBox.IndexOf(Integer(Pointer(Self)));
        if Index <> -1 then Server.DustBox.Delete(Index);

        inherited Free;
    end;
end;

procedure TVirtualObject.Inc;
begin
    if Reference = nil then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'Number' then
    begin
        if ValueType = nmInt then
            Int_Data := Int_Data + 1
        else if ValueType = nmFloat then
            Float_Data := Float_Data + 1;
    end
    else if Reference.ClassName = 'Boolean' then
    begin
        Int_Data := Abs(Int_Data);
        Int_Data := Int_Data + 1;
        ValueType := nmInt;
        Reference := Server.GetClass('Number');
    end
    else
    begin
        Reference := Server.GetClass('Number');
        ValueType := nmNaN;
    end;
end;

procedure TVirtualObject.Dec;
begin
    if Reference = nil then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'Number' then
    begin
        if ValueType = nmInt then
            Int_Data := Int_Data - 1
        else if ValueType = nmFloat then
            Float_Data := Float_Data - 1;
    end
    else if Reference.ClassName = 'Boolean' then
    begin
        Int_Data := Abs(Int_Data);
        Int_Data := Int_Data - 1;
        ValueType := nmInt;
        Reference := Server.GetClass('Number');
    end
    else
    begin
        Reference := Server.GetClass('Number');
        ValueType := nmNaN;
    end;
end;

procedure TVirtualObject.BAnd(Dest : TVirtualObject);
begin
    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'Number' then
    begin
        case ValueType of
            nmInt:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    if Int_Data > Dest.Int_Data then
                                        Int_Data := Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Float_Data := Dest.Float_Data;
                                    ValueType := nmFloat;
                                end;

                            nmNaN:
                                begin
                                    if Int_Data <> 0 then
                                        ValueType := nmNaN;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        if Int_Data <> 0 then
                        begin
                            Int_Data := Dest.Int_Data;
                            Reference := Server.GetClass('Boolean');
                        end;
                    end
                    else if Dest.Reference.ClassName = 'String' then
                    begin
                        Reference := Server.GetClass('String');
                        Str_Data := Dest.Str_Data;
                    end;
                end;

            nmFloat:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Int_Data := Dest.Int_Data;
                                    ValueType := nmInt;
                                end;

                            nmFloat:
                                begin
                                    Float_Data := Dest.Float_Data;
                                end;

                            nmNaN:
                                begin
                                    if Float_Data <> 0 then
                                        ValueType := nmNaN;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        if Float_Data <> 0 then
                        begin
                            Int_Data := Dest.Int_Data;
                            Reference := Server.GetClass('Boolean');
                        end
                        else
                        begin
                            Int_Data := 0;
                            ValueType := nmInt;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'String' then
                    begin
                        Reference := Server.GetClass('String');
                        Str_Data := Dest.Str_Data;
                    end;
                end;
        end;
    end
    else if Reference.ClassName = 'Boolean' then
    begin
        if Dest.Reference.ClassName = 'Number' then
        begin
            case Dest.ValueType of
                nmInt, nmFloat:
                    begin
                        if BOOL(Int_Data) then
                        begin
                            Int_Data := Dest.Int_Data;
                            ValueType := Dest.ValueType;
                        end
                    end;

                    nmNaN:
                        begin
                            if Int_Data <> 0 then
                                ValueType := nmNaN;
                        end;
            end;
        end
        else if Dest.Reference.ClassName = 'Boolean' then
        begin
            Reference := Server.GetClass('Boolean');
            Int_Data := Integer(BOOL(Int_Data) and BOOL(Dest.Int_Data));
        end
        else if Dest.Reference.ClassName = 'String' then
        begin
            Reference := Server.GetClass('String');
            Str_Data := Dest.Str_Data;
        end;

    end
    else if Reference.ClassName = 'String' then
    begin
        Reference := Server.GetClass('String');
        Str_Data := Dest.Str_Data;
    end;
end;

procedure TVirtualObject.BOr(Dest : TVirtualObject);
begin
    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'Number' then
    begin
        case ValueType of
            nmInt:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    if Int_Data < Dest.Int_Data then
                                        Int_Data := Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    if Int_Data = 0 then
                                    begin
                                        Float_Data := Dest.Float_Data;
                                        ValueType := nmFloat;
                                    end;
                                end;

                            nmNaN:
                                begin
                                    if Int_Data = 0 then
                                        ValueType := nmNaN;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        if Int_Data = 0 then
                        begin
                            Int_Data := Dest.Int_Data;
                            Reference := Server.GetClass('Boolean');
                        end;
                    end
                    else if Dest.Reference.ClassName = 'String' then
                    begin
                        Reference := Server.GetClass('String');
                        Str_Data := Dest.Str_Data;
                    end;
                end;
        end;
    end
    else if Reference.ClassName = 'Boolean' then
    begin
        if (Dest.Reference.ClassName = 'Number') and (not BOOL(Int_Data)) then
        begin
            case Dest.ValueType of
                nmInt, nmFloat:
                    begin
                        Int_Data := Dest.Int_Data;
                        Float_Data := Dest.Float_Data;
                        ValueType := Dest.ValueType;
                    end;

                nmNaN:
                    begin
                        ValueType := nmNaN;
                    end;
            end;
        end
        else if Dest.Reference.ClassName = 'Boolean' then
        begin
            Reference := Server.GetClass('Boolean');
            //Int_Data := Integer(BOOL(Dest.Int_Data));
            Int_Data := Integer(BOOL(Int_Data) or BOOL(Dest.Int_Data));
        end
        else if Dest.Reference.ClassName = 'String' then
        begin
            Reference := Server.GetClass('String');
            Str_Data := Dest.Str_Data;
        end;
    end;
end;

procedure TVirtualObject.BNot;
begin
    if Reference = nil then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'Number' then
    begin
        case ValueType of
            nmInt:
                begin
                    Int_Data := Integer(Int_Data = 0);
                    Reference := Server.GetClass('Boolean');
                end;

            nmFloat:
                begin
                    Int_Data := Integer(Float_Data = 0);
                    Reference := Server.GetClass('Boolean');
                end;

        end;
    end
    else if Reference.ClassName = 'Boolean' then
    begin
        Int_Data := Integer(not BOOL(Int_Data));
    end
    else if Reference.ClassName = 'String' then
    begin
        Reference := Server.GetClass('Boolean');
        Int_Data := Integer(Length(Str_Data) = 0);
    end
    else
    begin
        Reference := Server.GetClass('Boolean');
        Int_Data := Integer(Length(Reference.ClassName) = 0);
    end;
end;

procedure TVirtualObject.BitAnd(Dest : TVirtualObject);
var
    Value : Integer;
    Code : Integer;
begin
    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.IsParent('String') then
    begin
        Val(Str_Data, Value, Code);

        if Code <> 0 then
            Int_Data := 0
        else
            Int_Data := Value;

        Reference := Server.GetClass('Number');
        ValueType := nmInt;
    end;

    if Reference.ClassName = 'Number' then
    begin
        case ValueType of
            nmInt:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Int_Data := Int_Data and Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Int_Data := Int_Data and
                                                Integer(Trunc(Dest.Float_Data));
                                end;

                            nmNaN:
                                begin
                                    Int_Data := 0;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        if not BOOL(Dest.Int_Data) then Int_Data := 0;
                    end
                    else if Dest.Reference.ClassName = 'String' then
                    begin
                        Val(Dest.Str_Data, Value, Code);

                        if Code <> 0 then
                            Int_Data := 0
                        else
                            Int_Data := Int_Data and Value;
                    end
                    else
                        Int_Data := 0;
                end;

            nmFloat:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Int_Data := Integer(Trunc(Float_Data))
                                                            and Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Int_Data := Integer(Trunc(Float_Data)) and
                                                Integer(Trunc(Dest.Float_Data));
                                end;

                            nmNaN:
                                begin
                                    Int_Data := 0;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        if not BOOL(Dest.Int_Data) then
                            Int_Data := 0
                        else
                            Int_Data := Integer(Trunc(Float_Data));
                    end
                    else if Dest.Reference.ClassName = 'String' then
                    begin
                        Val(Dest.Str_Data, Value, Code);

                        if Code <> 0 then
                            Int_Data := 0
                        else
                            Int_Data := Integer(Trunc(Float_Data)) and Value;
                    end
                    else
                        Int_Data := 0;

                    ValueType := nmInt;
                end;
        end;
    end
    else if Reference.ClassName = 'Boolean' then
    begin
        if BOOL(Int_Data) then
        begin
            if Dest.Reference.ClassName = 'Number' then
            begin
                case Dest.ValueType of
                    nmInt:
                        begin
                            Int_Data := Dest.Int_Data;
                        end;

                    nmFloat:
                        begin
                            Int_Data := Trunc(Dest.Float_Data);
                        end;

                    nmNaN:
                        begin
                            Int_Data := 0;
                        end;
                end;
            end
            else if Dest.Reference.ClassName = 'Boolean' then
            begin
                Int_Data := Abs(Integer(BOOL(Dest.Int_Data)));
            end
            else if Dest.Reference.ClassName = 'String' then
            begin
                Val(Dest.Str_Data, Value, Code);

                if Code <> 0 then
                    Int_Data := 0
                else
                    Int_Data := Value;
            end;
        end
        else
            Int_Data := 0;

        ValueType := nmInt;
    end
    else
    begin
        Int_Data := 0;
        ValueType := nmInt;
    end;
end;

procedure TVirtualObject.BitOr(Dest : TVirtualObject);
var
    Value : Integer;
    Code : Integer;
begin
    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'String' then
    begin
        Val(Str_Data, Value, Code);

        if Code <> 0 then
            Int_Data := 0
        else
            Int_Data := Value;

        Reference := Server.GetClass('Number');
        ValueType := nmInt;
    end;

    if Reference.ClassName = 'Boolean' then
    begin
        Int_Data := Abs(Int_Data);
        Reference := Server.GetClass('Number');
        ValueType := nmInt;
    end;

    if Reference.ClassName <> 'Number' then
    begin
        Int_Data := 0;
        Reference := Server.GetClass('Number');
        ValueType := nmInt;
    end;

    case ValueType of
        nmInt:
            begin
                if Dest.Reference.ClassName = 'Number' then
                begin
                    case Dest.ValueType of
                        nmInt:
                            begin
                                Int_Data := Int_Data or Dest.Int_Data;
                            end;

                        nmFloat:
                            begin
                                Int_Data := Int_Data or
                                                Integer(Trunc(Dest.Float_Data));
                            end;

                        nmNaN:
                            begin
                                if Int_Data = 0 then
                                    Int_Data := 0;
                            end;
                    end;
                end
                else if Dest.Reference.ClassName = 'Boolean' then
                begin
                    if Int_Data = 0 then
                        Int_Data := Dest.Int_Data;
                end
                else if Dest.Reference.ClassName = 'String' then
                begin
                    Val(Dest.Str_Data, Value, Code);

                    if Code <> 0 then
                        Int_Data := 0
                    else
                        Int_Data := Int_Data or Value;
                end
                else
                    Int_Data := 0;
            end;

        nmFloat:
            begin
                if Dest.Reference.ClassName = 'Number' then
                begin
                    case Dest.ValueType of
                        nmInt:
                            begin
                                Int_Data := Integer(Trunc(Float_Data))
                                                        or Dest.Int_Data;
                            end;

                        nmFloat:
                            begin
                                Int_Data := Integer(Trunc(Float_Data)) or
                                                Integer(Trunc(Dest.Float_Data));
                            end;
                    end;
                end
                else if Dest.Reference.ClassName = 'Boolean' then
                begin
                    Int_Data := Integer(Trunc(Float_Data)) or
                                    Integer(Abs(Integer(BOOL(Dest.Int_Data))));
                end
                else if Dest.Reference.ClassName = 'String' then
                begin
                    Val(Dest.Str_Data, Value, Code);

                    if Code = 0 then
                            Int_Data := Integer(Trunc(Float_Data)) or Value;
                end
                else
                    Int_Data := Integer(Trunc(Float_Data));

                ValueType := nmInt;
            end;
    end;
end;

procedure TVirtualObject.BitNot;
var
    Code : Integer;
    Value : Integer;
begin
    if Reference = nil then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'Number' then
    begin
        case ValueType of
            nmInt:
                begin
                    Int_Data := not Int_Data;
                end;

            nmFloat:
                begin
                    Int_Data := not Integer(Trunc(Float_Data));
                end;
        end;
    end
    else if Reference.ClassName = 'Boolean' then
    begin
        Int_Data := not Integer(Abs(Int_Data));
    end
    else if Reference.ClassName = 'String' then
    begin
        Val(Str_Data, Value, Code);

        if Code = 0 then
            Int_Data := not Value
        else
            Int_Data := 0;
    end
    else
        Int_Data := 0;

    ValueType := nmInt;
end;

procedure TVirtualObject.BitXor(Dest : TVirtualObject);
var
    Value : Integer;
    Code : Integer;
begin
    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'String' then
    begin
        Val(Str_Data, Value, Code);

        if Code <> 0 then
            Int_Data := 0
        else
            Int_Data := Value;

        Reference := Server.GetClass('Number');
        ValueType := nmInt;
    end;

    if Reference.ClassName = 'Number' then
    begin
        case ValueType of
            nmInt:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Int_Data := Int_Data xor Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Int_Data := Int_Data xor
                                                Integer(Trunc(Dest.Float_Data));
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        Int_Data := Int_Data xor Abs(Dest.Int_Data);
                    end
                    else if Dest.Reference.ClassName = 'String' then
                    begin
                        Val(Dest.Str_Data, Value, Code);

                        if Code <> 0 then
                            Int_Data := Int_Data xor 0
                        else
                            Int_Data := Int_Data xor Value;
                    end
                    else
                        Int_Data := Int_Data xor 0;
                end;

            nmFloat:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Int_Data := Integer(Trunc(Float_Data))
                                                            xor Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Int_Data := Integer(Trunc(Float_Data)) xor
                                                Integer(Trunc(Dest.Float_Data));
                                end;

                            else
                                Int_Data := Integer(Trunc(Float_Data));
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        if not BOOL(Dest.Int_Data) then
                            Int_Data := Int_Data xor 0
                        else
                            Int_Data := Integer(Trunc(Float_Data))
                                                xor Integer(Abs(Dest.Int_Data));
                    end
                    else if Dest.Reference.ClassName = 'String' then
                    begin
                        Val(Dest.Str_Data, Value, Code);

                        if Code <> 0 then
                            Int_Data := Integer(Trunc(Float_Data)) xor 0
                        else
                            Int_Data := Integer(Trunc(Float_Data)) xor Value;
                    end
                    else
                        Int_Data := Integer(Trunc(Float_Data));

                    ValueType := nmInt;
                end;
        end;
    end
    else if Reference.ClassName = 'Number' then
    begin
        if Dest.Reference.ClassName = 'Number' then
        begin
            case Dest.ValueType of
                nmInt:
                    begin
                        Int_Data := Integer(Trunc(Int_Data))
                                            xor Dest.Int_Data;
                    end;

                nmFloat:
                    begin
                        Int_Data := Integer(Trunc(Int_Data))
                                        xor Trunc(Dest.Float_Data);
                    end;

                else
                    begin
                        Int_Data := Integer(Trunc(Float_Data));
                    end;
            end;
        end
        else if Dest.Reference.ClassName = 'Boolean' then
        begin
            Int_Data := Integer(Trunc(int_Data))
                                        xor Integer(Abs(Dest.Int_Data));
        end
        else if Dest.Reference.ClassName = 'String' then
        begin
            Val(Dest.Str_Data, Value, Code);

            if Code <> 0 then
                Int_Data := Integer(Trunc(Int_Data)) xor 0
            else
                Int_Data := Integer(Trunc(Int_Data)) xor Value;
        end;

        ValueType := nmInt;
    end
    else
    begin
        Int_Data := 0;
        ValueType := nmInt;
    end;
end;

procedure TVirtualObject.Add(Dest : TVirtualObject);
begin
    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'Number' then
    begin
        case ValueType of
            nmInt:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Int_Data := Int_Data + Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Float_Data := Int_Data + Dest.Float_Data;
                                    ValueType := nmFloat;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        Int_Data := Int_Data + Abs(Dest.Int_Data);
                    end
                    else
                    begin
                        Str_Data := ForceString(Self) + Dest.Str_Data;
                        Reference := Server.GetClass('String');
                    end;
                end;

            nmFloat:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Float_Data := Float_Data + Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Float_Data := Float_Data+ Dest.Float_Data;
                                    Int_Data := Trunc(Float_Data);

                                    if Float_Data = Int_Data then
                                        ValueType := nmInt;
                                end;

                            nmNaN:
                                begin
                                    ValueType := nmNaN;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        Float_Data := Float_Data + Integer(Abs(Dest.Int_Data));
                        Int_Data := Trunc(Float_Data);

                        if Float_Data = Int_Data then
                            ValueType := nmInt;
                    end
                    else
                    begin
                        Str_Data := ForceString(Self) + Dest.Str_Data;
                        Reference := Server.GetClass('String');
                    end;
                end;
        end
    end
    else if Reference.ClassName = 'Boolean' then
    begin
        if Dest.Reference.ClassName = 'Number' then
        begin
            case Dest.ValueType of
                nmInt:
                    begin
                        Int_Data := Integer(Abs(Int_Data)) + Dest.Int_Data;
                        ValueType := nmInt;
                    end;

                nmFloat:
                    begin
                        Float_Data := Integer(Abs(Int_Data)) + Dest.Float_Data;
                        ValueType := nmFloat;
                    end;

                nmNaN:
                    begin
                        ValueType := nmNaN;
                    end;
            end;
        end
        else if Dest.ClassName = 'Boolean' then
        begin
            Int_Data := Integer(Abs(int_Data)) + Integer(Abs(Dest.Int_Data));
            ValueType := nmInt;
        end
        else
        begin
            Str_Data := ForceString(Self) + Dest.Str_Data;
            Reference := Server.GetClass('String');
        end;
    end
    else if Reference.ClassName = 'String' then
    begin
        Str_Data := Str_Data + ForceString(Dest);
    end
    else
    begin
        Str_Data := ForceString(Self) + ForceString(Dest);
    end;
end;

procedure TVirtualObject.Sub(Dest : TVirtualObject);
begin
    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'Number' then
    begin
        case ValueType of
            nmInt:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Int_Data := Int_Data - Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Float_Data := Int_Data - Dest.Float_Data;
                                    ValueType := nmFloat;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        Int_Data := Int_Data - Abs(Dest.Int_Data);
                    end
                    else
                        ValueType := nmNaN;
                end;

            nmFloat:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Float_Data := Float_Data - Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Float_Data := Float_Data - Dest.Float_Data;
                                    Int_Data := Trunc(Float_Data);

                                    if Float_Data = Int_Data then
                                        ValueType := nmInt;
                                end;

                            nmNaN:
                                begin
                                    ValueType := nmNaN;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        Float_Data := Float_Data - Integer(Abs(Dest.Int_Data));
                        Int_Data := Trunc(Float_Data);

                        if Float_Data = Int_Data then ValueType := nmInt;
                    end
                    else
                        ValueType := nmNaN;
                end;
        end
    end
    else if Reference.ClassName = 'Number' then
    begin
        begin
            if Dest.Reference.ClassName = 'Number' then
            begin
                case Dest.ValueType of
                    nmInt:
                        begin
                            Int_Data := Integer(Abs(Int_Data)) - Dest.Int_Data;
                            ValueType := nmInt;
                        end;

                    nmFloat:
                        begin
                            Float_Data := Integer(Abs(Int_Data)) - Dest.Float_Data;
                            ValueType := nmFloat;
                        end;

                    nmNaN:
                        begin
                            ValueType := nmNaN;
                        end;
                end;
            end
            else if Dest.Reference.ClassName = 'Boolean' then
            begin
                Int_Data := Integer(Abs(int_Data)) - Integer(Abs(Dest.Int_Data));
                ValueType := nmInt;
            end
            else
                ValueType := nmNaN;
        end;
    end
    else
    begin
        Reference := Server.GetClass('Number');
        Variants.Clear;
        ValueType := nmNaN;
    end;
end;

procedure TVirtualObject.Mul(Dest : TVirtualObject);
begin
    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    if Reference.ClassName = 'Number' then
    begin
        case ValueType of
            nmInt:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Int_Data := Int_Data * Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Float_Data := Int_Data * Dest.Float_Data;
                                    Int_Data := Trunc(Float_Data);

                                    if Float_Data <> Int_Data then
                                        ValueType := nmFloat;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        Int_Data := Int_Data * Abs(Dest.Int_Data);
                    end
                    else
                        ValueType := nmNaN;
                end;

            nmFloat:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Float_Data := Float_Data * Dest.Int_Data;
                                    Int_Data := Trunc(Float_Data);

                                    if Float_Data = Int_Data then
                                        ValueType := nmInt;
                                end;

                            nmFloat:
                                begin
                                    Float_Data := Float_Data * Dest.Float_Data;
                                    Int_Data := Trunc(Float_Data);

                                    if Float_Data = Int_Data then
                                        ValueType := nmInt;
                                end;

                            nmNaN:
                                begin
                                    ValueType := nmNaN;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        Float_Data := Float_Data * Integer(Abs(Dest.Int_Data));
                        Int_Data := Trunc(Float_Data);
                        if Float_Data = Int_Data then ValueType := nmInt;
                    end
                    else
                        ValueType := nmNaN;
                end;
        end
    end
    else if Reference.ClassName = 'Number' then
    begin
        if Dest.Reference.ClassName = 'Number' then
        begin
            case Dest.ValueType of
                nmInt:
                    begin
                        Int_Data := Integer(Abs(Int_Data)) * Dest.Int_Data;
                        ValueType := nmInt;
                    end;

                nmFloat:
                    begin
                        Float_Data := Integer(Abs(Int_Data)) * Dest.Float_Data;
                        Int_Data := Trunc(Float_Data);

                        if Float_Data = Int_Data then
                            ValueType := nmInt
                        else
                            ValueType := nmFloat;
                    end;

                nmNaN:
                    begin
                        ValueType := nmNaN;
                    end;
            end;
        end
        else if Dest.Reference.ClassName = 'Boolean' then
        begin
            Int_Data := Integer(Abs(int_Data)) * Integer(Abs(Dest.Int_Data));
            ValueType := nmInt;
        end
        else
            ValueType := nmNaN;
    end
    else
    begin
        Reference := Server.GetClass('Number');
        Variants.Clear;
        ValueType := nmNaN;
    end;
end;

procedure TVirtualObject.Divide(Dest : TVirtualObject);
var
    Float : Double;
    Float2 : Double;
    NaN : Boolean;
begin
    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    try
	    if Reference.ClassName = 'Number' then
	    begin
	        case ValueType of
	            nmInt:
	                begin
	                    if Dest.Reference.ClassName = 'Number' then
	                    begin
	                        case Dest.ValueType of
	                            nmInt:
	                                begin
	                                    Float_Data := Int_Data / Dest.Int_Data;
                                        Int_Data := Trunc(Float_Data);

                                        if Float_Data <> Int_Data then
	                                        ValueType := nmFloat;
	                                end;

	                            nmFloat:
	                                begin
	                                    Float_Data := Int_Data / Dest.Float_Data;
                                        Int_Data := Trunc(Float_Data);

                                        if Float_Data <> Int_Data then
	                                        ValueType := nmFloat;
	                                end;
	                        end;
	                    end
                        else if Dest.Reference.ClassName = 'String' then
                        begin
                            Int_Data := Int_Data div Abs(Dest.Int_Data);
                        end
                        else if Dest.Reference.ClassName = 'String' then
                        begin
                            Float := ForceDouble(Dest, NaN);

                            if NaN then
                            begin
                                ValueType :=nmNaN;
                                Exit;
                            end;

                            Float_Data := Int_Data / Float;
                            Int_Data := Trunc(Float_Data);

                            if Float_Data <> Int_Data then
                                ValueType := nmFloat;
                        end
	                    else
	                        ValueType := nmNaN;
	                end;

	            nmFloat:
	                begin
	                    if Dest.Reference.ClassName = 'Number' then
	                    begin
	                        case Dest.ValueType of
	                            nmInt:
	                                begin
	                                    Float_Data := Float_Data / Dest.Int_Data;
                                        Int_Data := Trunc(Float_Data);

                                        if Float_Data = Int_Data then
	                                        ValueType := nmInt;
	                                end;

	                            nmFloat:
	                                begin
	                                    Float_Data := Float_Data / Dest.Float_Data;
	                                    Int_Data := Trunc(Float_Data);

	                                    if Float_Data = Int_Data then
	                                        ValueType := nmInt;
	                                end;

	                            nmNaN:
	                                begin
	                                    ValueType := nmNaN;
	                                end;
	                        end;
	                    end
                        else if Dest.Reference.ClassName = 'Boolean' then
                        begin
                            Float_Data := Float_Data
                                            / Integer(Abs(Dest.Int_Data));
                            Int_Data := Trunc(Float_Data);

                            if Float_Data = Int_Data then ValueType := nmInt;
                        end
                        else if Dest.Reference.ClassName = 'String' then
                        begin
                            Float := ForceDouble(Dest, NaN);

                            if NaN then
                            begin
                                ValueType := nmNaN;
                                Exit;
                            end;

                            Float_Data := Int_Data / Float;
                            Int_Data := Trunc(Float_Data);

                            if Float_Data = Int_Data then
                                ValueType := nmInt;
                        end
	                    else
	                        ValueType := nmNaN;
	                end;
	        end
	    end
        else if Reference.ClassName = 'Boolean' then
        begin
            if Dest.Reference.ClassName = 'Number' then
            begin
                case Dest.ValueType of
                    nmInt:
                        begin
                            Int_Data := Integer(Abs(Int_Data)) div Dest.Int_Data;
                            ValueType := nmInt;
                        end;

                    nmFloat:
                        begin
                            Float_Data := Integer(Abs(Int_Data))
                                                / Dest.Float_Data;
                            Int_Data := Trunc(Float_Data);

                            if Float_Data <> Int_Data then
                                ValueType := nmFloat
                            else
                                ValueType := nmInt;
                        end;

                    nmNaN:
                        begin
                            ValueType := nmNaN;
                        end;
                end;
            end
            else if Dest.Reference.ClassName = 'Boolean' then
            begin
                Int_Data := Integer(Abs(Int_Data))
                                div Integer(Abs(Dest.Int_Data));
                ValueType := nmInt;
            end
            else if Dest.Reference.ClassName = 'String' then
            begin
                Float := ForceDouble(Dest, NaN);

                if NaN then
                begin
                    ValueType := nmNaN;
                    Exit;
                end;

                Float_Data := Abs(Int_Data) / Float;
                Int_Data := Trunc(Float_Data);

                if Float_Data <> Int_Data then
                    ValueType := nmFloat
                else
                    ValueType := nmInt;
            end
            else
                ValueType := nmNaN;
        end
        else if Reference.ClassName = 'String' then
        begin
            Float := ForceDouble(Self, NaN);

            if NaN then
            begin
                ValueType := nmNaN;
                Exit;
            end;

            Float2 := ForceDouble(Dest, NaN);

            if NaN then
            begin
                ValueType := nmNaN;
                Exit;
            end;

            Float_Data := Float / Float2;
            Int_Data := Trunc(Float_Data);

            if Float_Data <> Int_Data then
                ValueType := nmFloat
            else
                ValueType := nmInt;
        end
	    else
	    begin
	        Reference := Server.GetClass('Number');
	        Variants.Clear;
	        ValueType := nmNaN;
	    end;

    except
        if ForceDouble(Self, NaN) > 0 then
            ValueType := nmPInf
        else
            ValueType :=nmMInf;
    end;
end;

procedure TVirtualObject.Mode(Dest : TVirtualObject);
var
    Float : Double;
    Float2 : Double;
    NaN : Boolean;
begin
    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Int_Data := 0;
        ValueType := nmNaN;
        Reference := Server.GetClass('Number');
        Exit;
    end;

    try
	    if Reference.ClassName = 'Number' then
	    begin
	        case ValueType of
	            nmInt:
	                begin
	                    if Dest.Reference.ClassName = 'Number' then
	                    begin
	                        case Dest.ValueType of
	                            nmInt:
	                                begin
	                                    Int_Data := Int_Data mod Dest.Int_Data;
	                                end;

	                            nmFloat:
	                                begin
	                                    Float := Int_Data / Dest.Float_Data;
                                        Float_Data := Float_Data
                                                - Trunc(Float) * Dest.Float_Data;

                                        Int_Data := Trunc(Float_Data);

                                        if Float_Data <> Int_Data then
	                                        ValueType := nmFloat;
	                                end;
	                        end;
	                    end
                        else if Dest.Reference.ClassName = 'Boolean' then
                        begin
                            Int_Data := Int_Data mod Abs(Dest.Int_Data);
                        end
                        else if Dest.Reference.ClassName = 'String' then
                        begin
                            Float := ForceDouble(Dest, NaN);

                            if NaN then
                            begin
                                ValueType := nmNaN;
                                Exit;
                            end;

                            Float_Data := Int_Data
                                        - Trunc(Int_Data / Float) * Float;
                            Int_Data := Trunc(Float_Data);

                            if Float_Data <> Int_Data then
                                ValueType := nmFloat;
                        end
	                    else
	                        ValueType := nmNaN;
	                end;

	            nmFloat:
	                begin
	                    if Dest.Reference.ClassName = 'Number' then
	                    begin
	                        case Dest.ValueType of
	                            nmInt:
	                                begin
	                                    Float := Float_Data / Dest.Int_Data;
                                        Float_Data := Float_Data - Trunc(Float)
                                                        * Dest.Int_Data;
                                        Int_Data := Trunc(Float_Data);

                                        if Float_Data = Int_Data then
	                                        ValueType := nmInt;
	                                end;

	                            nmFloat:
	                                begin
	                                    Float := Float_Data / Dest.Float_Data;
                                        Float_Data := Float_Data - Trunc(Float)
                                                        * Dest.Float_Data;
	                                    Int_Data := Trunc(Float_Data);

	                                    if Float_Data = Int_Data then
	                                        ValueType := nmInt;
	                                end;

	                            nmNaN:
	                                begin
	                                    ValueType := nmNaN;
	                                end;
	                        end;
	                    end
                        else if Dest.Reference.ClassName = 'Boolean' then
                        begin
                            Float := Float_Data / Integer(Abs(Dest.Int_Data));
                            Float_Data := Float_Data - Trunc(Float)
                                                * Integer(Abs(Dest.Int_Data));
                            Int_Data := Trunc(Float_Data);

                            if Float_Data = Int_Data then ValueType := nmInt;
                        end
                        else if Dest.Reference.ClassName = 'String' then
                        begin
                            Float := ForceDouble(Dest, NaN);

                            if NaN then
                            begin
                                ValueType := nmNaN;
                                Exit;
                            end;

                            Float_Data := Float_Data
                                        - Trunc(Float_Data / Float) * Float;
                            Int_Data := Trunc(Float_Data);

                            if Float_Data = Int_Data then
                                ValueType := nmInt;
                        end
	                    else
	                        ValueType := nmNaN;
	                end;
	        end
	    end
        else if Reference.ClassName = 'Boolean' then
        begin
            if Dest.Reference.ClassName = 'Number' then
            begin
                case Dest.ValueType of
                    nmInt:
                        begin
                            Int_Data := Integer(Abs(Int_Data))
                                                mod Dest.Int_Data;
                            ValueType := nmInt;
                        end;

                    nmFloat:
                        begin
                            Float := Integer(Abs(Int_Data)) / Dest.Float_Data;
                            Float_Data := Float_Data - Trunc(Float)
                                                * Integer(Abs(Dest.Int_Data));

                            Int_Data := Trunc(Float_Data);

                            if Float_Data <> Int_Data then
                                ValueType := nmFloat
                            else
                                ValueType := nmInt;
                            end;

                    nmNaN:
                        begin
                            ValueType := nmNaN;
                        end;
                end;
            end
            else if Dest.Reference.ClassName = 'Boolean' then
            begin
                Int_Data := Integer(Abs(Int_Data))
                                    mod Integer(Abs(Dest.Int_Data));
                ValueType := nmInt;
            end
            else if Dest.Reference.ClassName = 'String' then
            begin
                Float := ForceDouble(Dest, NaN);

                if NaN then
                begin
                    ValueType := nmNaN;
                    Exit;
                end;

                Float_Data := Abs(Int_Data)
                                        - Trunc(Abs(Int_Data) / Float) * Float;
                Int_Data := Trunc(Float_Data);

                if Float_Data <> Int_Data then
                    ValueType := nmFloat
                else
                    ValueType := nmInt;
            end
            else
                ValueType := nmNaN;
        end
        else if Reference.ClassName = 'String' then
        begin
            Float := ForceDouble(Self, NaN);

            if NaN then
            begin
                ValueType := nmNaN;
                Exit;
            end;

            Float2 := ForceDouble(Dest, NaN);

            if NaN then
            begin
                ValueType := nmNaN;
                Exit;
            end;

            Float_Data := Float - Trunc(Float / Float2) * Float2;
            Int_Data := Trunc(Float_Data);

            if Float_Data <> Int_Data then
                ValueType := nmFloat
            else
                ValueType := nmInt;
        end
	    else
	    begin
	        Reference := Server.GetClass('Number');
	        Variants.Clear;
	        ValueType := nmNaN;
	    end;

    except
        if ForceDouble(Self, NaN) > 0 then
            ValueType := nmPInf
        else
            ValueType :=nmMInf;
    end;
end;

function TVirtualObject.Equal(Dest : TVirtualObject) : Boolean;
begin
    Result := False;

    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Exit;
    end;

    if Reference.ClassName = Dest.Reference.ClassName then
    begin

        if (Reference.ClassName = 'Number')
                and (Dest.Reference.ClassName = 'Number') then
        begin
            case ValueType of
                nmInt:
                    begin
                        case Dest.ValueType of
                            nmInt:
                                Result := Int_Data = Dest.Int_Data;

                            nmFloat:
                                Result := Int_Data = Dest.Float_Data;
                        end;
                    end;

                nmFloat:
                    begin
                        case Dest.ValueType of
                            nmInt:
                                Result := Float_Data = Dest.Int_Data;
                            nmFloat:
                                Result := Float_Data = Dest.Float_Data;
                        end;
                    end;

                nmNaN:
                    Result := True;
            end;
        end
        else if (Reference.ClassName = 'String')
                and (Dest.Reference.ClassName = 'String') then
            Result := Str_Data = Dest.Str_Data
        else
            Result := Reference = Dest.Reference;
    end
    else if (Reference.ClassName = 'Boolean')
                and (Dest.Reference.ClassName = 'Number') then
    begin
        Result := Abs(Int_Data) = Dest.Int_Data;
    end
    else if (Reference.ClassName = 'Number')
                and (Dest.Reference.ClassName = 'Boolean') then
    begin
        Result := Int_Data = Abs(Dest.Int_Data);
    end;
end;

function TVirtualObject.ShiftRight(Dest : TVirtualObject) : Boolean;
var
    Shift : Integer;
    NaN : Boolean;
    Data : Integer;
begin
    Result := True;
    Shift := ForceInt(Dest, NaN);
    Data := ForceInt(Self, NaN);
    //Int_Data := Data shr Shift;

    asm
        MOV	ECX, [Shift]
        MOV	EAX, [Data]
        SAR	EAX, CL
        MOV EDX, [Self]
        MOV	[EDX + Int_Data], EAX
    end;

    ValueType := nmInt;
end;

function TVirtualObject.ShiftLeft(Dest : TVirtualObject) : Boolean;
var
    Shift : Integer;
    NaN : Boolean;
    Data : Integer;
begin
    Result := True;
    Shift := ForceInt(Dest, NaN);
    Data := ForceInt(Self, NaN);
    Int_Data := Data shl Shift;
    ValueType := nmInt;
end;

function TVirtualObject.ShiftRightNF(Dest : TVirtualObject) : Boolean;
var
    Shift : Integer;
    NaN : Boolean;
    Data : Integer;
begin
    Result := True;
    Shift := ForceInt(Dest, NaN);
    Data := ForceInt(Self, NaN);
    Int_Data := Data shr Shift;
    ValueType := nmInt;
end;

function TVirtualObject.Compare(Dest : TVirtualObject ; var Compatibled : Boolean) : Integer;
var
    Float : Double;
    NaN : Boolean;
begin
    Result := 0;
    Compatibled := True;

    if (Reference = nil) or (Dest.Reference = nil) then
    begin
        Compatibled := False;
        Exit;
    end;

    if Reference.ClassName = 'Number' then
    begin
        case ValueType of
            nmInt:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Result := Int_Data - Dest.Int_Data;
                                end;

                            nmFloat:
                                begin
                                    Float := Int_Data - Dest.Float_Data;

                                    if Float > 0 then
                                        Result := 1
                                    else if Float = 0 then
                                        Result := 0
                                    else
                                        Result := -1;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        Result := Int_Data - Abs(Dest.Int_Data);
                    end
                    else if Dest.Reference.ClassName = 'String' then
                    begin
                        Result := Int_Data - ForceInt(Dest, NaN);
                    end
                    else
                    begin
                        Result := 0;
                        Compatibled := False;
                    end;
                end;

            nmFloat:
                begin
                    if Dest.Reference.ClassName = 'Number' then
                    begin
                        case Dest.ValueType of
                            nmInt:
                                begin
                                    Float := Float_Data - Dest.Int_Data;

                                    if Float > 0 then
                                        Result := 1
                                    else if Float = 0 then
                                        Result := 0
                                    else
                                        Result := -1;
                                end;

                            nmFloat:
                                begin
                                    Float := Float_Data - Dest.Float_Data;

                                    if Float > 0 then
                                        Result := 1
                                    else if Float = 0 then
                                        Result := 0
                                    else
                                        Result := -1;
                                end;
                        end;
                    end
                    else if Dest.Reference.ClassName = 'Boolean' then
                    begin
                        Float := Float_Data - Abs(Dest.Int_Data);

                        if Float > 0 then
                            Result := 1
                        else if Float = 0 then
                            Result := 0
                        else
                            Result := -1;
                    end
                    else if Dest.Reference.ClassName = 'String' then
                    begin
                        Float := Float_Data - ForceDouble(Dest, NaN);

                        if Float > 0 then
                            Result := 1
                        else if Float = 0 then
                            Result := 0
                        else
                            Result := -1;
                    end
                    else
                    begin
                        Result := 0;
                        Compatibled := False;
                    end;
                end;
        end;
    end
    else if Reference.ClassName = 'Boolean' then
    begin
        if Dest.Reference.ClassName = 'Number' then
        begin
            case Dest.ValueType of
                nmInt:
                    begin
                        Result := Int_Data - Dest.Int_Data;
                    end;

                nmFloat:
                    begin
                        Float := Int_Data - Dest.Float_Data;

                        if Float > 0 then
                            Result := 1
                        else if Float = 0 then
                            Result := 0
                        else
                            Result := -1;
                    end;
            end;
        end
        else if Dest.Reference.ClassName = 'Boolean' then
        begin
            Result := Int_Data - Abs(Dest.Int_Data);
        end
        else if Dest.Reference.ClassName = 'String' then
        begin
            Result := Abs(Int_Data) - ForceInt(Dest, NaN);
        end
        else
        begin
            Result := 0;
            Compatibled := False;
        end;
    end
    else if Reference.ClassName = 'String' then
    begin
        if Dest.Reference.ClassName = 'Number' then
        begin
            case Dest.ValueType of
                nmInt:
                    begin
                        Result := Int_Data - Dest.Int_Data;
                    end;

                nmFloat:
                    begin
                        Float := Int_Data - Dest.Float_Data;

                        if Float > 0 then
                            Result := 1
                        else if Float = 0 then
                            Result := 0
                        else
                            Result := -1;
                    end;
            end;
        end
        else if Dest.Reference.ClassName = 'Boolean' then
        begin
            Result := Int_Data - Abs(Dest.Int_Data);
        end
        else if Dest.Reference.ClassName = 'String' then
        begin
            Result := CompareStr(Str_Data, Dest.Str_Data);
        end
        else
        begin
            Result := 0;
            Compatibled := False;
        end;
    end
    else
    begin
        Result := 0;
        Compatibled := False;
    end;
end;

function TVirtualObject.FindArray(Param : TVirtualObject) : Integer;
var
    Int_Value : Integer;
    NaN : Boolean;
begin
    Int_Value := ForceInt(Param, NaN);

    if not NaN then
    begin
        Result := Arrays.GetIndex(Int_Value);

        if Result = -1 then
        begin
            Arrays.Add(Int_Value);
            Result := Arrays.GetIndex(Int_Value)
        end;
    end
    else
        Result := -1;
end;

//******************************************************************************
//TObjectServer

constructor TObjectServer.Create;
begin
    SetLength(Types, 0);
    Count := 0;

    EmbedObject;
end;

destructor TObjectServer.Destroy;
var
    n : Integer;
begin
    for n := 0 to Count - 1 do
    begin
        Types[n].Free;
    end;

    inherited Destroy;
end;

function TObjectServer.IsClassExists(Name : String) : Boolean;
var
    n : Integer;
begin
    Result := True;

    for n := 0 to Count - 1 do
    begin
        if Types[n].ClassName = Name then Exit;
    end;

    Result := False;
end;

function TObjectServer.CreateInherited(Name : String ; Parent : String) : TJaObject;
begin
    Result := Add(Parent);
    Result.ClassName := Name;
end;

function TObjectServer.PrepareInstance(Name : String) : TVirtualObject;

    procedure AddVariants(Name : String ; var Vars : TVariantList);
    var
        m : Integer;
        n : Integer;
        CName : String;
    begin
        for n := 0 to Count - 1 do
        begin
            if Types[n].ClassName = Name then
            begin
                //
                //ʃNX̕ϐi[
                //

                if Types[n].Parent <> nil then
                    AddVariants(Types[n].ClassName, Vars);

                //
                //̃NX̕ϐi[
                //

                for m := 0 to Types[n].Variants.Count - 1 do
                begin
                    CName := Types[n].Variants.Strings[m];

                    if not Vars.IsExists(CName) then
                    begin
                        Vars.Add(CName);
                        Vars.Datas[Vars.Count - 1].Server := Self;
                    end;
                end;

                Exit;
            end;
        end;
    end;

var
    n : Integer;
begin
    Result := TVirtualObject.Create(Self);
    Result.Server := Self;
    Result.Global := Global;
    DustBox.Add(Integer(Pointer(Result)));
    AddVariants(Name, Result.Variants);

    Result.Reference := Plugin.FindClass(Name);

    if Result.Reference = nil then
    begin
        for n := 0 to Count - 1 do
        begin
            if Types[n].ClassName = Name then
            begin
                Result.Reference := Types[n];
                Break;
            end;
        end;

        if Result.Reference = nil then
            Result.Reference := Plugin.FindClass('Undefined');
    end;

    if Result.Reference <> nil then
        Result.Reference.CreateObject(Result);

    {$IFDEF DEBUG}
        //WriteLn('Create : ' + Name);
        WriteLn(IntToStr(DustBox.Count));
    {$ENDIF}
end;

function TObjectServer.Add(Name : String) : TJaObject;
begin
    SetLength(Types, Count + 1);

    if Name = 'Global' then
        Types[Count] := TJaGlobal.Create
    else
        Types[Count] := TJaObject.Create;

    Result := Types[Count];
    Count := Count + 1;
end;

function TObjectServer.GetClass(Name : String) : TJaObject;
var
    n : Integer;
begin
    Result := Plugin.FindClass(Name);
    if Result <> nil then Exit;

    for n := 0 to Count - 1 do
    begin
        if Types[n].ClassName = Name then
        begin
            Result := Types[n];
            Exit;
        end;
    end;
end;

procedure TObjectServer.EmbedObject;
begin
    //gݍ݃IuWFNg̓o^
    Count := 1;
    SetLength(Types, Count);
    Types[0] := TJaGlobal.Create;

    //ɃIuWFNg𒼐ڑ邱Ƃ͐Ȃ
    //TJaRuntimeTScriptpNXŎ邱Ƃ߂
end;

//******************************************************************************
//TPluginLoader

constructor TPluginLoader.Create;
begin
    Count := 0;
end;

destructor TPluginLoader.Destroy;
var
    n : Integer;
begin
    for n := 0 to Count - 1 do
        Objects[n].Free;

    inherited Destroy;
end;

procedure TPluginLoader.Add(Name : String ; Obj : TJaObject);
begin
    SetLength(Names, Count + 1);
    SetLength(Objects, Count + 1);
    Names[Count] := Name;
    Objects[Count] := Obj;
    Count := Count + 1;
end;

function TPluginLoader.FindClass(Name : String) : TJaObject;
var
    n : Integer;
begin
    Result := nil;

    for n := 0 to Count - 1 do
    begin
        //if Objects[n].ClassName = Name then
        if Names[n] = Name then
        begin
            Result := Objects[n];
            Exit;
        end;
    end;
end;

//******************************************************************************

function ForceString(Obj : TVirtualObject) : String;
var
    CName : String;
    args : array of TVirtualObject;
    Target : TVirtualObject;
begin
    Result := '';
    if Obj.Reference = nil then Exit;
    CName := Obj.Reference.ClassName;

    if Obj.Reference.IsParent('String') then
        Result := Obj.Str_Data
    else if Obj.Reference.IsParent('Number') then
    begin
        case Obj.ValueType of
            nmInt:
                Result := IntToStr(Obj.Int_Data);
            nmFloat:
                Result := DoubleToStr(Obj.Float_Data);
            nmNaN:
                Result := 'NaN';
            nmUndefined:
                Result := 'Undefined';
        end;
    end
    else if Obj.Reference.IsParent('Boolean') then
    begin
        if Obj.Int_Data = 0 then
            Result := 'false'
        else
            Result := 'true';
    end
    else if Obj.Reference.IsParent('Date') then
        Result := EncodeGMTString(Obj.Float_Data, TimeZone)
    else
    begin
        SetLength(args, 0);
        Target := Obj.Reference.toString(args, Obj, nil);
        Result := ForceString(Target);
        Target.Free;
    end;
end;

function ForceInt(Obj : TVirtualObject ; var IsNaN : Boolean) : Integer;
var
    CName : String;
    Code : Integer;
begin
    Result := 0;
    IsNaN := False;
    if Obj.Reference = nil then Exit;
    CName := Obj.Reference.ClassName;

    if (CName = 'String') or (Obj.Reference.IsParent('String')) then
    begin
        Val(Obj.Str_Data, Result, Code);

        if Code <> 0 then
        begin
            Result := 0;
            IsNaN := True;
        end;
    end
    else if (CName = 'Number') or (Obj.Reference.IsParent('Number')) then
    begin
        case Obj.ValueType of
            nmInt:
                Result := Obj.Int_Data;
            nmFloat:
                Result := Trunc(Obj.Float_Data);
            nmNaN, nmUndefined:
                begin
                    Result := 0;
                    IsNaN := True;
                end;
        end;
    end
    else
    begin
        Result := 0;
        IsNaN := True;
    end;
end;

function ForceDouble(Obj : TVirtualObject ; var IsNaN : Boolean) : Double;
var
    CName : String;
    Code : Integer;
begin
    Result := 0;
    if Obj.Reference = nil then Exit;
    IsNaN := False;
    CName := Obj.Reference.ClassName;

    if (CName = 'String') or (Obj.Reference.IsParent('String')) then
    begin
        Val(Obj.Str_Data, Result, Code);

        if Code <> 0 then
        begin
            Result := 0;
            IsNaN := True;
        end;
    end
    else if (CName = 'Number') or (Obj.Reference.IsParent('Number')) then
    begin
        case Obj.ValueType of
            nmInt:
                Result := Obj.Int_Data;
            nmFloat:
                Result := Obj.Float_Data;
            nmNaN, nmUndefined:
                begin
                    Result := 0;
                    IsNaN := True;
                end;
        end;
    end
    else
    begin
        Result := 0;
        IsNaN := True;
    end;
end;

function ForceBool(Obj : TVirtualObject) : Boolean;
begin
    Result := False;
    if Obj.Reference = nil then Exit;

    if Obj.Reference.ClassName = 'Number' then
    begin
        case Obj.ValueType of
            nmInt:
                begin
                    Result := Obj.Int_Data <> 0;
                end;

            nmFloat:
                begin
                    Result := Obj.Float_Data <> 0;
                end;
        end;
    end
    else if Obj.Reference.ClassName = 'Boolean' then
        Result := BOOL(Obj.Int_Data)
    else if Obj.Reference.ClassName = 'String' then
        Result := Obj.Str_Data <> '';
end;

//******************************************************************************

function ToWord(Value : Integer) : Word;
begin
    Result := Cardinal(Value) mod 65536;
end;

procedure VarCopy(const Data : TVirtualObject ; var Dest : TVirtualObject
                                                    ; Server : TObjectServer);
var
    Name : String;
begin
    //VKɍ쐬VirtualObject݂̂Ɏgp邱!!
    if Data.Reference <> nil then
    begin
        Name := Data.Reference.ClassName;

        if (Name = 'Number') or (Name = 'String') or (Name = 'Boolean') then
        begin
            Dest := Server.PrepareInstance(Name);
            Dest.Reference := Data.Reference;
            Dest.Server := Data.Server;
            Dest.Int_Data := Data.Int_Data;
            Dest.Float_Data := Data.Float_Data;
            Dest.Str_Data := Data.Str_Data;
            Dest.ValueType := Data.ValueType;
        end
        else
        begin
            Dest := Data;
            Inc(Dest.UseCount);
        end;
    end
    else
    begin
        Dest := Server.PrepareInstance(Name);
        Dest.Reference := Data.Reference;
        Dest.Server := Data.Server;
        Dest.Int_Data := Data.Int_Data;
        Dest.Float_Data := Data.Float_Data;
        Dest.Str_Data := Data.Str_Data;
        Dest.ValueType := Data.ValueType;
    end;
end;

procedure VarCopy2(const Data : TVirtualObject ; var Dest : TVirtualObject);
begin
    Dest := Data;
    Inc(Dest.UseCount);
end;

//******************************************************************************

function MakeInt(Value : Integer ; Server : TObjectServer) : TVirtualObject;
begin
    Result := Server.PrepareInstance('Number');
    Result.Server := Server;
    Result.Int_Data := Value;
    Result.ValueType := nmInt;
end;

function MakeFloat(Value : Double ; Server : TObjectServer) : TVirtualObject;
var
    IntValue : Integer;
begin
    IntValue := Trunc(Value);
    Result := Server.PrepareInstance('Number');
    Result.Server := Server;

    if IntValue = Value then
    begin
        Result.Int_Data := IntValue;
        Result.ValueType := nmInt;
    end
    else
    begin
        Result.Float_Data := Value;
        Result.ValueType := nmFloat;
    end;
end;

function MakeNaN(Server : TObjectServer) : TVirtualObject;
begin
    Result := Server.PrepareInstance('Number');
    Result.Server := Server;
    Result.ValueType := nmNaN;
end;

function MakeString(Value : String ; Server : TObjectServer) : TVirtualObject;
begin
    Result := Server.PrepareInstance('String');
    Result.Server := Server;
    Result.Str_Data := Value;
end;

function MakeBoolean(Value : Boolean ; Server : TObjectServer) : TVirtualObject;
begin
    Result := Server.PrepareInstance('Boolean');
    Result.Server := Server;
    Result.Int_Data := Integer(Value);
end;

function MakeUndefined(Server : TObjectServer) : TVirtualObject;
begin
    Result := Server.PrepareInstance('Undefined');
    Result.Server := Server;
    Result.ValueType := nmUndefined;
end;

//******************************************************************************

function JagaTimeAdjust(Time : TDateTime) : TDateTime;
const
    TIME_ADJUST     =   25569;
begin
    Result := Time - TIME_ADJUST;
end;

function DateTimeToJagaDate(Time : TDateTime) : Double;
const
    SEC_MSEC        =   1000;
    MIN_MSEC        =   60 * SEC_MSEC;
    HOUR_MSEC       =   60 * MIN_MSEC;
    DAY_MSEC        =   24 * HOUR_MSEC;
var
    Hour, Minute, Second, MilliSecond : Integer;
begin
    DecodeTime(Time, Hour, Minute, Second, MilliSecond);
    Result := Trunc(Time) * DAY_MSEC + Hour * HOUR_MSEC
                        + Minute * MIN_MSEC + Second * SEC_MSEC + MilliSecond;
end;

function JagaDateToDateTime(Time : Integer) : TDateTime;
const
    TIME_ADJUST     =   25569;
    SEC_MSEC        =   1000;
    MIN_MSEC        =   60 * SEC_MSEC;
    HOUR_MSEC       =   60 * MIN_MSEC;
    DAY_MSEC        =   24 * HOUR_MSEC;
var
    Hour, Minute, Second, MilliSecond : Integer;
    Value : Integer;
begin
    Value := Time mod DAY_MSEC;
    Hour := Value div HOUR_MSEC;
    Value := Value mod HOUR_MSEC;
    Minute := Value div MIN_MSEC;
    Value := Value mod MIN_MSEC;
    Second := Value div SEC_MSEC;
    MilliSecond := Value mod SEC_MSEC;
    Result := Time div DAY_MSEC + TIME_ADJUST
                    + EncodeTime(Hour, Minute, Second, MilliSecond);
end;

//******************************************************************************

function IDCheck(ID : String) : Boolean;
var
    n : Integer;
begin
    Result := True;

    for n := 1 to Length(ID) do
    begin
        if Pos(ID[n], ID_STRING) = 0 then
        begin
            Result := False;
            Exit;
        end;
    end;
end;

end.
