unit jp5_main;

interface

uses
    windows, tn_utils, jascript, ja_embed, jupiter, tn_classes, tn_lang, tn_crc,
    shellapi;

type
    TItemInfo       =   record
        FileName    :   PChar;
        CustomInfo  :   PChar;
        Handle      :   THandle;
        Cache       :   PChar;
        Cookie      :   PChar;
        ItemPath    :   PChar;
        Temporary   :   PChar;
        Option      :   PChar;
        Priority    :   Integer;
    end;
    PItemInfo       =   ^TItemInfo;

    TDownLoadInfo   =   record
        Handle      :   THandle;
        Length      :   Integer;
        Pos         :   Integer;
    end;

    PDownLoadInfo   =   ^TDownLoadInfo;

    TJupiterBoot    =   class(TScript)
        private
            CachePath : String;
            ItemPath : String;
            TempPath : String;
            OptionCode : String;
            Priority : Integer;
            WindowsTemp : Boolean;
        public
            Handle : THandle;
            constructor Create(Item : PItemInfo);
            destructor Destroy; override;
            function Run(Sync : Boolean) : Boolean; override;
    end;

    TRuntime        =   class(TJaRuntime)
        private
        public
            constructor Create(CompiledScript : TScript);
            destructor Destroy; override;
    end;

//procedure
    function KeyCheck : String;
    function AdwinExeCheck : Boolean;

//procedure
    function JupiterOpen(Info : PItemInfo) : THandle; stdcall;
    procedure JupiterClose(Handle : THandle); stdcall;
    function JupiterRun(Handle : THandle ; Sync : BOOL) : BOOL; stdcall
    function JupiterIsRunning(Handle : THandle) : BOOL; stdcall;
    function JupiterGetStructSize(Handle : THandle) : Integer; stdcall;
    procedure JupiterGetStructStr(Handle : THandle ; Buf : PChar); stdcall;
    function JupiterGetCompileSize(Handle : THandle) : Integer; stdcall;
    procedure JupiterGetCompileStr(Handle : THandle ; Buf : PChar); stdcall;
    function JupiterCompile(Handle : THandle) : BOOL; stdcall;

const
    WM_JPMESSAGE        =   8100;

    WM_JPSTARTDL        =   8110;
    WM_JPENDDL          =   8111;
    WM_JPDOWNLOADING    =   8112;

implementation

//******************************************************************************
//TJupiterBoot

constructor TJupiterBoot.Create(Item : PItemInfo);
var
    Addition : TJaObject;
    Language : TLanguageDriver;
    History : TNStringList;
begin
    inherited Create(Item.FileName);

    CachePath := String(Item.Cache);
    ItemPath := String(Item.ItemPath);
    TempPath := String(Item.Temporary);
    OptionCode := String(Item.Option);
    Handle := Item.Handle;
    Priority := Item.Priority;

    //e|̐ݒ
    if TempPath = '' then
    begin
        WindowsTemp := True;
        TempPath := GetTempPath('jp5dx');
        CreateDirectory(PChar(TempPath), nil);
    end
    else
        WindowsTemp := False;

    //CachePathw肳ĂȂƂ
    if CachePath = '' then
        CachePath := TempPath;

    //Jupiter
    Addition := TJupiter.Create;
    TJupiter(Addition).WindowHandle := Handle;
    TJupiter(Addition).Handle := THandle(Pointer(Self));
    TJupiter(Addition).CachePath := CachePath;
    TJupiter(Addition).CookiePath := String(Item.Cookie);
    TJupiter(Addition).ItemPath := ItemPath;
    TJupiter(Addition).TempPath := TempPath;
    TJupiter(Addition).Init;

    Language := TJupiter(Addition).Language;
    History := TJupiter(Addition).History;

    Plugin.Add('@@Jupiter', Addition);

    //Window
    Addition := TJaWindow.Create(CachePath, String(Item.Cookie));
    TJaWindow(Addition).Runtime := Self;
    TJaWindow(Addition).Language := Language;
    TJaWindow(Addition).History := History;

    Plugin.Add('Window', Addition);

    //Socket
    Addition := TJaSocket.Create;
    Plugin.Add('Socket', Addition);

    //Links
    Addition := TJaLinks.Create;
    Plugin.Add('Links', Addition);

    //Link
    Addition := TJaLink.Create;
    Plugin.Add('Link', Addition);

    //Form
    Addition := TJaForm.Create;
    Plugin.Add('Form', Addition);

    //Input
    Addition := TJaInput.Create;
    Plugin.Add('Input', Addition);

    //Select
    Addition := TJaSelect.Create;
    Plugin.Add('Select', Addition);

    //Option
    Addition := TJaOption.Create;
    Plugin.Add('Option', Addition);

    //Mime
    Addition := TJaMime.Create;
    TJaMime(Addition).Language := Language;
    Plugin.Add('Mime', Addition);

    //File
    Addition := TJaFile.Create;
    Plugin.Add('File', Addition);

    //Mimes
    Addition := TJaMimes.Create;
    Plugin.Add('Mimes', Addition);

    //StringList
    Addition := TJaStringList.Create;
    Plugin.Add('StringList', Addition);
end;

destructor TJupiterBoot.Destroy;
begin
    inherited Destroy;
end;

function TJupiterBoot.Run(Sync : Boolean) : Boolean;
begin
    Result := True;

    if (Error.Count <> 0) or (Runtime <> nil)
        or (not Compiled) then
    begin
        Result := False;
        Exit;
    end;

    //XNvg̎s
    Runtime := TRuntime.Create(Self);
    Runtime.FreeOnTerminate := True;
    Runtime.TermEventObj := ExecuteTerm;
    Runtime.OptionCode := OptionCode;
    Runtime.Priority := Priority;

    Runtime.Resume;

    if Sync then
    begin
        while Runtime <> nil do
            Sleep(100);
    end;
end;

//******************************************************************************
//TRuntime

constructor TRuntime.Create(CompiledScript : TScript);
var
    Obj : TVirtualObject;
    JaObj : TJaObject;
begin
    inherited Create(CompiledScript);

    //IuWFNg"Jupiter"쐬
    Obj := Script.Scripts[0].ObjectServer.PrepareInstance('@@Jupiter');

    //Window, MimeLanguageݒ
    JaObj := CompiledScript.Scripts[0].ObjectServer.GetClass('Window');
    TJaWindow(JaObj).ExitFlag := @ExitFlag;
    TJaWindow(JaObj).JupiterObj := Obj;

    JaObj := CompiledScript.Scripts[0].ObjectServer.GetClass('Mime');
    TJaMime(JaObj).TempPath := TJupiterBoot(CompiledScript).TempPath;

    //pXݒ
    Variants.SetObject('Jupiter', Obj);
end;

destructor TRuntime.Destroy;
begin
    inherited Destroy;
end;

//******************************************************************************

function RegPassDecode(Source : String) : String;
const
    PASS_TABLE = 'CgQ4u7JYZlIcNO3BLbt81h/xmkMzPrFAvaUSs+X5nR2W9EqH6yKDdeGipjwfoV0T';
var
    a , b , k , l , m : Integer;
begin
    l := 13;
    k := 27;
    Result := '';

    if Length(Source) mod 2 <> 0 then Exit;
    for m:= 1 to Length(Source) div 2 do
    begin
        a := Pos(Source[m*2-1], PASS_TABLE) - 1;
        b := Pos(Source[m*2], PASS_TABLE) - 1;
        Result := Result + Chr(((a xor k) xor l ) * 64 + (b xor l));
        k := k + 6;
        l := l + 35;
        if k > 63 then k := k - 64;
        if l > 63 then l := l - 64;
    end;
end;

function KeyCheck : String;
var
    Image : array [0..255] of Char;
    Data : String;
    F : File;
    FileName : String;
    PImage : PChar;
    ps : Integer;
    User : String;
    Pass : String;
begin
    Result := '';
    FileName := ExtractFilePath(ParamStr(0)) + 'jp5.key';
    FillChar(Image, SizeOf(Image), #0);
    if not FileExists(FileName) then Exit;

    try
        AssignFile(F, FileName);
        Reset(F, 1);
        BlockRead(F, Image, SizeOf(Image));
    finally
        CloseFile(F);
    end;

    PImage := @Image;
    Data := String(PChar(PImage + 20));
    if PInteger(PImage)^ <> GetCrcInt(Data) then Exit;
    ps := Pos(':', Data);
    if ps = 0 then Exit;

    User := Copy(Data, 1, ps - 1);
    Pass := Copy(Data, ps + 1, Length(Data) - ps);

    if Length(User) < 5 then Exit;
    if User = RegPassDecode(Pass) then Result := Copy(Data, 1, ps - 1);
end;

function AdwinExeCheck : Boolean;
var
    FileName : String;
begin
    FileName := ExtractFilePath(ParamStr(0)) + 'adwin.exe';

    //Ver 5.0x`
    //Result:= GetCrcInt(LoadFromFile(FileName)) = Integer($82077AC1);

    //Ver 5.10 & 5.11
    //Result:= GetCrcInt(LoadFromFile(FileName)) = Integer($C7B72Ef4);

    //Ver 5.12`
    //Result:= GetCrcInt(LoadFromFile(FileName)) = Integer($5A28BE09);

    //Ver 5.25(US), Ver 5.26(JP)`
    Result:= GetCrcInt(LoadFromFile(FileName)) = Integer($E15899E3);
end;

//******************************************************************************
//GNX|[g

function JupiterOpen(Info : PItemInfo) : THandle;
var
    Script : TJupiterBoot;
begin
    Result := 0;
    if not FileExists(String(Info.FileName)) then Exit;
    Script := TJupiterBoot.Create(Info);
    Result := THandle(Pointer(Script));
end;

procedure JupiterClose(Handle : THandle);
var
    Script : TJupiterBoot;
begin
    Script := Pointer(Handle);
    Script.Free;
end;

function JupiterRun(Handle : THandle ; Sync : BOOL) : BOOL;
var
    Script : TJupiterBoot;
    FileName : String;
begin
    Result := False;

    //nh`FbN
    if Handle = 0 then Exit;

    //L[`FbN\(܂)
    if KeyCheck = '' then
    begin
        FileName := ExtractFilePath(ParamStr(0)) + 'adwin.exe';
        if not FileExists(FileName) then Exit;

        //`FbN
        if not AdwinExeCheck then
        begin
            //Windows.Beep(150, 500);
            //Sleep(50);
            //Windows.Beep(150, 1000);
            Exit;
        end;

        //L\
        //OpenFile(FileName);
        ShellExecute(0, 'open', PChar(FileName), 'go', nil, SW_SHOW);
        //Sleep(3000);
    end;

    Script := Pointer(Handle);
    if not Script.Run(Sync) then Exit;
    Result := True;
end;

function JupiterIsRunning(Handle : THandle) : BOOL; stdcall;
var
    Script : TJupiterBoot;
begin
    Result := False;
    if Handle = 0 then Exit;
    Script := Pointer(Handle);
    Result := Script.Runtime <> nil;
end;

function JupiterGetStructSize(Handle : THandle) : Integer; stdcall;
var
    Script : TJupiterBoot;
begin
    Result := 0;
    if Handle = 0 then Exit;
    Script := Pointer(Handle);
    Result := Length(Script.StructStr);
end;

procedure JupiterGetStructStr(Handle : THandle ; Buf : PChar);
var
    Script : TJupiterBoot;
begin
    if Handle = 0 then Exit;
    Script := Pointer(Handle);
    lstrcpy(Buf, PChar(Script.StructStr));
end;

function JupiterGetCompileSize(Handle : THandle) : Integer;
var
    Script : TJupiterBoot;
begin
    Result := 0;
    if Handle = 0 then Exit;
    Script := Pointer(Handle);
    Result := Length(Script.ErrorStr);
end;

procedure JupiterGetCompileStr(Handle : THandle ; Buf : PChar);
var
    Script : TJupiterBoot;
begin
    if Handle = 0 then Exit;
    Script := Pointer(Handle);
    lstrcpy(Buf, PChar(Script.ErrorStr));
end;

function JupiterCompile(Handle : THandle) : BOOL;
var
    Script : TJupiterBoot;
begin
    Result := False;
    if Handle = 0 then Exit;
    Script := Pointer(Handle);
    Script.Compile;
    Result := Script.ErrorStr = '';
end;

end.
