unit jp5_smtp;

interface

uses
	tn_dns, tn_socket, tn_utils, tn_classes;

type
	TNSmtpTransfer	=	class
    	private
        	DNS : TNDns;
    	public
        	LastMessage : String;
        	constructor Create(Server : String);
            destructor Destroy; override;
			function SendMessage(const From, RcptTo, Data : String) : Boolean;
    end;

implementation

uses
	jupiter;

constructor TNSmtpTransfer.Create(Server : String);
begin
	DNS := TNDns.Create;
    DNS.DnsServer := Server;
    LastMessage := '';
end;

destructor TNSmtpTransfer.Destroy;
begin
	DNS.Free;
	inherited;
end;

function TNSmtpTransfer.SendMessage(const From, RcptTo, Data : String) : Boolean;
var
	ps : Integer;
    host : String;
    m, n : Integer;
    pref : Integer;
    sock : TNSocket;
    sort : TNIntList;
    list : TNStringList;
begin
	Result := False;

    ps := Pos('@', RcptTo);
    if ps = 0 then Exit;

    host := Trim(Copy(RcptTo, ps + 1, Length(RcptTo) - ps));
    if host = '' then Exit;

    list := TNStringList.Create;

    if (DNS.AskMx(host)) and (DNS.Count <> 0) then
    begin
        sort := TNIntList.Create;

        for n := 0 to DNS.Count - 1 do
        begin
        	pref := DNS.Items[n].MXReference;
            if sort.IndexOf(pref) = -1 then sort.Add(pref);
        end;

        //ёւ
        sort.Sort;

        for n := 0 to sort.Count - 1 do
        begin
			pref := sort.GetValue(n);

			for m := 0 to DNS.Count - 1 do
            begin
            	if DNS.Items[m].MXReference = pref then
                begin
                	list.Add(DNS.Items[m].MxName);
                end;
            end;
        end;

        sort.Free;
    end;

    //ڑ
    sock := TNSocket.Create;

	if list.Count = 0 then
    begin
	    if not sock.Connect(host, 25) then host := '';
    end
    else
    begin
    	host := '';

	    for n := 0 to list.Count - 1 do
    	begin
			host := list.Strings[n];
		    if sock.Connect(host, 25) then Break;
    	    host := '';
	    end;
    end;

    //Xg͂͂sv
    list.Free;

    if host = '' then
    begin
    	//ڑs
    	sock.Free;
    	Exit;
    end;

    LastMessage := Trim(sock.ReadData(1024));

    if Copy(LastMessage, 1, 3) <> '220' then
    begin
    	sock.Free;
        Exit;
    end;

	//EHLO
    sock.SendCommand('EHLO ' + sock.LocalHost);
    LastMessage := Trim(sock.ReadData(1024));

    if Copy(LastMessage, 1, 3) <> '250' then
    begin
		//HELOłx
	    sock.SendCommand('HELO ' + sock.LocalHost);
	    LastMessage := Trim(sock.ReadData(1024));

	    if Copy(LastMessage, 1, 3) <> '250' then
    	begin
	    	sock.Free;
	        Exit;
        end;
    end;

    //MAIL FROM
    sock.SendCommand('MAIL FROM: <' + From + '>');
    LastMessage := Trim(sock.ReadData(1024));

    if Copy(LastMessage, 1, 3) <> '250' then
    begin
    	sock.Free;
        Exit;
    end;

    //RCPT TO
    sock.SendCommand('RCPT TO: <' + Trim(RcptTo) + '>');
    LastMessage := Trim(sock.ReadData(1024));

    if Copy(LastMessage, 1, 3) <> '250' then
    begin
    	sock.Free;
        Exit;
    end;

    //DATA
    sock.SendCommand('DATA');
    LastMessage := Trim(sock.ReadData(1024));

    if Copy(LastMessage, 1, 3) <> '354' then
    begin
    	sock.Free;
        Exit;
    end;

    //f[^𑗐M
    sock.SendCommand('X-Delivered: ' + UAString + '(http://hp.vector.co.jp/authors/VA015579/)');
	sock.SendString(Data);
    sock.SendCommand('');
    sock.SendCommand('.');

    LastMessage := Trim(sock.ReadData(1024));

    if Copy(LastMessage, 1, 3) <> '250' then
    begin
    	sock.Free;
        Exit;
    end;

    //QUIT
    sock.SendCommand('QUIT');
    LastMessage := Trim(sock.ReadData(1024));

    //I
    sock.Free;
    Result := True;
end;

end.
