library eucjp;

uses
    windows, tn_utils;

{$E .drv}

function RegistLanguage(Index : Integer ; Name : PChar) : BOOL; stdcall;
begin
    Result := True;
    case Index of
        0:
            lstrcpy(Name, 'EUC-JP');
        else
            Result := False;
    end;
end;

//ShiftJIS -> EUC-JP

function SystemToEncode(Src : PChar ; SrcSize : Integer ; var Dest : PChar) : Integer; stdcall;
var
    a , size : integer;
	st : String;
	fb , sb , shift , adj : byte;
    r : PChar;
    Buf : String;
begin
    //Result̏
    SetLength(Buf, SrcSize * 2);

    //Loop
    a := 1;
    size := 0;
    r := PChar(Buf);
    st := String(Src);

    while a <= SrcSize do
    begin
        if ByteType(st,a) = mbLeadByte then
        begin
            fb:=Byte(st[a]);
            sb:=Byte(st[a+1]);

            if fb <= 159 then
                shift := 112
            else
                shift := 176;

            if sb < 159  then
                adj := 1
            else
                adj := 0;

  		    fb := ((fb - shift) shl 1) - adj;
  		    shift := 126;

  		    if sb < 127 then
                shift := 31
            else if sb < 159 then
                shift := 32;

  		    sb := sb - shift;
      	    fb := fb + 128;
      	    sb := sb + 128;
            r^ := Chr(fb);
            (r+1)^ := Chr(sb);
            r := r + 2;
            size := size + 2;
      	    a:=a+1;
        end
        else
        begin
    	    fb:=Byte(st[a]);

  		    if (fb >= 161) and (fb <= 223) then
    	    begin
                r^ := #142;
                (r+1)^ := st[a];
                r := r + 2;
                size := size + 2;
    	    end
            else
    	    begin
                r^ := st[a];
                r := r + 1;
                size := size + 1;
    	    end;
        end;

        a:=a+1;
    end;

    Result := size;

    if Result = 0 then Exit;

    GetMem(Dest, Result + 1);
    CopyMemory(Dest, PChar(Buf), Result);
    (PChar(Buf) + Result)^ := #0;
    Result := Result + 1;
end;

//EUC-JP -> SJIS

function DecodeToSystem(Src : PChar ; SrcSize : Integer ; var Dest : PChar) : Integer; stdcall;
var
	a , size : integer;
	fb , sb , shift : Byte;
    r : PChar;
    Source : String;
    Buf : String;
begin
  	SetLength(Buf, SrcSize * 2);
    r := PChar(Buf);
  	a := 1;
    size := 0;
    Source := String(Src);

  	while a <= SrcSize do
  	begin
    	fb:=Byte(Source[a]);
    	if (fb >= 161) and (fb <= 254) then
    	begin
      		fb := Byte(Source[a]);
      		sb := Byte(Source[a+1]);
      		fb := fb - 128;
      		sb := sb - 128;
            shift := 126;
            if fb mod 2 = 1 then
            if sb < 96 then shift := 31 else shift := 32;
            sb := sb + shift;
            if fb < 95 then shift := 112 else shift := 176;
            fb := ((fb + 1) shr 1) + shift;
            r^ := AnsiChar(fb);
            (r+1)^ := AnsiChar(sb);
            r := r + 2;
            size := size + 2;
            //Result := Result + AnsiChar(fb) + AnsiChar(sb);
            a:=a+1;
    	end
        else
        begin
            if Byte(Source[a]) = 142 then
            begin //Kana (Code Set 0) $8E + Code
                //Result := Result + Source[a+1];
                r^ := Source[a+1];
                r := r + 1;
                size := size + 1;
                a:=a+1;
            end else
            begin
                //Result := Result + Source[a];
                r^ := Source[a];
                r := r + 1;
                size := size + 1;
            end;
        end;

        a:=a+1;
    end;

    Result := size;
    if size = 0 then Exit;

    GetMem(Dest, Result + 1);
    CopyMemory(Dest, PChar(Buf), Result);
    (PChar(Buf) + Result)^ := #0;
end;

procedure FreeMemory(Buffer : PChar ; Size : Integer); stdcall;
begin
    FreeMem(Buffer, Size);
end;

procedure DLLMain(reason:DWORD);
begin

end;

exports
    RegistLanguage      index 1,
    SystemToEncode      index 2,
    DecodeToSystem      index 3,
    FreeMemory          index 4;

begin
   DLLProc:=@DLLMain;
   DLLMain(DLL_PROCESS_ATTACH);
end.
