library iso2022jp;

uses
    windows, tn_utils, tn_classes;

{$E .drv}

function RegistLanguage(Index : Integer ; Name : PChar) : BOOL; stdcall;
begin
    Result := True;
    case Index of
        0:
            lstrcpy(Name, 'ISO-2022-JP');
        1:
            lstrcpy(Name, 'JIS');
        else
            Result := False;
    end;
end;

//ShiftJIS -> JIS

function SystemToEncode(Src : PChar ; SrcSize : Integer ; var Dest : PChar) : Integer; stdcall;
var
    Source : String;
	n : Longint;
    TwoBytes : Boolean;
    fb , sb , shift , adj :Byte;
    s : PChar;
    mem : TNMemory;
begin
  	//Init
    n := 0;
  	TwoBytes := false;

    s := Src;
    Source := String(s);

    mem := TNMemory.Create(64);

    while n < SrcSize do
    begin
    	if ByteType(Source, n + 1) <> btSingle then
    	begin
      		if not TwoBytes then //QoCg̊Jn
      		begin
        		TwoBytes    := True;
                mem.PushChar(#27);
                mem.PushChar('$');
                mem.PushChar('B');
      		end;

  			fb := Byte(s^);
        	sb := Byte((s+1)^);

  			if fb <= 159 then
                shift := 112
            else
                shift := 176;

  			if sb < 159  then
                adj := 1
            else
                adj := 0;

  			fb := ((fb - shift) shl 1) - adj;
  			shift := 126;

  			if sb < 127 then
                shift := 31
            else if sb < 159 then
                shift := 32;

  			sb := sb - shift;
            mem.PushChar(Char(fb));
            mem.PushChar(Char(sb));
            Inc(s, 2);
            Inc(n, 2);
    	end
        else
    	begin
      		if TwoBytes then
      		begin
        		TwoBytes := False;
                mem.PushChar(#27);
                mem.PushChar('(');
                mem.PushChar('B');
                mem.PushChar(s^);
                Inc(s);
            end
            else
            begin
            	mem.PushChar(s^);
                Inc(s);
            end;

            Inc(n);
  		end;
    end;

    if TwoBytes then
    begin
    	mem.PushChar(#27);
    	mem.PushChar('(');
    	mem.PushChar('B');
    end;

	//NULL
    mem.PushChar(#0);

	Result := mem.Size;

    if Result = 0 then
    begin
    	mem.Free;
    	Exit;
    end;

    GetMem(Dest, mem.Size);
	Move(mem.Data^, Dest^, mem.Size);
    mem.Free;
end;

//JIS -> SJIS

function DecodeToSystem(Src : PChar ; SrcSize : Integer ; var Dest : PChar) : Integer; stdcall;
var
	source : String;
    p : PChar;
    n : Integer;
    mem : TNMemory;
    ch : Char;
    db : Boolean;
    lb, tb, shift : Byte;
begin
    n := 0;
    db := False;
	Source := String(Src) + '          ';
    p := PChar(Source);
    mem := TNMemory.Create(256);

	while n < SrcSize do
    begin
		ch := p^;
        Inc(p);
        Inc(n);

        if ch = #27 then
        begin
			ch := p^;

    		if ch = '$' then
            begin
            	db := True;
                Inc(p, 2);
                Inc(n, 2);
            end
            else if ch = '(' then
            begin
            	db := False;
                Inc(p, 2);
                Inc(n, 2);
            end;
        end
        else if db then
        begin
        	lb := Byte(ch);
            tb := Byte(p^);

            if (lb < 33) or (lb > 126) then
            begin
            	mem.PushChar(ch);
            	Continue;
            end
            else
            begin
            	shift := 126;
                if lb mod 2 = 1 then
                if tb < 96 then shift := 31 else shift := 32;
                tb := tb + shift;
                if lb < 95 then shift := 112 else shift := 176;
                lb := ((lb + 1) shr 1) + shift;

                mem.PushChar(Char(lb));
                mem.PushChar(Char(tb));

                Inc(p);
                Inc(n);
            end;
        end
        else
        	mem.PushChar(ch);
	end;

    mem.PushChar(#0);

    GetMem(Dest, mem.Size);
    CopyMemory(Dest, mem.Data, mem.Size);
    Result := mem.Size;
end;

procedure FreeMemory(Buffer : PChar ; Size : Integer); stdcall;
begin
    FreeMem(Buffer, Size);
end;

procedure DLLMain(reason:DWORD);
begin

end;

exports
    RegistLanguage      index 1,
    SystemToEncode      index 2,
    DecodeToSystem      index 3,
    FreeMemory          index 4;

begin
   DLLProc:=@DLLMain;
   DLLMain(DLL_PROCESS_ATTACH);
end.
