//	POP protocol support script by T.Nak
//	ώRE]ڎR

class Pop
{
	var sock;
	var msg;
	var apop;

	function Pop()
	{
		sock = new Socket();
		apop = "";
		msg = "";
	}

	function connect(Server, Port)
	{
		if (!sock.connect(Server, Port))
		{
			return false;
		}

		msg = sock.readLine().trim();

		if (msg.substr(0, 3) != "+OK")
		{
			sock.close();
			return false;
		}

		apop = msg.sliceString("<", ">");
		return true;
	}

	function quit()
	{
		sock.sendCommand('QUIT');
		msg = sock.readLine();
		sock.close();
	}

	function login(UserID, Password)
	{
		if (!sock.isConnected) return;

		if (!Jupiter._APOP)
		{
			sock.sendCommand('USER ' + UserID);
			msg = sock.readLine();
			sock.sendCommand('PASS ' + Password);
			msg = sock.readLine();

			if (msg.substr(0, 3) == "+OK")
			{
				return true;
			}
		}
		else
		{
			enc = Jupiter.md5Encode("<" + apop + ">" + Password);
			sock.sendCommand("APOP " + UserID + " " + enc);
			msg = sock.readLine();

			if (msg.substr(0, 3) == "+OK")
			{
				return true;
			}

			sock.sendCommand('USER ' + UserID);
			msg = sock.readLine();
			sock.sendCommand('PASS ' + Password);
			msg = sock.readLine();

			if (msg.substr(0, 3) == "+OK")
			{
				return true;
			}
		}

		return false;
	}

	function uidl()
	{
		if (!sock.isConnected) return;

		result = new Array();
		sock.sendCommand('UIDL');

		//ŏ̍s擾
		temp = sock.readLine();
		result.concat(temp);
		if (msg.substr(0, 3) != "+OK") return result;

		while (true)
		{
			temp = sock.readLine();
			if (temp.trim() == ".") break;
			result.concat(temp);
		}

		return result;
	}

	function retr(index)
	{
		list = new StringList();

		if (!sock.isConnected) return "";

		//R}h𔭍s
		sock.sendCommand('RETR ' + index);

		//ŏ̍s擾
		temp = sock.readLine();
		if (temp.substr(0, 3) != "+OK") return "";

		//"."܂Ŏ擾
		while (true)
		{
			temp = Jupiter.adjustCrlf(sock.readLine());
			temp = temp.substr(0, temp.length - 2);
			if (temp.trim() == ".") break;
			list.add(temp);
		}

		return list.text;
	}

	function dele(index)
	{
		if (!sock.isConnected) return false;

		//R}h𔭍s
		sock.sendCommand('DELE ' + index);

		//擾
		temp = sock.readLine();
		return temp.substr(0, 3) == "+OK";
	}
}
