//	SMTP protocol support script by T.Nak
//	ώRE]ڎR

class Smtp
{
	var sock;
	var msg;

	function Smtp()
	{
		sock = new Socket();
		msg = "";
	}

	function connect(Server, Port)
	{
		if (!sock.connect(Server, Port))
		{
			return false;
		}

		msg = sock.read(1024).trim();

		if (msg.substr(0, 3) != "220")
		{
			sock.close();
			return false;
		}

		return true;
	}

	function quit()
	{
		sock.sendCommand('QUIT');
		msg = sock.readLine();
		sock.close();
	}

	function login(UserID, Password)
	{
		sock.sendCommand('HELO ' + sock.localHost);
		msg = sock.read(1024).trim();
		return msg.substr(0, 3) == "250";
	}

	function mail_from(from)
	{
		sock.sendCommand('MAIL FROM: <' + from + '>');
		msg = sock.readLine();
		return msg.substr(0, 3) == "250";
	}

	function rcpt_to(to)
	{
		sock.sendCommand('RCPT TO: <' + to + '>');
		msg = sock.readLine();
		return msg.substr(0, 3) == "250";
	}

	function data(src)
	{
		sock.sendCommand('DATA');
		msg = sock.readLine();

		if (msg.substr(0, 3) != "354") return false;

		sock.sendCommand(src);
		sock.sendCommand('.');
		msg = sock.readLine();
		return msg.substr(0, 3) == "250";

		return true;
	}
}
