unit jp5_jobdlg;

interface

uses
    windows, messages, commctrl, shellapi, tn_utils, tn_classes, jp5_dll
    , jp5_kern, tn_listview, jp5_item, tn_stdctl;

const
    JOB_DLG         =   2002;

var
    ImgHandle : HIMAGELIST;
    PopupMenu : HMENU;
    Buf : array [0..255] of Char;
    LastSelected : Integer;

//\[X
const
    JOB_TITLE       =   3001;
    JOB_STATUS      =   3002;
    JOB_SCRIPT      =   3003;
    JOB_POPBOX      =   3004;
    JOB_TEMPDATA    =   3005;

    JOB_WORKED      =   3011;
    JOB_STOPPED     =   3012;

    ITEM_NEW        =   3201;

    ITEM_DELETE     =   3401;
    ITEM_CANTDEL    =   3402;

    NOW_CONNECTING  =   3601;
    NOW_DOWNLOAD    =   3602;
    NOW_FINISH      =   3603;
    
//ACR
    IMG_WORKING     =   0;
    IMG_SLEEP       =   1;
    IMG_ERROR       =   2;

//bZ[W
const
    JOB_RUNITEM     =   5001;
    JOB_STOPITEM    =   5002;

    JOB_EXECALL     =   5101;
    JOB_STOPALL     =   5102;

    JOB_ADDITEM     =   5201;
    JOB_DELETE      =   5202;
    JOB_ITEMSET     =   5203;

    JOB_ITEMDIS     =   5301;
    JOB_ITEMENA     =   5302;
    JOB_UPDATE      =   5401;

//procedure
    procedure ShowJobDlg;
    procedure SetListView(Handle : THandle);
    procedure SetMessages(Handle : THandle);
    procedure DeleteItem(Path : String);
    procedure UpdateItem(Handle : THandle ; Index : Integer);

implementation

procedure ShowJobDlg;

    function DialogCallBack(hDlg : THandle ; uMsg : Cardinal ; wParam : Integer ; lParam : integer) : BOOL; stdcall;
    var
        dummy : Integer;
        Handle : THandle;
        tp : TPoint;
        Action : PNMLISTVIEW;
        Style : Cardinal;
        Info : TAccitemInfo;
        Path : String;
        temp : String;
        Count : Integer;
        ItemIndex : Integer;
        NowIndex : Integer;
        JpMsg : PJpMessage;
        JpCount : PJpCounter;
        DLInfo : PDownLoadInfo;
        ProgPos : Integer;
        n : Integer;
    begin
        Result := True;

        case uMsg of
            WM_COMMAND:
                begin
                    case WParam of
                        JOB_RUNITEM:
                            begin
                                //IACes
                                Handle := GetDlgItem(hDlg, 1000);
                                ItemIndex := StrToInt(LV_GetItem(Handle, LV_GetIndex(Handle), 10));
                                SendMessage(GetDlgItem(hDlg, 1001)
                                                , LB_RESETCONTENT, 0, 0);
                                SendMessage(TrayHandle, WM_JPSTART, ItemIndex, 0);
                            end;

                        JOB_STOPITEM:
                            begin
                                //IACe~
                                Handle := GetDlgItem(hDlg, 1000);
                                ItemIndex := StrToInt(LV_GetItem(Handle, LV_GetIndex(Handle), 10));
                                SendMessage(TrayHandle, WM_JPSTOP, ItemIndex, 0);
                            end;

                        JOB_EXECALL:
                            begin
                                //ׂĎs
                                for n := 0 to Items.Count - 1 do
                                begin
                                    if Items.Statuses.GetValue(n) = Integer(ITEM_IDLE) then
                                        Items.Statuses.SetValue(n, Integer(ITEM_WAIT));
                                end;
                            end;

                        JOB_STOPALL:
                            begin
                                //s̃ACeׂĒ~
                                for n := 0 to Items.Count - 1 do
                                begin
                                    case TScriptStatus(Items.Statuses.GetValue(n)) of
                                        ITEM_EXEC, ITEM_WAIT:
                                            SendMessage(TrayHandle, WM_JPSTOP, n, 0);
                                    end;
                                end;
                            end;

                        JOB_ADDITEM:
                            begin
                                //ACeǉ
                                Info.Title := LoadResourceString(ITEM_NEW);
                                Info.ScriptTitle := '';
                                Info.User := '';
                                Info.Pass := '';
                                Info.Address := '';
                                Info.Option := '';
                                Info.SaveCache := False;
                                Info.SaveCookie := True;
                                Info.Disable := False;

                                if ShowItemDlg(hDlg, Info) then
                                begin
                                    Path := CreateNewItemFolder(
                                                    ExtractFilePath(ParamStr(0))
                                                        + 'datas\');
                                    if Path <> '' then
                                    begin
                                        Info.FileName := Path + 'item.ini';
                                        SaveItem(Info);
                                        Items.Add(Path);
                                        SetListView(hDlg);
                                        SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                                    end;
                                end;
                            end;

                        JOB_ITEMSET:
                            begin
                                //ACe̐ݒύX
                                Handle := GetDlgItem(hDlg, 1000);
                                ItemIndex := StrToInt(LV_GetItem(Handle, LV_GetIndex(Handle), 10));
                                temp := Items.Paths.Strings[ItemIndex] + 'item.ini';
                                Info := LoadItem(temp);

                                if ShowItemDlg(hDlg, Info) then
                                begin
                                    Items.Titles.Strings[ItemIndex] := Info.Title;
                                    Items.Scripts.Strings[ItemIndex] := Info.ScriptTitle;
                                    Items.Mails.Strings[ItemIndex] := Info.Address;

                                    if Info.Disable then
                                        Items.Statuses.Values[ItemIndex] := Integer(ITEM_DISABLE)
                                    else
                                        Items.Statuses.Values[ItemIndex] := Integer(ITEM_IDLE);

                                    Items.Times.Values[ItemIndex] := Info.Time;
                                    Items.ExecType.Values[ItemIndex] := Integer(Info.IntCheck);

                                    SaveItem(Info);
                                    SetListView(hDlg);
                                    UpdateItem(Handle, ItemIndex);

                                    //j[̍XV
                                    SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);

                                    //ԂZbg
                                    if Items.ExecType.GetValue(ItemIndex) = Integer(EXE_HOUR) then
                                        Items.Lasts.SetValue(ItemIndex, 0)
                                    else
                                        Items.Lasts.SetValue(ItemIndex, NowDateTime);
                                end;
                            end;

                        JOB_DELETE:
                            begin
                                //IACe̍폜
                                Handle := GetDlgItem(hDlg, 1000);
                                ItemIndex := StrToInt(LV_GetItem(Handle, LV_GetIndex(Handle), 10));

                                //sǂ
                                if Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_EXEC) then
                                begin
                                    MessageBox(hDlg
                                        , PChar(LoadResourceString(ITEM_CANTDEL))
                                        , PChar(TITLE)
                                        , MB_TOPMOST or MB_SETFOREGROUND
                                                        or MB_ICONWARNING);
                                    Result := False;
                                    Exit;
                                end;

                                temp := Format(LoadResourceString(ITEM_DELETE)
                                            , [Items.Titles.Strings[ItemIndex]]);

                                if MessageBox(hDlg, PChar(temp), PChar(TITLE)
                                        , MB_YESNO or MB_TOPMOST
                                            or MB_SETFOREGROUND
                                                or MB_ICONWARNING) = IDYES then
                                begin
                                    DeleteItem(Items.Paths.Strings[ItemIndex]);
                                    Items.Delete(ItemIndex);
                                    SetListView(hDlg);

                                    //j[̍XV
                                    SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                                end;
                            end;

                        JOB_ITEMDIS:
                            begin
                                //IꂽACe𖳌ɂ
                                Handle := GetDlgItem(hDlg, 1000);
                                ItemIndex := StrToInt(LV_GetItem(Handle, LV_GetIndex(Handle), 10));

                                Items.Statuses.SetValue(ItemIndex, Integer(ITEM_DISABLE));
                                SaveSettings(Items.Paths.Strings[ItemIndex] + 'item.ini', 'Disable', 'True');
                                UpdateItem(Handle, ItemIndex);

                                //j[̍XV
                                SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                            end;

                        JOB_ITEMENA:
                            begin
                                //IꂽACeLɂ
                                Handle := GetDlgItem(hDlg, 1000);
                                ItemIndex := StrToInt(LV_GetItem(Handle, LV_GetIndex(Handle), 10));

                                Items.Statuses.SetValue(ItemIndex, Integer(ITEM_IDLE));
                                SaveSettings(Items.Paths.Strings[ItemIndex] + 'item.ini', 'Disable', 'False');
                                UpdateItem(Handle, ItemIndex);

                                //j[̍XV
                                SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                            end;

                        JOB_UPDATE:
                            begin
                                //Xgr[\
                                SetListView(hDlg);
                                //j[̍XV
                                SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                            end;
                    end;

                    Result := False;
                end;

            WM_INITDIALOG:
                begin
                    Result := False;
                    Handle := GetDlgItem(hDlg, 1000);
                    LastSelected := -1;

                    //WuEBhẼnh擾
                    JobHandle := hDlg;

                    //j[[h
                    PopupMenu := GetSubMenu(Loadmenu(hInstance, MAKEINTRESOURCE(3001)), 2);

                    //X^Cݒ
                    LV_SetStyle(Handle, LVS_EX_FULLROWSELECT or LVS_EX_GRIDLINES);

                    //C[WXgݒ
                    ImgHandle := ImageList_LoadImage(hInstance, 'JOB_IMG', 16, 0
                        , RGB(255, 0, 255), IMAGE_BITMAP, LR_CREATEDIBSECTION);
                    //ImgHandle := ImageList_LoadBitmap(hInstance
                    //                , 'JOB_IMG', 16, 0, RGB($FF, 0, $FF));
                    LV_SetImageList(Handle, ImgHandle);

                    //Jݒ
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_TITLE)), 200);
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_STATUS)), 70);
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_SCRIPT)), 100);
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_POPBOX)), 50);
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_TEMPDATA)), 50);
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_TEMPDATA)), 0);
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_TEMPDATA)), 0);
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_TEMPDATA)), 0);
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_TEMPDATA)), 0);
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_TEMPDATA)), 0);
                    LV_AddColumn(Handle, PChar(LoadResourceString(JOB_TEMPDATA)), 0);

                    //X^Cݒ
                    Style := GetWindowLong(hDlg, GWL_EXSTYLE) or WS_EX_APPWINDOW;
                    SetWindowLong(hDlg, GWL_EXSTYLE, Style);

                    //Xgr[\
                    SetListView(hDlg);

                    //vOXo[̐ݒ
                    SendMessage(GetDlgItem(hDlg, 1008), PBM_SETRANGE, 0
                                    , MAKELPARAM(0, 100));

                    SetActiveWindow(hDlg);
                    SetForegroundWindow(hDlg);
                end;

            WM_DRAWITEM:
                begin
                end;

            WM_NOTIFY:
                begin
                    case WParam of
                        1000:
                            begin
                                Action := Pointer(lParam);
                                Result := False;
                                Handle := GetDlgItem(hDlg, 1000);

                                if (Action.hdr.code = NM_CLICK)
                                    or (Action.hdr.code = NM_RCLICK) then
                                begin

                                    if (LastSelected <> -1)
                                        and (LV_GetIndex(Handle) = -1) then
                                    begin
                                        LastSelected := -1;
                                        SendMessage(GetDlgItem(hDlg, 1001), LB_RESETCONTENT, 0, 0);
                                        Exit;
                                    end;

                                    temp := LV_GetItem(Handle, LV_GetIndex(Handle), 10);
                                    ItemIndex := StrToInt(temp);

                                    //ڂ͕ύXĂȂ
                                    if LastSelected = ItemIndex then Exit;

                                    //vOXo[Zbg
                                    SendMessage(GetDlgItem(hDlg, 1008), PBM_SETPOS, 0, 0);

                                    //bZ[W\
                                    LastSelected := ItemIndex;
                                    SetMessages(hDlg);
                                end;
                            end;

                        1001:
                            begin
                                Result := True;
                                
                            end;
                    end;
                end;

            WM_CLOSE:
                begin
                    dummy := 0;
                    ImageList_Destroy(ImgHandle);
                    EndDialog(hDlg, dummy);
                    SendMessage(TrayHandle, WM_COMMAND, JP_HIDEJOB, 0);
                    DestroyMenu(PopupMenu);
                    Result := False;
                end;

            WM_RBUTTONUP, WM_NCRBUTTONUP:
                begin
                    Result := True;
                end;

            WM_CONTEXTMENU:
                begin
                    //|bvAbvj[̐ݒ
                    GetCursorPos(tp);
                    Handle := GetDlgItem(hDlg, 1000);
                    Count := LV_GetSelectedCount(Handle);

                    if Count = 0 then
                    begin
                        EnableMenuItem(PopupMenu, 5001, MF_BYCOMMAND or MF_GRAYED);
                        EnableMenuItem(PopupMenu, 5002, MF_BYCOMMAND or MF_GRAYED);

                        EnableMenuItem(PopupMenu, 5202, MF_BYCOMMAND or MF_GRAYED);
                        EnableMenuItem(PopupMenu, 5203, MF_BYCOMMAND or MF_GRAYED);

                        EnableMenuItem(PopupMenu, 5301, MF_BYCOMMAND or MF_GRAYED);
                        EnableMenuItem(PopupMenu, 5302, MF_BYCOMMAND or MF_GRAYED);
                    end
                    else
                    begin
                        temp := LV_GetItem(Handle, LV_GetIndex(Handle), 10);
                        ItemIndex := StrToInt(temp);

                        EnableMenuItem(PopupMenu, 5202, MF_BYCOMMAND or MF_ENABLED);

                        if (Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_EXEC))
                            or (Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_WAIT)) then
                        begin
                            //s
                            EnableMenuItem(PopupMenu, 5001, MF_BYCOMMAND or MF_GRAYED);
                            EnableMenuItem(PopupMenu, 5002, MF_BYCOMMAND or MF_ENABLED);

                            EnableMenuItem(PopupMenu, 5203, MF_BYCOMMAND or MF_GRAYED);

                            EnableMenuItem(PopupMenu, 5301, MF_BYCOMMAND or MF_GRAYED);
                            EnableMenuItem(PopupMenu, 5302, MF_BYCOMMAND or MF_GRAYED);
                        end
                        else
                        begin
                            //~
                            EnableMenuItem(PopupMenu, 5002, MF_BYCOMMAND or MF_GRAYED);
                            EnableMenuItem(PopupMenu, 5203, MF_BYCOMMAND or MF_ENABLED);

                            if Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_DISABLE) then
                            begin
                                EnableMenuItem(PopupMenu, 5001, MF_BYCOMMAND or MF_GRAYED);
                                EnableMenuItem(PopupMenu, 5301, MF_BYCOMMAND or MF_GRAYED);
                                EnableMenuItem(PopupMenu, 5302, MF_BYCOMMAND or MF_ENABLED);
                            end
                            else
                            begin
                                EnableMenuItem(PopupMenu, 5001, MF_BYCOMMAND or MF_ENABLED);
                                EnableMenuItem(PopupMenu, 5301, MF_BYCOMMAND or MF_ENABLED);
                                EnableMenuItem(PopupMenu, 5302, MF_BYCOMMAND or MF_GRAYED);
                            end;
                        end;
                    end;

                    TrackPopupMenu(PopupMenu
                                        , TPM_LEFTALIGN or TPM_RIGHTBUTTON
                                            , tp.x, tp.y, 0, hDlg, nil);
                    Result := False;
                end;

            WM_JPMSG:
                begin
                    //bZ[WĂ
                    Result := False;
                    JpMsg := Pointer(WParam);

                    if JpMsg.Handle <> 0 then
                    begin
                        //nhŎw -> CfbNX֕ϊ
                        ItemIndex := Items.Handles.IndexOf(JpMsg.Handle);
                        if ItemIndex = -1 then Exit;
                    end
                    else
                    begin
                        //CfbNXŎw
                        if (JpMsg.Index < 0)
                            or (JpMsg.Index >= Items.Count) then Exit;

                        ItemIndex := JpMsg.Index;
                    end;

                    //Xgr[̃nh
                    Handle := GetDlgItem(hDlg, 1000);

                    if JpMsg.Types = mtMessage then
                    begin
                        //݂̃CfbNX擾
                        temp := LV_GetItem(Handle, LV_GetIndex(Handle), 10);
                        if temp = '' then Exit;
                        NowIndex := StrToInt(temp);

                        //Xg{bNXɈsǉ
                        if ItemIndex = NowIndex then
                        begin
                            Handle := GetDlgItem(hDlg, 1001);
                            SendMessage(Handle, LB_ADDSTRING, 0, Integer(JpMsg.MessageStr));
                            n := List_Count(Handle);
                            List_SetIndex(Handle,  n - 1);
                        end;
                    end
                    else if JpMsg.Types = mtUpdate then
                    begin
                        UpdateItem(Handle, ItemIndex);
                    end;
                end;

            WM_JPSETCOUNTER:
                begin
                    JpCount := Pointer(WParam);
                    SendMessage(GetDlgItem(hDlg, 1002), WM_SETTEXT
                                , 0, Integer(PChar(IntToStr(JpCount.Stop))));

                    SendMessage(GetDlgItem(hDlg, 1003), WM_SETTEXT
                                , 0, Integer(PChar(IntToStr(JpCount.Run))));

                    SendMessage(GetDlgItem(hDlg, 1004), WM_SETTEXT
                                , 0, Integer(PChar(IntToStr(JpCount.Wait))));

                    SendMessage(GetDlgItem(hDlg, 1005), WM_SETTEXT
                                , 0, Integer(PChar(IntToStr(JpCount.Err))));
                end;

            WM_JPCONNECT:
                begin
                    Handle := GetDlgItem(hDlg, 1000);
                    temp := LV_GetItem(Handle, LV_GetIndex(Handle), 10);
                    if temp = '' then Exit;
                    NowIndex := StrToInt(temp);
                    ItemIndex := Items.Handles.IndexOf(WParam);

                    //URLۑ
                    if ItemIndex <> -1 then
                        Items.Urls.Strings[ItemIndex] := String(PChar(Pointer(LParam)));

                    //\̍XV
                    if NowIndex = ItemIndex then
                    begin
                        //SendMessage(GetDlgItem(hDlg, 1006), WM_SETTEXT
                        //        , 0, Integer(PChar(LoadResourceString(NOW_DOWNLOAD))));

                        SendMessage(GetDlgItem(hDlg, 1007), WM_SETTEXT, 0, LParam);
                        SendMessage(GetDlgItem(hDlg, 1008), PBM_SETPOS, 0, 0);

                    end;
                end;

            WM_JPDOWNLOAD:
                begin
                    Result := False;
                    Handle := GetDlgItem(hDlg, 1000);
                    temp := LV_GetItem(Handle, LV_GetIndex(Handle), 10);
                    if temp = '' then Exit;
                    NowIndex := StrToInt(temp);
                    DLInfo := Pointer(WParam);

                    if Items.Handles.GetValue(NowIndex) = Integer(DLInfo.Handle) then
                    begin
                        if DLInfo.Length = 0 then Exit;
                        ProgPos := Trunc(DLInfo.Pos * 100 / DLInfo.Length);

                        //vOXo[̐ݒ
                        Handle := GetDlgItem(hDlg, 1008);
                        SendMessage(Handle, PBM_SETPOS, ProgPos, 0);
                    end;
                end;

            WM_JPFINISH:
                begin
                    Result := False;
                    Handle := GetDlgItem(hDlg, 1000);
                    temp := LV_GetItem(Handle, LV_GetIndex(Handle), 10);
                    if temp = '' then Exit;
                    NowIndex := StrToInt(temp);

                    if Items.Handles.GetValue(NowIndex) = WParam then
                    begin
                        //eLXg̐ݒ
                        //SendMessage(GetDlgItem(hDlg, 1006), WM_SETTEXT
                        //        , 0, Integer(PChar(LoadResourceString(NOW_FINISH))));

                        //vOXo[̐ݒ
                        Handle := GetDlgItem(hDlg, 1008);
                        SendMessage(Handle, PBM_SETPOS, 0, 0);
                    end;
                end;

            else
                Result := False;
        end;
    end;

begin
    SetActiveWindow(GetDesktopWindow);
    SetForegroundWindow(GetDesktopWindow);
    DialogBox(hInstance, MAKEINTRESOURCE(JOB_DLG), TrayHandle, @DialogCallBack);
    JobHandle := 0;
end;

procedure SetListView(Handle : THandle);
var
    n : Integer;
    List : TNStringList;
    ImgIndex : Integer;
    ListHandle : THandle;
    //Files : TNStringList;
begin
    List := TNStringList.Create;
    ListHandle := GetDlgItem(Handle, 1000);

    //ACeׂč폜
    ListView_DeleteAllItems(ListHandle);

    //ACe\
    for n := 0 to Items.Count - 1 do
    begin
        List.Clear;
        List.Add(Items.Titles.Strings[n]);

        ImgIndex := Items.Statuses.GetValue(n);
        List.Add(LoadResourceString(3011 + ImgIndex));
        List.Add(Items.Scripts.Strings[n]);

        //POPT[oɃXv[ꂽf[^
        //Files := SearchFile(Items.Paths.Strings[n] + 'savebox\*.eml');
        //List.Add(IntToStr(Files.Count));
        //Files.Free;
        List.Add(IntToStr(SearchFileCount(Items.Paths.Strings[n] + 'savebox\*.eml')));

        //SMTPT[oɃXv[ꂽf[^
        //Files := SearchFile(Items.Paths.Strings[n] + 'loadbox\*.eml');
        //List.Add(IntToStr(Files.Count));
        //Files.Free;
        List.Add(IntToStr(SearchFileCount(Items.Paths.Strings[n] + 'loadbox\*.eml')));

        //̊ĝ߂Ɋm
        List.Add('');
        List.Add('');
        List.Add('');
        List.Add('');
        List.Add('');

        //CfbNX
        List.Add(IntToStr(n));

        //Xgr[ɒǉ
        LV_AddItem(ListHandle, List, ImgIndex);
    end;

    List.Free;
end;

procedure SetMessages(Handle : THandle);
var
    temp : String;
    Index : Integer;
    ListHandle : THandle;
    MsgHandle : THandle;
    Lines : TNStringList;
    n : Integer;
begin
    //
    ListHandle := GetDlgItem(Handle, 1000);
    MsgHandle := GetDlgItem(Handle, 1001);
    temp := LV_GetItem(ListHandle, LV_GetIndex(ListHandle), 10);
    if temp = '' then Exit;
    Index := StrToInt(temp);

    //ׂĂ̍ڂ폜
    SendMessage(MsgHandle, LB_RESETCONTENT, 0, 0);

    Lines := TNStringList.Create;
    Lines.Text := Items.Messages.Strings[Index];

    for n := 0 to Lines.Count - 1 do
    begin
        SendMessage(MsgHandle, LB_ADDSTRING, 0, Integer(PChar(Lines.Strings[n])));
    end;

    //URLZbg
    SendMessage(GetDlgItem(Handle, 1007)
                    , WM_SETTEXT, 0
                    , Integer(PChar(Items.Urls.Strings[Index])));

    Lines.Free;
end;

procedure DeleteItem(Path : String);
var
    Folders : TNStringList;
    Files : TNStringList;
    n : Integer;
begin
    Folders := SearchFolder(Path);
    Files := SearchFile(Path + '*.*');

    //t@C폜
    for n := 0 to Files.Count - 1 do
        DeleteFile(PChar(Path + Files.Strings[n]));

    //tH_폜
    for n := 0 to Folders.Count - 1 do
        DeleteItem(PChar(Path + Folders.Strings[n] + '\'));

    //IuWFNgj
    Folders.Free;
    Files.Free;

    //̃tH_폜
    RemoveDirectory(PChar(Path));
end;

procedure UpdateItem(Handle : THandle ; Index : Integer);
var
    List : TNStringList;
    ImgIndex : Integer;
    Files : TNStringList;
begin
    //ACeݒ̂߂StringList
    List := TNStringList.Create;
    List.Clear;
    List.Add(Items.Titles.Strings[Index]);

    ImgIndex := Items.Statuses.GetValue(Index);
    List.Add(LoadResourceString(3011 + ImgIndex));
    List.Add(Items.Scripts.Strings[Index]);

    //POPT[oɃXv[ꂽf[^
    Files := SearchFile(Items.Paths.Strings[Index] + 'savebox\*.eml');
    List.Add(IntToStr(Files.Count));
    Files.Free;

    //SMTPT[oɃXv[ꂽf[^
    Files := SearchFile(Items.Paths.Strings[Index] + 'loadbox\*.eml');
    List.Add(IntToStr(Files.Count));
    Files.Free;

    //̊ĝ߂Ɋm
    List.Add('');
    List.Add('');
    List.Add('');
    List.Add('');
    List.Add('');

    //CfbNX
    List.Add(IntToStr(Index));

    //Xgr[ɒǉ
    LV_SetItem(Handle, List, ImgIndex, Index);

    List.Free;
end;

end.
